/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.restImport;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Set;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.admin.IssueLinkStub;
import jetbrains.youtrack.core.persistent.IssueImpl;
import jetbrains.youtrack.rest.OldImportUtil;
import jetbrains.youtrack.restImport.ItemReport;
import jetbrains.youtrack.restImport.Link;
import jetbrains.youtrack.restImport.LinkOld;

public class LinkBean
implements IssueLinkStub {
    private Entity linkPrototype;
    private Entity source;
    private Entity target;
    private ItemReport itemReport;
    private Link link;
    private LinkOld oldLink;

    public LinkBean(Link link) {
        this.link = link;
    }

    public LinkBean(LinkOld link) {
        this.oldLink = link;
    }

    private Entity getLinkPrototype(String fieldName, String typeName) {
        Entity linkPrototype = null;
        if (typeName == null || typeName.length() == 0) {
            this.itemReport.requireField(fieldName);
        } else {
            linkPrototype = IssueLinkPrototypeImpl.find((String)typeName);
            if (EntityOperations.equals((Entity)linkPrototype, null)) {
                this.itemReport.unknownValue("typeName", typeName);
            }
        }
        return linkPrototype;
    }

    private Entity getIssue(String fieldName, String issueId) {
        Entity result2 = null;
        if (issueId == null || issueId.length() == 0) {
            this.itemReport.requireField(fieldName);
        } else {
            result2 = OldImportUtil.getIssueFromId(issueId);
            if (EntityOperations.equals((Entity)result2, null)) {
                this.itemReport.unknownValue(fieldName, issueId);
            }
        }
        return result2;
    }

    public void parse(Set<LinkBean> alreadyProcessed) {
        this.itemReport = new ItemReport();
        if (this.link != null) {
            this.linkPrototype = this.getLinkPrototype("typeName", this.link.getTypeName());
            this.source = this.getIssue("source", this.link.getSource());
            this.target = this.getIssue("target", this.link.getTarget());
        } else {
            this.linkPrototype = this.getLinkPrototype("typeName", this.oldLink.getTypeName());
            this.source = this.getIssue("source", this.oldLink.getSource());
            this.target = this.getIssue("target", this.oldLink.getTarget());
        }
        if (SetSequence.fromSet(alreadyProcessed).contains((Object)this)) {
            this.itemReport.notUnique("[linkType, source, target]", "[" + (String)PrimitiveAssociationSemantics.get((Entity)this.linkPrototype, (String)"name", String.class, null) + ", " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)this.source, (String)"Issue")).getId(this.source) + ", " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)this.target, (String)"Issue")).getId(this.target) + "]");
        } else {
            SetSequence.fromSet(alreadyProcessed).addElement((Object)this);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof LinkBean) {
            LinkBean that = (LinkBean)object;
            if (EntityOperations.equals((Entity)this.linkPrototype, (Object)that.linkPrototype)) {
                if (EntityOperations.equals((Entity)this.source, (Object)that.source) && EntityOperations.equals((Entity)this.target, (Object)that.target)) {
                    return true;
                }
                if (!((Boolean)PrimitiveAssociationSemantics.get((Entity)this.linkPrototype, (String)"directed", Boolean.class, null)).booleanValue() && EntityOperations.equals((Entity)this.target, (Object)that.source) && EntityOperations.equals((Entity)this.source, (Object)that.target)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int typeHashCode = EntityOperations.equals((Entity)this.linkPrototype, null) ? 0 : this.linkPrototype.hashCode();
        int sourceHashCode = EntityOperations.equals((Entity)this.source, null) ? 0 : this.source.hashCode();
        int targetHashCode = EntityOperations.equals((Entity)this.target, null) ? 0 : this.target.hashCode();
        return typeHashCode + sourceHashCode + targetHashCode;
    }

    @Override
    public Entity getLinkPrototype() {
        return this.linkPrototype;
    }

    @Override
    public Entity getSource() {
        return this.source;
    }

    @Override
    public Entity getTarget() {
        return this.target;
    }

    public ItemReport getItemReport() {
        return this.itemReport;
    }
}

