/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.export;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import jetbrains.charisma.date.BeansKt;
import jetbrains.charisma.date.DateTimeFormattersImpl;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.youtrack.api.reports.DataExportWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0014J\u0017\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u0017\u0010\u001b\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Ljetbrains/youtrack/reports/export/CsvWriter;", "Ljetbrains/youtrack/api/reports/DataExportWriter;", "Ljava/io/Closeable;", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "dateFormat", "Lorg/joda/time/format/DateTimeFormatter;", "firstValueInARow", "", "timeZone", "Lorg/joda/time/DateTimeZone;", "kotlin.jvm.PlatformType", "writer", "Ljava/io/BufferedWriter;", "escaped", "", "getEscaped", "(Ljava/lang/String;)Ljava/lang/String;", "close", "", "nextRow", "writeDate", "value", "", "(Ljava/lang/Long;)V", "writeEmptyValue", "writeFloat", "data", "", "(Ljava/lang/Float;)V", "writeInteger", "", "(Ljava/lang/Integer;)V", "writeString", "Companion", "youtrack-reports"})
public final class CsvWriter
implements DataExportWriter,
Closeable {
    private final DateTimeFormatter dateFormat;
    private final DateTimeZone timeZone;
    private final BufferedWriter writer;
    private boolean firstValueInARow;
    @NotNull
    public static final String FIELDS_SEPARATOR = ",";
    @NotNull
    public static final String LINE_SEPARATOR = "\r\n";
    public static final Companion Companion = new Companion(null);

    public void writeEmptyValue() {
        if (!this.firstValueInARow) {
            this.writer.append(FIELDS_SEPARATOR);
        }
        this.firstValueInARow = false;
    }

    public void writeString(@Nullable String value) {
        this.writeEmptyValue();
        String string = value;
        this.writer.append(string != null && (string = this.getEscaped(string)) != null ? (CharSequence)string : (CharSequence)"");
    }

    public void writeInteger(@Nullable Integer data) {
        Integer n = data;
        this.writeString(n != null ? String.valueOf(n) : null);
    }

    public void writeFloat(@Nullable Float data) {
        Float f = data;
        this.writeString(f != null ? String.valueOf(f.floatValue()) : null);
    }

    public void writeDate(@Nullable Long value) {
        if (value == null) {
            this.writeEmptyValue();
        } else {
            this.writeString(this.dateFormat.print((ReadableInstant)DateTimeOperations.convert((Long)value, (DateTimeZone)this.timeZone)));
        }
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public final void nextRow() {
        this.writer.append(LINE_SEPARATOR);
        this.firstValueInARow = true;
    }

    private final String getEscaped(@NotNull String $this$escaped) {
        return '\"' + StringsKt.replace$default((String)$this$escaped, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null) + '\"';
    }

    public CsvWriter(@NotNull OutputStream outputStream) {
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        DateTimeFormattersImpl dateTimeFormattersImpl = BeansKt.getDateFormatter();
        GeneralUserProfile generalUserProfile = jetbrains.charisma.persistent.BeansKt.getCurrentUser().getGeneralProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"currentUser.generalProfile");
        this.dateFormat = dateTimeFormattersImpl.getDateFormatterForName(generalUserProfile.getDateFieldFormat());
        GeneralUserProfile generalUserProfile2 = jetbrains.charisma.persistent.BeansKt.getCurrentUser().getGeneralProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile2, (String)"currentUser.generalProfile");
        this.timeZone = generalUserProfile2.getTimeZone();
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), 65536);
        this.firstValueInARow = true;
        this.writer.write("\ufeff");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/reports/export/CsvWriter$Companion;", "", "()V", "FIELDS_SEPARATOR", "", "LINE_SEPARATOR", "youtrack-reports"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

