/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.export;

import java.io.Closeable;
import java.io.OutputStream;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.youtrack.reports.export.XlsxCellStyleFactory;
import jetbrains.youtrack.reports.export.XlsxDataExportWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u001bJ2\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0019\u0010 \u001a\u0015\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001b\u0018\u00010!\u00a2\u0006\u0002\b#H\u0016\u00a2\u0006\u0002\u0010$J#\u0010%\u001a\u00020\u001b2\u0019\u0010 \u001a\u0015\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001b\u0018\u00010!\u00a2\u0006\u0002\b#H\u0016J2\u0010&\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010'2\u0019\u0010 \u001a\u0015\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001b\u0018\u00010!\u00a2\u0006\u0002\b#H\u0016\u00a2\u0006\u0002\u0010(J2\u0010)\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0019\u0010 \u001a\u0015\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001b\u0018\u00010!\u00a2\u0006\u0002\b#H\u0016\u00a2\u0006\u0002\u0010*J-\u0010+\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0019\u0010 \u001a\u0015\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001b\u0018\u00010!\u00a2\u0006\u0002\b#H\u0016J\u0014\u0010,\u001a\n \f*\u0004\u0018\u00010\"0\"*\u00020-H\u0002J'\u0010.\u001a\u00020\u001b*\u00020\"2\u0019\u0010 \u001a\u0015\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001b\u0018\u00010!\u00a2\u0006\u0002\b#H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\n \f*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\n \f*\u0004\u0018\u00010\u00170\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006/"}, d2={"Ljetbrains/youtrack/reports/export/XlsxWriter;", "Ljetbrains/youtrack/reports/export/XlsxDataExportWriter;", "Ljava/io/Closeable;", "outputStream", "Ljava/io/OutputStream;", "name", "", "(Ljava/io/OutputStream;Ljava/lang/String;)V", "columnNumber", "", "row", "Lorg/apache/poi/xssf/streaming/SXSSFRow;", "kotlin.jvm.PlatformType", "rowNumber", "styleFactory", "Ljetbrains/youtrack/reports/export/XlsxCellStyleFactory;", "timeZone", "Lorg/joda/time/DateTimeZone;", "getTimeZone", "()Lorg/joda/time/DateTimeZone;", "workbook", "Lorg/apache/poi/xssf/streaming/SXSSFWorkbook;", "worksheet", "Lorg/apache/poi/xssf/streaming/SXSSFSheet;", "getWorksheet", "()Lorg/apache/poi/xssf/streaming/SXSSFSheet;", "close", "", "nextRow", "writeDate", "data", "", "action", "Lkotlin/Function1;", "Lorg/apache/poi/xssf/streaming/SXSSFCell;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Long;Lkotlin/jvm/functions/Function1;)V", "writeEmptyValue", "writeFloat", "", "(Ljava/lang/Float;Lkotlin/jvm/functions/Function1;)V", "writeInteger", "(Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)V", "writeString", "newCell", "Lorg/apache/poi/ss/usermodel/CellType;", "safeAction", "youtrack-reports"})
public class XlsxWriter
implements XlsxDataExportWriter,
Closeable {
    private final SXSSFWorkbook workbook;
    private final XlsxCellStyleFactory styleFactory;
    private final SXSSFSheet worksheet;
    private int rowNumber;
    private int columnNumber;
    private SXSSFRow row;
    private final OutputStream outputStream;

    private final DateTimeZone getTimeZone() {
        GeneralUserProfile generalUserProfile = BeansKt.getCurrentUser().getGeneralProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"currentUser.generalProfile");
        return generalUserProfile.getTimeZone();
    }

    @Override
    public SXSSFSheet getWorksheet() {
        return this.worksheet;
    }

    @Override
    public void writeEmptyValue(@Nullable Function1<? super SXSSFCell, Unit> action) {
        SXSSFCell sXSSFCell = this.newCell(CellType.BLANK);
        boolean bl = false;
        boolean bl2 = false;
        SXSSFCell it = sXSSFCell;
        boolean bl3 = false;
        SXSSFCell sXSSFCell2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)sXSSFCell2, (String)"it");
        this.safeAction(sXSSFCell2, action);
    }

    @Override
    public void writeString(@Nullable String data, @Nullable Function1<? super SXSSFCell, Unit> action) {
        SXSSFCell cell = this.newCell(CellType.STRING);
        if (data != null) {
            cell.setCellValue(StringsKt.take((String)data, (int)Short.MAX_VALUE));
        }
        SXSSFCell sXSSFCell = cell;
        Intrinsics.checkExpressionValueIsNotNull((Object)sXSSFCell, (String)"cell");
        this.safeAction(sXSSFCell, action);
    }

    @Override
    public void writeInteger(@Nullable Integer data, @Nullable Function1<? super SXSSFCell, Unit> action) {
        SXSSFCell cell = this.newCell(CellType.NUMERIC);
        if (data != null) {
            cell.setCellValue((double)data.intValue());
        }
        SXSSFCell sXSSFCell = cell;
        Intrinsics.checkExpressionValueIsNotNull((Object)sXSSFCell, (String)"cell");
        this.safeAction(sXSSFCell, action);
    }

    @Override
    public void writeFloat(@Nullable Float data, @Nullable Function1<? super SXSSFCell, Unit> action) {
        SXSSFCell cell = this.newCell(CellType.NUMERIC);
        if (data != null) {
            cell.setCellValue((double)data.floatValue());
        }
        if (action == null) {
            SXSSFCell sXSSFCell = cell;
            Intrinsics.checkExpressionValueIsNotNull((Object)sXSSFCell, (String)"cell");
            sXSSFCell.setCellStyle(this.styleFactory.getDefaultFloatStyle());
        } else {
            SXSSFCell sXSSFCell = cell;
            Intrinsics.checkExpressionValueIsNotNull((Object)sXSSFCell, (String)"cell");
            sXSSFCell.setCellStyle(this.styleFactory.getFloatStyle());
            action.invoke((Object)cell);
        }
    }

    @Override
    public void writeDate(@Nullable Long data, @Nullable Function1<? super SXSSFCell, Unit> action) {
        SXSSFCell cell = this.newCell(CellType.BLANK);
        if (data != null) {
            cell.setCellValue(DateTimeOperations.convert((Long)data, (DateTimeZone)this.getTimeZone()).toCalendar(null));
        }
        if (action == null) {
            SXSSFCell sXSSFCell = cell;
            Intrinsics.checkExpressionValueIsNotNull((Object)sXSSFCell, (String)"cell");
            sXSSFCell.setCellStyle(this.styleFactory.getDefaultDateStyle());
        } else {
            SXSSFCell sXSSFCell = cell;
            Intrinsics.checkExpressionValueIsNotNull((Object)sXSSFCell, (String)"cell");
            sXSSFCell.setCellStyle(this.styleFactory.getDateStyle());
            action.invoke((Object)cell);
        }
    }

    @Override
    public void close() {
        this.workbook.write(this.outputStream);
        this.workbook.dispose();
        this.workbook.close();
    }

    public final void nextRow() {
        int n = this.rowNumber;
        this.rowNumber = n + 1;
        this.row = this.getWorksheet().createRow(n);
        this.columnNumber = 0;
    }

    private final void safeAction(@NotNull SXSSFCell $this$safeAction, Function1<? super SXSSFCell, Unit> action) {
        if (action != null) {
            $this$safeAction.setCellStyle(this.workbook.createCellStyle());
            action.invoke((Object)$this$safeAction);
        }
    }

    private final SXSSFCell newCell(@NotNull CellType $this$newCell) {
        int n = this.columnNumber;
        this.columnNumber = n + 1;
        return this.row.createCell(n, $this$newCell);
    }

    public XlsxWriter(@NotNull OutputStream outputStream, @NotNull String name) {
        SXSSFWorkbook sXSSFWorkbook;
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.outputStream = outputStream;
        SXSSFWorkbook sXSSFWorkbook2 = new SXSSFWorkbook(20);
        XlsxWriter xlsxWriter = this;
        boolean bl = false;
        boolean bl2 = false;
        SXSSFWorkbook it = sXSSFWorkbook2;
        boolean bl3 = false;
        it.setZip64Mode(Zip64Mode.AsNeeded);
        xlsxWriter.workbook = sXSSFWorkbook = sXSSFWorkbook2;
        this.styleFactory = new XlsxCellStyleFactory(this.workbook);
        this.worksheet = this.workbook.createSheet(WorkbookUtil.createSafeSheetName((String)name));
        int n = this.rowNumber;
        this.rowNumber = n + 1;
        this.row = this.getWorksheet().createRow(n);
    }

    @Override
    public void writeEmptyValue() {
        XlsxDataExportWriter.DefaultImpls.writeEmptyValue(this);
    }

    @Override
    public void writeString(@Nullable String data) {
        XlsxDataExportWriter.DefaultImpls.writeString(this, data);
    }

    @Override
    public void writeInteger(@Nullable Integer data) {
        XlsxDataExportWriter.DefaultImpls.writeInteger(this, data);
    }

    @Override
    public void writeFloat(@Nullable Float data) {
        XlsxDataExportWriter.DefaultImpls.writeFloat(this, data);
    }

    @Override
    public void writeDate(@Nullable Long data) {
        XlsxDataExportWriter.DefaultImpls.writeDate(this, data);
    }
}

