/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.agile.burndown;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.charisma.parser.date.DatePeriod;
import jetbrains.charisma.timetracking.BeansKt;
import jetbrains.charisma.timetracking.TimeTrackingProvider;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.persistent.XdUserExtKt;
import jetbrains.youtrack.reports.ReportCalculationMonitor;
import jetbrains.youtrack.reports.impl.agile.burndown.BurndownReportDataJson;
import jetbrains.youtrack.reports.impl.agile.burndown.XdBurndownReport;
import jetbrains.youtrack.reports.impl.history.DayDistributedDataBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001'B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001fH$J\b\u0010&\u001a\u00020\u0002H\u0014R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u0017X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006("}, d2={"Ljetbrains/youtrack/reports/impl/agile/burndown/BurndownDataBuilder;", "Ljetbrains/youtrack/reports/impl/history/DayDistributedDataBuilder;", "Ljetbrains/youtrack/reports/impl/agile/burndown/BurndownDataBuilder$DayData;", "report", "Ljetbrains/youtrack/reports/impl/agile/burndown/XdBurndownReport;", "period", "Ljetbrains/charisma/parser/date/DatePeriod;", "now", "", "(Ljetbrains/youtrack/reports/impl/agile/burndown/XdBurndownReport;Ljetbrains/charisma/parser/date/DatePeriod;J)V", "dueDate", "isSpentTimeCalculated", "", "()Z", "getReport", "()Ljetbrains/youtrack/reports/impl/agile/burndown/XdBurndownReport;", "sprintTotalEstimation", "", "getSprintTotalEstimation", "()F", "setSprintTotalEstimation", "(F)V", "xLabel", "", "getXLabel", "()Ljava/lang/String;", "yLabel", "getYLabel", "build", "Ljetbrains/youtrack/reports/impl/agile/burndown/BurndownReportDataJson;", "monitor", "Ljetbrains/youtrack/reports/ReportCalculationMonitor;", "calculateIdealBurndown", "", "zone", "Lorg/joda/time/DateTimeZone;", "calculateRealBurndown", "", "createDayData", "DayData", "youtrack-reports"})
public abstract class BurndownDataBuilder
extends DayDistributedDataBuilder<DayData> {
    private float sprintTotalEstimation;
    private final long dueDate;
    @NotNull
    private final XdBurndownReport report;

    protected final float getSprintTotalEstimation() {
        return this.sprintTotalEstimation;
    }

    protected final void setSprintTotalEstimation(float f) {
        this.sprintTotalEstimation = f;
    }

    @NotNull
    protected abstract String getYLabel();

    private final String getXLabel() {
        String string;
        if (this.report.getHidden()) {
            String string2 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("BurndownDataBuilder.Sprint_timeline", new Object[0]);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localizer.localizedMsg(\"\u2026Builder.Sprint_timeline\")");
        } else {
            String string3 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("BurndownDataBuilder.Timeline", new Object[0]);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"localizer.localizedMsg(\"\u2026ownDataBuilder.Timeline\")");
        }
        return string;
    }

    public boolean isSpentTimeCalculated() {
        return false;
    }

    protected abstract void calculateRealBurndown(@NotNull ReportCalculationMonitor var1);

    private final List<Float> calculateIdealBurndown(DateTimeZone zone) {
        HashSet<Long> burndownTimes = new HashSet<Long>();
        TimeTrackingProvider timeTrackingProvider = BeansKt.getTimeTrackingProvider();
        BurndownDataBuilder burndownDataBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        BurndownDataBuilder $this$run22 = burndownDataBuilder;
        boolean bl3 = false;
        for (long date = $this$run22.getFrom(); date < $this$run22.dueDate; date += 86400000L) {
            if (!timeTrackingProvider.isWorkDay(date, zone)) continue;
            burndownTimes.add(date);
        }
        ArrayList<Float> idealBurndown = new ArrayList<Float>();
        Collection collection = burndownTimes;
        boolean $this$run22 = false;
        float burndownInDay = !collection.isEmpty() ? this.sprintTotalEstimation / (float)burndownTimes.size() : 0.0f;
        float currentRemain = this.sprintTotalEstimation;
        for (long date = this.getFrom(); date <= this.dueDate; date += 86400000L) {
            idealBurndown.add(Float.valueOf(currentRemain));
            if (burndownTimes.contains(date)) {
                currentRemain -= burndownInDay;
            }
            if (!(currentRemain < 0.0f)) continue;
            currentRemain = 0.0f;
        }
        return idealBurndown;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BurndownReportDataJson build(@NotNull ReportCalculationMonitor monitor) {
        Intrinsics.checkParameterIsNotNull((Object)monitor, (String)"monitor");
        this.init();
        this.calculateRealBurndown(monitor);
        DateTimeZone zone = XdUserExtKt.timezone((XdUser)this.report.getOwner());
        List<Float> ideal = this.calculateIdealBurndown(zone);
        ArrayList<Float> remain = new ArrayList<Float>();
        ArrayList<Float> spent = new ArrayList<Float>();
        float currentRemain = this.sprintTotalEstimation;
        float currentSpent = 0.0f;
        boolean notCutOff = true;
        Object object = this.getData();
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void dayStart;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = (Long)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            DayData dayData = (DayData)entry2.getValue();
            remain.add(Float.valueOf(currentRemain));
            spent.add(Float.valueOf(currentSpent));
            if (currentRemain <= 0.0f && dayStart.longValue() >= this.dueDate || dayStart.longValue() > this.getNow()) {
                notCutOff = false;
                break;
            }
            currentRemain -= dayData.getProgress();
            currentSpent += dayData.getSpent();
        }
        if (notCutOff) {
            remain.add(Float.valueOf(currentRemain));
            spent.add(Float.valueOf(currentSpent));
        }
        List list = remain;
        List list2 = this.isSpentTimeCalculated() ? spent : null;
        long l = this.getFrom();
        long l2 = this.getTill();
        String string = this.getXLabel();
        String string2 = this.getYLabel();
        String string3 = zone.getID();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"zone.id");
        return new BurndownReportDataJson(ideal, list, list2, l, this.dueDate, l2, string, string2, string3);
    }

    @Override
    @NotNull
    protected DayData createDayData() {
        return new DayData(0.0f, 0.0f, 0.0f, 7, null);
    }

    @NotNull
    protected final XdBurndownReport getReport() {
        return this.report;
    }

    public BurndownDataBuilder(@NotNull XdBurndownReport report2, @NotNull DatePeriod period, long now) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)report2), (String)"report");
        Intrinsics.checkParameterIsNotNull((Object)period, (String)"period");
        super(now);
        this.report = report2;
        long startTimeInUserZone = period.getFrom();
        long finishTimeInUserZone = period.getTo();
        this.setFrom(startTimeInUserZone);
        long daysInPeriod = (finishTimeInUserZone - startTimeInUserZone) / 86400000L + 1L;
        this.dueDate = startTimeInUserZone + daysInPeriod * 86400000L;
        long daysUntilTomorrow = (now - startTimeInUserZone) / 86400000L + 1L;
        long daysInPeriodPlusHalf = daysInPeriod + daysInPeriod / (long)2;
        long daysInExtendedPeriod = daysUntilTomorrow < daysInPeriod ? daysInPeriod : (daysUntilTomorrow < daysInPeriodPlusHalf ? daysUntilTomorrow : daysInPeriodPlusHalf);
        this.setTill(startTimeInUserZone + daysInExtendedPeriod * 86400000L);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/reports/impl/agile/burndown/BurndownDataBuilder$DayData;", "", "ideal", "", "progress", "spent", "(FFF)V", "getIdeal", "()F", "setIdeal", "(F)V", "getProgress", "setProgress", "getSpent", "setSpent", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "youtrack-reports"})
    public static final class DayData {
        private float ideal;
        private float progress;
        private float spent;

        public final float getIdeal() {
            return this.ideal;
        }

        public final void setIdeal(float f) {
            this.ideal = f;
        }

        public final float getProgress() {
            return this.progress;
        }

        public final void setProgress(float f) {
            this.progress = f;
        }

        public final float getSpent() {
            return this.spent;
        }

        public final void setSpent(float f) {
            this.spent = f;
        }

        public DayData(float ideal, float progress, float spent) {
            this.ideal = ideal;
            this.progress = progress;
            this.spent = spent;
        }

        public /* synthetic */ DayData(float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 0.0f;
            }
            if ((n & 2) != 0) {
                f2 = 0.0f;
            }
            if ((n & 4) != 0) {
                f3 = 0.0f;
            }
            this(f, f2, f3);
        }

        public DayData() {
            this(0.0f, 0.0f, 0.0f, 7, null);
        }

        public final float component1() {
            return this.ideal;
        }

        public final float component2() {
            return this.progress;
        }

        public final float component3() {
            return this.spent;
        }

        @NotNull
        public final DayData copy(float ideal, float progress, float spent) {
            return new DayData(ideal, progress, spent);
        }

        public static /* synthetic */ DayData copy$default(DayData dayData, float f, float f2, float f3, int n, Object object) {
            if ((n & 1) != 0) {
                f = dayData.ideal;
            }
            if ((n & 2) != 0) {
                f2 = dayData.progress;
            }
            if ((n & 4) != 0) {
                f3 = dayData.spent;
            }
            return dayData.copy(f, f2, f3);
        }

        @NotNull
        public String toString() {
            return "DayData(ideal=" + this.ideal + ", progress=" + this.progress + ", spent=" + this.spent + ")";
        }

        public int hashCode() {
            return (Float.hashCode(this.ideal) * 31 + Float.hashCode(this.progress)) * 31 + Float.hashCode(this.spent);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DayData)) break block3;
                    DayData dayData = (DayData)object;
                    if (Float.compare(this.ideal, dayData.ideal) != 0 || Float.compare(this.progress, dayData.progress) != 0 || Float.compare(this.spent, dayData.spent) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

