/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.agile.burndown;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import jetbrains.charisma.customfields.common.PeriodFieldTypeExt;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.timetracking.BeansKt;
import jetbrains.youtrack.reports.impl.agile.TimeConverting;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Ba\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0011\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\fH\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\t\u0010$\u001a\u00020\fH\u00c6\u0003Jw\u0010%\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\fH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\u0010\u0010*\u001a\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010,J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0014\u0010\u000e\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u00a8\u00060"}, d2={"Ljetbrains/youtrack/reports/impl/agile/burndown/BurndownReportDataJson;", "Ljetbrains/youtrack/reports/impl/agile/TimeConverting;", "ideal", "", "", "remain", "spent", "from", "", "dueDate", "till", "xlabel", "", "ylabel", "zoneId", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;JJJLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDueDate", "()J", "getFrom", "getIdeal", "()Ljava/util/List;", "getRemain", "getSpent", "getTill", "getXlabel", "()Ljava/lang/String;", "getYlabel", "getZoneId", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "", "getRemainingEffortPresentation", "estimationField", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "hashCode", "", "toString", "youtrack-reports"})
public final class BurndownReportDataJson
implements TimeConverting {
    @NotNull
    private final List<Float> ideal;
    @NotNull
    private final List<Float> remain;
    @Nullable
    private final List<Float> spent;
    private final long from;
    private final long dueDate;
    private final long till;
    @NotNull
    private final String xlabel;
    @NotNull
    private final String ylabel;
    @NotNull
    private final String zoneId;

    @NotNull
    public final String getRemainingEffortPresentation(@Nullable XdCustomFieldPrototype estimationField) {
        String string;
        boolean overdue;
        int n;
        block10: {
            List<Float> $this$indexOfLast$iv = this.remain;
            boolean $i$f$indexOfLast = false;
            ListIterator<Float> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                float it = ((Number)iterator$iv.previous()).floatValue();
                boolean bl = false;
                if (!(it >= 0.0f)) continue;
                n = iterator$iv.nextIndex();
                break block10;
            }
            n = -1;
        }
        int $this$indexOfLast$iv = n;
        boolean bl = false;
        boolean iterator$iv = false;
        int it = $this$indexOfLast$iv;
        boolean bl2 = false;
        int lastIndex = it < 0 ? 0 : it;
        long oneDay = 86400000;
        long lastDate = this.getFrom() + (long)lastIndex * oneDay;
        boolean bl3 = overdue = lastDate > this.dueDate;
        if (overdue) {
            long now = System.currentTimeMillis();
            long overdueDays = (now - this.dueDate) / oneDay;
            String string2 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("BurndownReportResult.{0}_days_overdue", new Object[]{overdueDays});
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localizer.localizedMsg(\"\u2026ys_overdue\", overdueDays)");
            return string2;
        }
        int remainingDays = Math.round((float)(this.dueDate - lastDate) / (float)oneDay);
        Object overdueDays = CollectionsKt.last(this.remain);
        boolean bl4 = false;
        boolean bl5 = false;
        float it2 = ((Number)overdueDays).floatValue();
        boolean bl6 = false;
        float remainingEffort = it2 < 0.0f ? 0.0f : it2;
        int remainingEffortInt = Math.round(remainingEffort);
        String dash = " \u2014 ";
        String string3 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("BurndownReportResult.{0}_daysleft", new Object[]{remainingDays});
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"localizer.localizedMsg(\"\u2026daysleft\", remainingDays)");
        String daysLeft = string3;
        if (estimationField == null) {
            string = daysLeft + dash + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("BurndownReportResult.{0}_Issues", new Object[]{remainingEffortInt});
        } else if (estimationField.getType() instanceof PeriodFieldTypeExt) {
            string = remainingEffortInt > 0 ? daysLeft + dash + jetbrains.charisma.customfields.simple.common.BeansKt.getPeriodFieldType().createStringFromValue((Object)BeansKt.getTimeTrackingProvider().getPeriod(remainingEffortInt)) : daysLeft;
        } else if ((double)remainingEffort < 1.0E-5) {
            string = daysLeft;
        } else if (Intrinsics.areEqual((Object)estimationField.getType(), (Object)jetbrains.charisma.customfields.simple.common.BeansKt.getIntegerFieldType())) {
            string = daysLeft + dash + jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("BurndownReportResult.{0}_story_points", new Object[]{remainingEffortInt});
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string4 = "%.1f";
            Object[] objectArray = new Object[]{Float.valueOf(remainingEffort)};
            StringBuilder stringBuilder = new StringBuilder().append(daysLeft).append(dash);
            boolean bl7 = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
            String string6 = string5;
            string = stringBuilder.append(string6).append(" ").append(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("BurndownReportResult.story_points", new Object[0])).toString();
        }
        return string;
    }

    @NotNull
    public final List<Float> getIdeal() {
        return this.ideal;
    }

    @NotNull
    public final List<Float> getRemain() {
        return this.remain;
    }

    @Nullable
    public final List<Float> getSpent() {
        return this.spent;
    }

    @Override
    public long getFrom() {
        return this.from;
    }

    public final long getDueDate() {
        return this.dueDate;
    }

    public final long getTill() {
        return this.till;
    }

    @NotNull
    public final String getXlabel() {
        return this.xlabel;
    }

    @NotNull
    public final String getYlabel() {
        return this.ylabel;
    }

    @Override
    @NotNull
    public String getZoneId() {
        return this.zoneId;
    }

    public BurndownReportDataJson(@NotNull List<Float> ideal, @NotNull List<Float> remain, @Nullable List<Float> spent, long from, long dueDate, long till, @NotNull String xlabel, @NotNull String ylabel, @NotNull String zoneId) {
        Intrinsics.checkParameterIsNotNull(ideal, (String)"ideal");
        Intrinsics.checkParameterIsNotNull(remain, (String)"remain");
        Intrinsics.checkParameterIsNotNull((Object)xlabel, (String)"xlabel");
        Intrinsics.checkParameterIsNotNull((Object)ylabel, (String)"ylabel");
        Intrinsics.checkParameterIsNotNull((Object)zoneId, (String)"zoneId");
        this.ideal = ideal;
        this.remain = remain;
        this.spent = spent;
        this.from = from;
        this.dueDate = dueDate;
        this.till = till;
        this.xlabel = xlabel;
        this.ylabel = ylabel;
        this.zoneId = zoneId;
    }

    @Override
    @NotNull
    public DateTimeZone findZone() {
        return TimeConverting.DefaultImpls.findZone(this);
    }

    @Override
    @NotNull
    public <V> List<Pair<String, V>> convert(@NotNull List<? extends V> values2) {
        Intrinsics.checkParameterIsNotNull(values2, (String)"values");
        return TimeConverting.DefaultImpls.convert(this, values2);
    }

    @Override
    @NotNull
    public String convert(long value, @NotNull DateTimeZone zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        return TimeConverting.DefaultImpls.convert(this, value, zone);
    }

    @NotNull
    public final List<Float> component1() {
        return this.ideal;
    }

    @NotNull
    public final List<Float> component2() {
        return this.remain;
    }

    @Nullable
    public final List<Float> component3() {
        return this.spent;
    }

    public final long component4() {
        return this.getFrom();
    }

    public final long component5() {
        return this.dueDate;
    }

    public final long component6() {
        return this.till;
    }

    @NotNull
    public final String component7() {
        return this.xlabel;
    }

    @NotNull
    public final String component8() {
        return this.ylabel;
    }

    @NotNull
    public final String component9() {
        return this.getZoneId();
    }

    @NotNull
    public final BurndownReportDataJson copy(@NotNull List<Float> ideal, @NotNull List<Float> remain, @Nullable List<Float> spent, long from, long dueDate, long till, @NotNull String xlabel, @NotNull String ylabel, @NotNull String zoneId) {
        Intrinsics.checkParameterIsNotNull(ideal, (String)"ideal");
        Intrinsics.checkParameterIsNotNull(remain, (String)"remain");
        Intrinsics.checkParameterIsNotNull((Object)xlabel, (String)"xlabel");
        Intrinsics.checkParameterIsNotNull((Object)ylabel, (String)"ylabel");
        Intrinsics.checkParameterIsNotNull((Object)zoneId, (String)"zoneId");
        return new BurndownReportDataJson(ideal, remain, spent, from, dueDate, till, xlabel, ylabel, zoneId);
    }

    public static /* synthetic */ BurndownReportDataJson copy$default(BurndownReportDataJson burndownReportDataJson, List list, List list2, List list3, long l, long l2, long l3, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            list = burndownReportDataJson.ideal;
        }
        if ((n & 2) != 0) {
            list2 = burndownReportDataJson.remain;
        }
        if ((n & 4) != 0) {
            list3 = burndownReportDataJson.spent;
        }
        if ((n & 8) != 0) {
            l = burndownReportDataJson.getFrom();
        }
        if ((n & 0x10) != 0) {
            l2 = burndownReportDataJson.dueDate;
        }
        if ((n & 0x20) != 0) {
            l3 = burndownReportDataJson.till;
        }
        if ((n & 0x40) != 0) {
            string = burndownReportDataJson.xlabel;
        }
        if ((n & 0x80) != 0) {
            string2 = burndownReportDataJson.ylabel;
        }
        if ((n & 0x100) != 0) {
            string3 = burndownReportDataJson.getZoneId();
        }
        return burndownReportDataJson.copy(list, list2, list3, l, l2, l3, string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "BurndownReportDataJson(ideal=" + this.ideal + ", remain=" + this.remain + ", spent=" + this.spent + ", from=" + this.getFrom() + ", dueDate=" + this.dueDate + ", till=" + this.till + ", xlabel=" + this.xlabel + ", ylabel=" + this.ylabel + ", zoneId=" + this.getZoneId() + ")";
    }

    public int hashCode() {
        List<Float> list = this.ideal;
        List<Float> list2 = this.remain;
        List<Float> list3 = this.spent;
        String string = this.xlabel;
        String string2 = this.ylabel;
        String string3 = this.getZoneId();
        return ((((((((list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31 + Long.hashCode(this.getFrom())) * 31 + Long.hashCode(this.dueDate)) * 31 + Long.hashCode(this.till)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof BurndownReportDataJson)) break block3;
                BurndownReportDataJson burndownReportDataJson = (BurndownReportDataJson)object;
                if (!Intrinsics.areEqual(this.ideal, burndownReportDataJson.ideal) || !Intrinsics.areEqual(this.remain, burndownReportDataJson.remain) || !Intrinsics.areEqual(this.spent, burndownReportDataJson.spent) || this.getFrom() != burndownReportDataJson.getFrom() || this.dueDate != burndownReportDataJson.dueDate || this.till != burndownReportDataJson.till || !Intrinsics.areEqual((Object)this.xlabel, (Object)burndownReportDataJson.xlabel) || !Intrinsics.areEqual((Object)this.ylabel, (Object)burndownReportDataJson.ylabel) || !Intrinsics.areEqual((Object)this.getZoneId(), (Object)burndownReportDataJson.getZoneId())) break block3;
            }
            return true;
        }
        return false;
    }
}

