/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.agile.burndown;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.charisma.parser.date.DatePeriod;
import jetbrains.exodus.query.NodeBase;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.dates.DateMathKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.event.persistent.EventQueryKt;
import jetbrains.youtrack.event.persistent.XdAbstractEvent;
import jetbrains.youtrack.event.rollback.DebugInfoMethodsKt;
import jetbrains.youtrack.persistent.XdUserExtKt;
import jetbrains.youtrack.reports.impl.agile.burndown.BurndownDataBuilder;
import jetbrains.youtrack.reports.impl.agile.burndown.IssueBasedBurndownDataBuilder;
import jetbrains.youtrack.reports.impl.agile.burndown.ResolveWorkItemBurndownDataBuilder$burndown$reversedEvents$1;
import jetbrains.youtrack.reports.impl.agile.burndown.ResolveWorkItemBurndownDataBuilder$burndown$reversedEvents$2;
import jetbrains.youtrack.reports.impl.agile.burndown.XdBurndownReport;
import jetbrains.youtrack.timetracking.persistence.XdIssueWorkItem;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettings;
import jetbrains.youtrack.timetracking.persistence.XdTimeTrackingSettingsKt;
import jetbrains.youtrack.timetracking.persistence.XdWorkItemKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J&\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/reports/impl/agile/burndown/ResolveWorkItemBurndownDataBuilder;", "Ljetbrains/youtrack/reports/impl/agile/burndown/IssueBasedBurndownDataBuilder;", "report", "Ljetbrains/youtrack/reports/impl/agile/burndown/XdBurndownReport;", "period", "Ljetbrains/charisma/parser/date/DatePeriod;", "now", "", "(Ljetbrains/youtrack/reports/impl/agile/burndown/XdBurndownReport;Ljetbrains/charisma/parser/date/DatePeriod;J)V", "isSpentTimeCalculated", "", "()Z", "usedWorkItems", "yLabel", "", "getYLabel", "()Ljava/lang/String;", "burndown", "", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "burndownFromQueue", "directOrderedProgressChanges", "", "Ljetbrains/youtrack/reports/impl/agile/burndown/ResolveWorkItemBurndownDataBuilder$EstimationChange;", "initialEstimation", "", "initialIssueResolved", "isWorkItemBased", "Companion", "EstimationChange", "youtrack-reports"})
public final class ResolveWorkItemBurndownDataBuilder
extends IssueBasedBurndownDataBuilder {
    private boolean usedWorkItems;
    private final boolean isSpentTimeCalculated = true;
    public static final Companion Companion = new Companion(null);

    private final boolean isWorkItemBased(XdIssue issue2) {
        XdTimeTrackingSettings settings2 = XdTimeTrackingSettingsKt.getTimeTrackingSettings((XdProject)issue2.getProject());
        return settings2.getEnabled() && settings2.getSpentTime() != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void burndown(@NotNull XdIssue issue2) {
        boolean issueWasUnresolvedAtStart;
        XdAbstractEvent event;
        long timestamp;
        Iterator value$iv;
        void $receiver$iv;
        Comparable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        ArrayList<EstimationChange> changes = new ArrayList<EstimationChange>();
        Long historicResolvedDate = issue2.getResolved();
        KProperty1 kProperty1 = (KProperty1)ResolveWorkItemBurndownDataBuilder$burndown$reversedEvents$1.INSTANCE;
        KProperty1 kProperty12 = (KProperty1)ResolveWorkItemBurndownDataBuilder$burndown$reversedEvents$2.INSTANCE;
        XdEntity xdEntity = (XdEntity)issue2;
        String string = ReflectionUtilKt.getDBName((KProperty1)$receiver$iv2, (XdEntityType)ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdIssue.class)));
        $receiver$iv2 = (Comparable)((Object)string);
        string = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdAbstractEvent.class)), (Comparable)((Object)value$iv));
        List reversedEvents2 = CollectionsKt.reversed((Iterable)XdQueryKt.toList((XdQuery)EventQueryKt.getEventsDirect((XdEntity)xdEntity, (NodeBase)string)));
        value$iv = reversedEvents2.iterator();
        while (value$iv.hasNext() && (timestamp = (event = (XdAbstractEvent)value$iv.next()).getTimestamp()) >= this.getFrom()) {
            Long resolvedDateBefore;
            Long resolvedDateAfter = historicResolvedDate;
            historicResolvedDate = resolvedDateBefore = (Long)event.getOldPropertyValue((Comparable)historicResolvedDate);
            if (timestamp >= this.getTill()) continue;
            if (resolvedDateBefore == null && resolvedDateAfter == null) {
                Companion.getLogger().warn((Function0)new Function0<String>(event){
                    final /* synthetic */ XdAbstractEvent $event;

                    @NotNull
                    public final String invoke() {
                        return "Corrupted resolution event sequence, " + "detected unresolved->unresolved change: " + DebugInfoMethodsKt.getEventDebugInfo((XdAbstractEvent)this.$event);
                    }
                    {
                        this.$event = xdAbstractEvent;
                        super(0);
                    }
                });
                continue;
            }
            if (resolvedDateBefore != null && resolvedDateAfter != null) {
                Companion.getLogger().warn((Function0)new Function0<String>(event){
                    final /* synthetic */ XdAbstractEvent $event;

                    @NotNull
                    public final String invoke() {
                        return "Corrupted resolution event sequence, " + "detected resolved->resolved change: " + DebugInfoMethodsKt.getEventDebugInfo((XdAbstractEvent)this.$event);
                    }
                    {
                        this.$event = xdAbstractEvent;
                        super(0);
                    }
                });
                continue;
            }
            changes.add(new EstimationChange(timestamp, 0.0f, resolvedDateBefore == null));
        }
        if (this.isWorkItemBased(issue2)) {
            this.usedWorkItems = true;
            Iterable $this$forEach$iv = XdQueryKt.asIterable((XdQuery)XdWorkItemKt.getWorkItems((XdIssue)issue2));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XdIssueWorkItem it = (XdIssueWorkItem)element$iv;
                boolean bl = false;
                Long l = it.getDate();
                DateTimeZone dateTimeZone = DateTimeZone.UTC;
                Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone, (String)"DateTimeZone.UTC");
                long date = DateMathKt.shiftTimeToZone((Long)l, (DateTimeZone)dateTimeZone, (DateTimeZone)XdUserExtKt.timezone((XdUser)this.getReport().getOwner()));
                if (date >= this.getTill()) continue;
                float progress = it.getDuration();
                changes.add(new EstimationChange(date, progress, null));
                if (date < this.getFrom()) continue;
                if ((BurndownDataBuilder.DayData)this.getData().get(this.toDayStart(date)) != null) {
                    BurndownDataBuilder.DayData dayData;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    BurndownDataBuilder.DayData it2 = dayData;
                    boolean bl4 = false;
                    BurndownDataBuilder.DayData dayData2 = it2;
                    dayData2.setSpent(dayData2.getSpent() + progress);
                }
            }
        }
        float issueEstimation = this.estimate(issue2);
        boolean bl = issueWasUnresolvedAtStart = historicResolvedDate == null;
        if (issueWasUnresolvedAtStart) {
            ResolveWorkItemBurndownDataBuilder resolveWorkItemBurndownDataBuilder = this;
            resolveWorkItemBurndownDataBuilder.setSprintTotalEstimation(resolveWorkItemBurndownDataBuilder.getSprintTotalEstimation() + issueEstimation);
        }
        CollectionsKt.sort((List)changes);
        this.burndownFromQueue((List<EstimationChange>)changes, issueEstimation, issueWasUnresolvedAtStart);
    }

    private final void burndownFromQueue(List<EstimationChange> directOrderedProgressChanges, float initialEstimation, boolean initialIssueResolved) {
        float onlyWorkItemBaseEstimationRemain = initialEstimation;
        boolean issueResolved = !initialIssueResolved;
        for (EstimationChange change : directOrderedProgressChanges) {
            BurndownDataBuilder.DayData dayData;
            float progress = change.getProgress();
            if (change.getResolution() == null) {
                if (progress > onlyWorkItemBaseEstimationRemain) {
                    progress = onlyWorkItemBaseEstimationRemain;
                }
                onlyWorkItemBaseEstimationRemain -= progress;
                if (issueResolved) {
                    progress = 0.0f;
                }
            } else {
                progress = change.getResolution() != false ? onlyWorkItemBaseEstimationRemain : -onlyWorkItemBaseEstimationRemain;
                issueResolved = change.getResolution();
            }
            if (change.getTimestamp() < this.getFrom()) continue;
            if ((BurndownDataBuilder.DayData)this.getData().get(this.toDayStart(change.getTimestamp())) == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            BurndownDataBuilder.DayData it = dayData;
            boolean bl3 = false;
            BurndownDataBuilder.DayData dayData2 = it;
            dayData2.setProgress(dayData2.getProgress() + progress);
        }
    }

    @Override
    @NotNull
    protected String getYLabel() {
        String string;
        if (this.usedWorkItems) {
            String string2 = BeansKt.getLocalizer().localizedMsg("FloatMaxWorkItemBurndownDataBuilder.Effort_remaining/spent", new Object[0]);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localizer.localizedMsg(\"\u2026.Effort_remaining/spent\")");
        } else {
            string = super.getYLabel();
        }
        return string;
    }

    @Override
    public boolean isSpentTimeCalculated() {
        return this.isSpentTimeCalculated;
    }

    public ResolveWorkItemBurndownDataBuilder(@NotNull XdBurndownReport report2, @NotNull DatePeriod period, long now) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)report2), (String)"report");
        Intrinsics.checkParameterIsNotNull((Object)period, (String)"period");
        super(report2, period, now);
        this.isSpentTimeCalculated = true;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0096\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/reports/impl/agile/burndown/ResolveWorkItemBurndownDataBuilder$EstimationChange;", "", "", "timestamp", "", "progress", "", "resolution", "", "(JFLjava/lang/Boolean;)V", "getProgress", "()F", "getResolution", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getTimestamp", "()J", "compareTo", "", "other", "youtrack-reports"})
    private static final class EstimationChange
    implements Comparable<Object> {
        private final long timestamp;
        private final float progress;
        @Nullable
        private final Boolean resolution;

        @Override
        public int compareTo(@NotNull Object other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            long l = this.timestamp - ((EstimationChange)other).timestamp;
            return l == 0L ? 0 : (l < 0L ? -1 : 1);
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final float getProgress() {
            return this.progress;
        }

        @Nullable
        public final Boolean getResolution() {
            return this.resolution;
        }

        public EstimationChange(long timestamp, float progress, @Nullable Boolean resolution) {
            this.timestamp = timestamp;
            this.progress = progress;
            this.resolution = resolution;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/reports/impl/agile/burndown/ResolveWorkItemBurndownDataBuilder$Companion;", "Lmu/KLogging;", "()V", "youtrack-reports"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

