/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.gantt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import jetbrains.youtrack.reports.ReportCalculationException;
import jetbrains.youtrack.reports.impl.gantt.DependencyCycleGanttReportException;
import jetbrains.youtrack.reports.impl.gantt.GanttReportExceptionKt;
import jetbrains.youtrack.reports.impl.gantt.MemoryDependency;
import jetbrains.youtrack.reports.impl.gantt.MemoryTask;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B;\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ(\u0010\u0013\u001a\u00020\u00072\u000e\u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u000e\u0010\u0015\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004H\u0002J\b\u0010\u0016\u001a\u00020\u0007H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u001f\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/reports/impl/gantt/DependencyCycleGanttReportException;", "Ljetbrains/youtrack/reports/ReportCalculationException;", "path", "", "Ljetbrains/youtrack/reports/impl/gantt/MemoryTask;", "cycledLeaf", "aggregationLinkName", "", "dependencyLinkName", "(Ljava/util/Set;Ljetbrains/youtrack/reports/impl/gantt/MemoryTask;Ljava/lang/String;Ljava/lang/String;)V", "getAggregationLinkName", "()Ljava/lang/String;", "getCycledLeaf", "()Ljetbrains/youtrack/reports/impl/gantt/MemoryTask;", "getDependencyLinkName", "message", "getMessage", "getPath", "()Ljava/util/Set;", "restoreRealDependenciesAndAggregationsAsString", "blocking", "dependent", "translatePathToErrorMessage", "wikifyExceptionMessage", "", "Companion", "youtrack-reports"})
public final class DependencyCycleGanttReportException
extends ReportCalculationException {
    @NotNull
    private final Set<MemoryTask<?, ?>> path;
    @NotNull
    private final MemoryTask<?, ?> cycledLeaf;
    @NotNull
    private final String aggregationLinkName;
    @NotNull
    private final String dependencyLinkName;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public String getMessage() {
        String dependencyCycleMessage = "The report cannot be calculated. Circular dependency detected.";
        try {
            return dependencyCycleMessage + " \n" + this.translatePathToErrorMessage();
        }
        catch (Exception e) {
            Companion.getLogger().error((Throwable)e, (Function0)message.1.INSTANCE);
            return dependencyCycleMessage + " Preview is not available. Check server logs for details.";
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String translatePathToErrorMessage() {
        int n;
        int n2;
        int index$iv;
        StringBuilder result2;
        block5: {
            result2 = new StringBuilder();
            Iterable $this$indexOfFirst$iv = this.path;
            boolean $i$f$indexOfFirst = false;
            index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                n2 = 0;
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                MemoryTask it = (MemoryTask)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)GanttReportExceptionKt.access$toId(it.getPayload()), (Object)GanttReportExceptionKt.access$toId(this.cycledLeaf.getPayload()))) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index = n;
        Iterable $this$forEachIndexed$iv = this.path;
        boolean $i$f$forEachIndexed = false;
        index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void task;
            n2 = index$iv++;
            boolean bl = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = n2;
            MemoryTask memoryTask = (MemoryTask)item$iv;
            int i = n3;
            boolean bl2 = false;
            if (i < index) continue;
            result2.append(this.restoreRealDependenciesAndAggregationsAsString(i == this.path.size() - 1 ? this.cycledLeaf : (MemoryTask)CollectionsKt.elementAt((Iterable)this.path, (int)(i + 1)), (MemoryTask<?, ?>)task));
        }
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    private final String restoreRealDependenciesAndAggregationsAsString(MemoryTask<?, ?> blocking, MemoryTask<?, ?> dependent) {
        Object element$iv2;
        String result2;
        block10: {
            result2 = "* " + GanttReportExceptionKt.access$toId(dependent.getPayload()) + ' ' + this.dependencyLinkName + ' ' + GanttReportExceptionKt.access$toId(blocking.getPayload());
            Iterable $this$first$iv = dependent.getGeneratedDependencies();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MemoryDependency it = (MemoryDependency)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getBlocking(), blocking)) continue;
                break block10;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        MemoryDependency generatedDependency = (MemoryDependency)element$iv2;
        MemoryDependency realDependency = (MemoryDependency)CollectionsKt.first(generatedDependency.getReasons());
        if (Intrinsics.areEqual(blocking, realDependency.getBlocking()) ^ true || Intrinsics.areEqual(dependent, realDependency.getDependent()) ^ true) {
            boolean bl = false;
            List leftParentChain = new ArrayList();
            if (Intrinsics.areEqual(blocking, realDependency.getBlocking()) ^ true) {
                MemoryTask<?, ?> parent2;
                leftParentChain.add(blocking);
                for (parent2 = blocking.getParent(); parent2 != null && Intrinsics.areEqual(parent2, realDependency.getBlocking()) ^ true; parent2 = parent2.getParent()) {
                    leftParentChain.add(parent2);
                }
                if (parent2 != null) {
                    leftParentChain.add(parent2);
                }
            }
            boolean element$iv2 = false;
            List rightParentChain = new ArrayList();
            if (Intrinsics.areEqual(dependent, realDependency.getDependent()) ^ true) {
                MemoryTask<?, ?> parent3;
                rightParentChain.add(dependent);
                for (parent3 = dependent.getParent(); parent3 != null && Intrinsics.areEqual(parent3, realDependency.getDependent()) ^ true; parent3 = parent3.getParent()) {
                    rightParentChain.add(parent3);
                }
                if (parent3 != null) {
                    rightParentChain.add(parent3);
                }
            }
            result2 = result2 + " (as ";
            boolean bl2 = false;
            ArrayList list = new ArrayList();
            Collection collection = list;
            String string = GanttReportExceptionKt.access$toId(realDependency.getDependent().getPayload()) + ' ' + this.dependencyLinkName + ' ' + GanttReportExceptionKt.access$toId(realDependency.getBlocking().getPayload());
            boolean bl3 = false;
            collection.add(string);
            collection = leftParentChain;
            boolean bl4 = false;
            if (!collection.isEmpty()) {
                collection = list;
                String string2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)leftParentChain), (CharSequence)(' ' + this.aggregationLinkName + ' '), null, null, (int)0, null, (Function1)restoreRealDependenciesAndAggregationsAsString.1.INSTANCE, (int)30, null);
                bl3 = false;
                collection.add(string2);
            }
            collection = rightParentChain;
            boolean bl5 = false;
            if (!collection.isEmpty()) {
                collection = list;
                String string3 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)rightParentChain), (CharSequence)(' ' + this.aggregationLinkName + ' '), null, null, (int)0, null, (Function1)restoreRealDependenciesAndAggregationsAsString.2.INSTANCE, (int)30, null);
                bl3 = false;
                collection.add(string3);
            }
            result2 = result2 + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")";
        }
        result2 = result2 + "\n";
        return result2;
    }

    @Override
    public boolean wikifyExceptionMessage() {
        return true;
    }

    @NotNull
    public final Set<MemoryTask<?, ?>> getPath() {
        return this.path;
    }

    @NotNull
    public final MemoryTask<?, ?> getCycledLeaf() {
        return this.cycledLeaf;
    }

    @NotNull
    public final String getAggregationLinkName() {
        return this.aggregationLinkName;
    }

    @NotNull
    public final String getDependencyLinkName() {
        return this.dependencyLinkName;
    }

    public DependencyCycleGanttReportException(@NotNull Set<? extends MemoryTask<?, ?>> path, @NotNull MemoryTask<?, ?> cycledLeaf, @NotNull String aggregationLinkName, @NotNull String dependencyLinkName) {
        Intrinsics.checkParameterIsNotNull(path, (String)"path");
        Intrinsics.checkParameterIsNotNull(cycledLeaf, (String)"cycledLeaf");
        Intrinsics.checkParameterIsNotNull((Object)aggregationLinkName, (String)"aggregationLinkName");
        Intrinsics.checkParameterIsNotNull((Object)dependencyLinkName, (String)"dependencyLinkName");
        this.path = path;
        this.cycledLeaf = cycledLeaf;
        this.aggregationLinkName = aggregationLinkName;
        this.dependencyLinkName = dependencyLinkName;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/reports/impl/gantt/DependencyCycleGanttReportException$Companion;", "Lmu/KLogging;", "()V", "youtrack-reports"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

