/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.time.simple;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.reports.impl.time.IssueMeta;
import jetbrains.youtrack.reports.impl.time.LoggedWorkGroup;
import jetbrains.youtrack.reports.impl.time.LoggedWorkItem;
import jetbrains.youtrack.reports.impl.time.simple.LineGrouping;
import jetbrains.youtrack.reports.impl.time.simple.TimeReportGroupView;
import jetbrains.youtrack.reports.impl.time.simple.TimeReportLineView;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/reports/impl/time/simple/ByProjectGrouping;", "Ljetbrains/youtrack/reports/impl/time/simple/LineGrouping;", "()V", "id", "", "getId", "()Ljava/lang/String;", "keyOf", "item", "Ljetbrains/youtrack/reports/impl/time/LoggedWorkItem;", "newLine", "Ljetbrains/youtrack/reports/impl/time/simple/TimeReportLineView;", "groupName", "issueMeta", "Ljetbrains/youtrack/reports/impl/time/IssueMeta;", "youtrack-reports"})
public final class ByProjectGrouping
implements LineGrouping {
    @NotNull
    private static final String id = "project";
    public static final ByProjectGrouping INSTANCE;

    @Override
    @NotNull
    public String getId() {
        return id;
    }

    @Override
    @NotNull
    public TimeReportLineView newLine(@NotNull String groupName, @NotNull LoggedWorkItem item, @Nullable IssueMeta issueMeta) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        String projectKey = this.keyOf(item);
        XdProject xdProject = XdProject.Companion.findByKey(projectKey);
        if (xdProject == null) {
            throw (Throwable)new IllegalStateException("project not found by " + projectKey);
        }
        XdProject project = xdProject;
        return new TimeReportLineView(project.getShortName(), project.getName(), null, null, null, null, null, groupName, 124, null);
    }

    @Override
    @NotNull
    public String keyOf(@NotNull LoggedWorkItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)item.getIssueId(), (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null));
    }

    private ByProjectGrouping() {
    }

    static {
        ByProjectGrouping byProjectGrouping;
        INSTANCE = byProjectGrouping = new ByProjectGrouping();
        id = id;
    }

    @Override
    public boolean getHasLineEstimation() {
        return LineGrouping.DefaultImpls.getHasLineEstimation(this);
    }

    @Override
    @Nullable
    public Comparator<TimeReportLineView> getComparator() {
        return LineGrouping.DefaultImpls.getComparator(this);
    }

    @Override
    @NotNull
    public TimeReportGroupView splitInto(@NotNull LoggedWorkGroup $this$splitInto, @NotNull TimeReportGroupView groupView, @NotNull Map<String, IssueMeta> issues2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$splitInto, (String)"$this$splitInto");
        Intrinsics.checkParameterIsNotNull((Object)groupView, (String)"groupView");
        Intrinsics.checkParameterIsNotNull(issues2, (String)"issues");
        return LineGrouping.DefaultImpls.splitInto(this, $this$splitInto, groupView, issues2);
    }
}

