/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.dao.remote.api.authority.RemoteProjectTeamDAO;
import jetbrains.jetpass.dao.remote.api.authority.RemoteUserDAO;
import jetbrains.jetpass.dao.remote.api.authority.RemoteUserGroupDAO;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.persistent.ProjectCloneHandler;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.sync.RingTeam;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\rH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/ring/HubProjectCloneHandler;", "Ljetbrains/youtrack/persistent/ProjectCloneHandler;", "()V", "prerequisites", "Ljetbrains/youtrack/persistent/ProjectCloneHandler$Prerequisites;", "getPrerequisites", "()Ljetbrains/youtrack/persistent/ProjectCloneHandler$Prerequisites;", "clone", "", "source", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "target", "cloneRoles", "Ljetbrains/jetpass/api/security/Project;", "cloneTeam", "Companion", "youtrack-ring-integration"})
public final class HubProjectCloneHandler
implements ProjectCloneHandler {
    @NotNull
    private final ProjectCloneHandler.Prerequisites prerequisites = ProjectCloneHandler.Prerequisites.FLUSH;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ProjectCloneHandler.Prerequisites getPrerequisites() {
        return this.prerequisites;
    }

    public void clone(@NotNull XdProject source, @NotNull XdProject target) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        jetbrains.youtrack.ring.BeansKt.getRingAuditLog().withActivity("Cloning project " + source.getName() + " (" + source.getShortName() + ')', (Function0<Unit>)((Function0)new Function0<Unit>(this, source, target){
            final /* synthetic */ HubProjectCloneHandler this$0;
            final /* synthetic */ XdProject $source;
            final /* synthetic */ XdProject $target;

            public final void invoke() {
                try {
                    Project project = (Project)BeansKt.getRingApi().getProjectDAO().get(jetbrains.youtrack.ring.sync.BeansKt.getHubUuidCache().getProjectId(this.$source.getEntity()));
                    if (project != null) {
                        Project project2 = project;
                        boolean bl = false;
                        boolean bl2 = false;
                        Project sourceHubProject = project2;
                        boolean bl3 = false;
                        Project project3 = (Project)BeansKt.getRingApi().getProjectDAO().get(jetbrains.youtrack.ring.sync.BeansKt.getHubUuidCache().getProjectId(this.$target.getEntity()));
                        if (project3 != null) {
                            Project project4 = project3;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Project hubProjectClone = project4;
                            boolean bl6 = false;
                            Project project5 = sourceHubProject;
                            Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"sourceHubProject");
                            Project project6 = hubProjectClone;
                            Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"hubProjectClone");
                            HubProjectCloneHandler.access$cloneTeam(this.this$0, project5, project6);
                            HubProjectCloneHandler.access$cloneRoles(this.this$0, sourceHubProject, hubProjectClone);
                        }
                    }
                }
                catch (Exception e) {
                    HubProjectCloneHandler.Companion.getLogger().warn("Got an error while cloning a project in Hub", (Throwable)e);
                }
            }
            {
                this.this$0 = hubProjectCloneHandler;
                this.$source = xdProject;
                this.$target = xdProject2;
                super(0);
            }
        }));
    }

    private final void cloneTeam(Project source, Project target) {
        UserGroupJSON userGroupJSON;
        User it;
        Collection<UserGroupJSON> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ProjectTeamJSON team = new ProjectTeamJSON(target.getTeam());
        ProjectTeam projectTeam = source.getTeam();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectTeam, (String)"source.team");
        Iterable iterable = projectTeam.getGroups();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"source.team.groups");
        ProjectTeam projectTeam2 = target.getTeam();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectTeam2, (String)"target.team");
        Iterable iterable2 = projectTeam2.getGroups();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"target.team.groups");
        Iterable iterable3 = CollectionsKt.union((Iterable)iterable, (Iterable)iterable2);
        ProjectTeamJSON projectTeamJSON = team;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UserGroup userGroup = (UserGroup)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            userGroupJSON = new UserGroupJSON((UserGroup)it);
            collection.add(userGroupJSON);
        }
        collection = (List)destination$iv$iv;
        projectTeamJSON.setGroups((Iterable)collection);
        ProjectTeam projectTeam3 = source.getTeam();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectTeam3, (String)"source.team");
        Iterable iterable4 = projectTeam3.getOwnUsers();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable4, (String)"source.team.ownUsers");
        ProjectTeam projectTeam4 = target.getTeam();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectTeam4, (String)"target.team");
        Iterable iterable5 = projectTeam4.getOwnUsers();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable5, (String)"target.team.ownUsers");
        $this$map$iv = CollectionsKt.union((Iterable)iterable4, (Iterable)iterable5);
        projectTeamJSON = team;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (User)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            userGroupJSON = new UserJSON(it);
            collection.add(userGroupJSON);
        }
        collection = (List)destination$iv$iv;
        projectTeamJSON.setOwnUsers((Iterable)collection);
        RemoteProjectTeamDAO remoteProjectTeamDAO = BeansKt.getRingApi().getProjectTeamDAO();
        ProjectTeam projectTeam5 = target.getTeam();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectTeam5, (String)"target.team");
        remoteProjectTeamDAO.update(projectTeam5.getId(), (IdItem)team);
        ProjectTeam projectTeam6 = target.getTeam();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectTeam6, (String)"target.team");
        String string = projectTeam6.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.team.id");
        new RingTeam(string).resolveAndSync();
    }

    private final void cloneRoles(Project source, Project target) {
        Iterable iterable = source.getProjectRoles();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"source.projectRoles");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserJSON json;
            ProjectRole it = (ProjectRole)element$iv;
            boolean bl = false;
            ProjectRoleJSON projectRole = new ProjectRoleJSON();
            projectRole.setProject(new ProjectJSON(target));
            ProjectRole projectRole2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)projectRole2, (String)"it");
            projectRole.setRole(new RoleJSON(projectRole2.getRole()));
            AuthorityHolder authorityHolder = it.getOwner();
            if (authorityHolder instanceof User) {
                json = new UserJSON();
                json.setProjectRoles((Iterable)CollectionsKt.listOf((Object)projectRole));
                RemoteUserDAO remoteUserDAO = BeansKt.getRingApi().getUserDAO();
                AuthorityHolder authorityHolder2 = it.getOwner();
                Intrinsics.checkExpressionValueIsNotNull((Object)authorityHolder2, (String)"it.owner");
                remoteUserDAO.update(authorityHolder2.getId(), (IdItem)json);
                continue;
            }
            if (!(authorityHolder instanceof UserGroup)) continue;
            json = new UserGroupJSON();
            json.setProjectRoles((Iterable)CollectionsKt.listOf((Object)projectRole));
            RemoteUserGroupDAO remoteUserGroupDAO = BeansKt.getRingApi().getUserGroupDAO();
            AuthorityHolder authorityHolder3 = it.getOwner();
            Intrinsics.checkExpressionValueIsNotNull((Object)authorityHolder3, (String)"it.owner");
            remoteUserGroupDAO.update(authorityHolder3.getId(), (IdItem)json);
        }
    }

    public static final /* synthetic */ void access$cloneTeam(HubProjectCloneHandler $this, Project source, Project target) {
        $this.cloneTeam(source, target);
    }

    public static final /* synthetic */ void access$cloneRoles(HubProjectCloneHandler $this, Project source, Project target) {
        $this.cloneRoles(source, target);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/HubProjectCloneHandler$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

