/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring;

import java.util.concurrent.ConcurrentLinkedQueue;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.ring.RemoteApiSyncService;
import jetbrains.youtrack.ring.cache.BeansKt;
import jetbrains.youtrack.ring.client.ConnectionTestResult;
import jetbrains.youtrack.scheduling.LocalScheduling;
import jetbrains.youtrack.scheduling.QuartzParametersFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/ring/RemoteApiSyncService;", "Ljetbrains/youtrack/scheduling/LocalScheduling;", "()V", "eventQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Function0;", "", "pendingEventsCount", "", "getPendingEventsCount", "()I", "addEvent", "handler", "createTrigger", "Lorg/quartz/Trigger;", "execute", "shouldExecute", "", "syncEvents", "Companion", "youtrack-ring-integration"})
public final class RemoteApiSyncService
extends LocalScheduling {
    private final ConcurrentLinkedQueue<Function0<Unit>> eventQueue = new ConcurrentLinkedQueue();
    public static final Companion Companion = new Companion(null);

    public final int getPendingEventsCount() {
        return this.eventQueue.size();
    }

    @NotNull
    public Trigger createTrigger() {
        QuartzParametersFactory quartzParametersFactory = this.getQuartzFactory();
        LocalScheduling localScheduling = this;
        String string = System.getProperty("jetbrains.youtrack.hub.syncInterval", "3");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"jetb\u2026k.hub.syncInterval\", \"3\")");
        String string2 = string;
        LocalScheduling localScheduling2 = localScheduling;
        QuartzParametersFactory quartzParametersFactory2 = quartzParametersFactory;
        boolean bl = false;
        int n = Integer.parseInt(string2);
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.repeatSecondlyForever((int)n);
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleScheduleBuilder, (String)"SimpleScheduleBuilder.re\u2026cInterval\", \"3\").toInt())");
        return quartzParametersFactory2.newTrigger(localScheduling2, (ScheduleBuilder)simpleScheduleBuilder);
    }

    public boolean shouldExecute() {
        boolean bl;
        if (!jetbrains.youtrack.config.BeansKt.getPersistentDataEnvironment().isOpen()) {
            Companion.getLogger().warn("Persistent environment has been closed, skipping Hub event sync");
            bl = false;
        } else if (!((Boolean)LegacySupportKt.transactional((Function1)shouldExecute.1.INSTANCE)).booleanValue()) {
            Companion.getLogger().info("Hub integration is disabled, skipping Hub event sync");
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        MDC.put((String)"username", (String)"Hub Event Sync User");
        try {
            ConnectionTestResult result2 = jetbrains.youtrack.ring.client.BeansKt.getHubClientFactory().testConnection();
            if (result2.isSuccessful()) {
                if (!jetbrains.youtrack.ring.impl.BeansKt.getHubSecurity().getInitComplete()) {
                    Companion.getLogger().info("Hub connection has been restored, initializing integration...");
                    jetbrains.youtrack.config.BeansKt.getRingConfig().initHubIntegration();
                }
                Companion.getLogger().trace((Function0)execute.1.INSTANCE);
                this.syncEvents();
            } else {
                Companion.getLogger().warn("Hub connection is broken: " + result2.getMessage(false) + ". Skipping Hub event sync.");
            }
        }
        catch (RuntimeException e) {
            Companion.getLogger().error("Hub event sync job has failed", (Throwable)e);
        }
        finally {
            MDC.remove((String)"username");
        }
    }

    private final void syncEvents() {
        jetbrains.youtrack.ring.client.BeansKt.getRingApi().getEventSyncChecker().run();
        Function0<Unit> eventHandler = this.eventQueue.poll();
        Companion.getLogger().trace("Processing a total of " + this.eventQueue.size() + " pending Hub events");
        while (eventHandler != null) {
            try {
                eventHandler.invoke();
            }
            catch (Exception e) {
                Companion.getLogger().warn("Failed to process Hub event", (Throwable)e);
            }
            eventHandler = this.eventQueue.poll();
        }
        BeansKt.getCustomFieldsPermissionsCache().recalculate();
    }

    public final void addEvent(@NotNull Function0<Unit> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        this.eventQueue.add(handler);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/RemoteApiSyncService$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

