/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.charisma.customfields.security.HubCustomFieldsSecurity;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.youtrack.api.ring.UserPermissionChangeListener;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.BeansKt;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.ring.cache.BaseUserPermissionsCache;
import jetbrains.youtrack.ring.cache.PermissionsCacheData;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 #2\u00020\u00012\u00020\u00022\u00020\u0003:\u0005\"#$%&B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\u0016\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fH\u0016J\u0006\u0010 \u001a\u00020\u001bJ\b\u0010!\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ljetbrains/youtrack/ring/cache/CustomFieldsPermissionsCache;", "Ljetbrains/youtrack/ring/cache/BaseUserPermissionsCache;", "Ljetbrains/charisma/customfields/security/HubCustomFieldsSecurity;", "Ljetbrains/youtrack/api/ring/UserPermissionChangeListener;", "()V", "calculationLock", "Ljava/util/concurrent/locks/ReentrantLock;", "<set-?>", "", "initComplete", "getInitComplete", "()Z", "isRecalculated", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "queueLock", "recalculationRequestQueue", "Ljava/util/LinkedList;", "Ljetbrains/youtrack/ring/cache/CustomFieldsPermissionsCache$CacheCalculator;", "getProjectsForPermission", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "permissionName", "", "init", "", "invalidate", "permissionsChanged", "users", "Lkotlin/sequences/Sequence;", "recalculate", "waitForPermissionCacheRecalculation", "CacheCalculator", "Companion", "FullCacheCalculator", "NoopCacheCalculator", "PartialCacheCalculator", "youtrack-ring-integration"})
public final class CustomFieldsPermissionsCache
extends BaseUserPermissionsCache
implements HubCustomFieldsSecurity,
UserPermissionChangeListener {
    private volatile boolean initComplete;
    private final ReentrantLock calculationLock = new ReentrantLock();
    private final ReentrantLock queueLock = new ReentrantLock();
    private final Condition isRecalculated = this.calculationLock.newCondition();
    private final LinkedList<CacheCalculator> recalculationRequestQueue = new LinkedList();
    public static final Companion Companion = new Companion(null);

    public boolean getInitComplete() {
        return this.initComplete;
    }

    public final void init() {
        this.setData(new PermissionsCacheData());
        this.initComplete = true;
        Companion.getLogger().info("Custom field permission cache initialized");
    }

    public void permissionsChanged() {
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (this.getInitComplete()) {
            Companion.getLogger().debug("Full permission cache rebuild has been scheduled");
            Lock lock = this.queueLock;
            boolean bl = false;
            lock.lock();
            try {
                boolean bl2 = false;
                boolean bl3 = this.recalculationRequestQueue.add(FullCacheCalculator.INSTANCE);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void permissionsChanged(@NotNull Sequence<? extends XdUser> users) {
        Intrinsics.checkParameterIsNotNull(users, (String)"users");
        if (this.getInitComplete() && users.iterator().hasNext()) {
            Companion.getLogger().debug("Partial permission cache rebuild has been scheduled");
            Lock lock = this.queueLock;
            boolean bl = false;
            lock.lock();
            try {
                boolean bl2 = false;
                boolean bl3 = this.recalculationRequestQueue.add(new PartialCacheCalculator(users));
            }
            finally {
                lock.unlock();
            }
        }
    }

    public final void recalculate() {
        if (this.getInitComplete()) {
            LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
                final /* synthetic */ CustomFieldsPermissionsCache this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull TransientStoreSession it) {
                    ArrayList<E> $i$a$-withLock-CustomFieldsPermissionsCache$recalculate$1$queue$22;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Lock lock = CustomFieldsPermissionsCache.access$getQueueLock$p(this.this$0);
                    boolean bl = false;
                    lock.lock();
                    try {
                        boolean $i$a$-withLock-CustomFieldsPermissionsCache$recalculate$1$queue$22 = false;
                        ArrayList<E> queue = new ArrayList<E>(CustomFieldsPermissionsCache.access$getRecalculationRequestQueue$p(this.this$0));
                        CustomFieldsPermissionsCache.access$getRecalculationRequestQueue$p(this.this$0).clear();
                        $i$a$-withLock-CustomFieldsPermissionsCache$recalculate$1$queue$22 = queue;
                    }
                    finally {
                        lock.unlock();
                    }
                    ArrayList<E> queue = $i$a$-withLock-CustomFieldsPermissionsCache$recalculate$1$queue$22;
                    lock = CustomFieldsPermissionsCache.access$getCalculationLock$p(this.this$0);
                    bl = false;
                    lock.lock();
                    try {
                        void $this$fold$iv;
                        boolean bl2 = false;
                        CacheCalculator noop = NoopCacheCalculator.INSTANCE;
                        Iterable iterable = queue;
                        CustomFieldsPermissionsCache customFieldsPermissionsCache = this.this$0;
                        boolean $i$f$fold = false;
                        CacheCalculator accumulator$iv = noop;
                        for (T element$iv : $this$fold$iv) {
                            void item;
                            CacheCalculator cacheCalculator = (CacheCalculator)element$iv;
                            CacheCalculator acc = accumulator$iv;
                            boolean bl3 = false;
                            void v0 = item;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"item");
                            accumulator$iv = acc.merge((CacheCalculator)v0);
                        }
                        CacheCalculator cacheCalculator = accumulator$iv;
                        PermissionsCacheData permissionsCacheData = this.this$0.getData();
                        if (permissionsCacheData == null) {
                            Intrinsics.throwNpe();
                        }
                        customFieldsPermissionsCache.setData(cacheCalculator.recalculate(permissionsCacheData));
                        CustomFieldsPermissionsCache.access$isRecalculated$p(this.this$0).signalAll();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                {
                    this.this$0 = customFieldsPermissionsCache;
                    super(1);
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPermissionCacheRecalculation() {
        if (this.getInitComplete()) {
            Companion.getLogger().debug("Waiting for custom field permission cache recalculation");
            Lock lock = this.calculationLock;
            boolean bl = false;
            lock.lock();
            try {
                boolean bl2 = false;
                try {
                    boolean bl3;
                    Lock lock2 = this.queueLock;
                    boolean bl4 = false;
                    lock2.lock();
                    try {
                        boolean bl5 = false;
                        Collection collection = this.recalculationRequestQueue;
                        boolean bl6 = false;
                        bl3 = !collection.isEmpty();
                    }
                    finally {
                        lock2.unlock();
                    }
                    if (bl3 && !this.isRecalculated.await(90L, TimeUnit.SECONDS)) {
                        throw (Throwable)new RuntimeException("Failed to wait for permission cache recalculation");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Companion.getLogger().error("Failed to wait for permission cache recalculation", (Throwable)e);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            Companion.getLogger().debug("Custom field permission cache is recalculated successfully");
        }
    }

    @Override
    @NotNull
    protected XdQuery<XdProject> getProjectsForPermission(@NotNull XdUser user2, @NotNull String permissionName) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)permissionName, (String)"permissionName");
        return XdQueryKt.asQuery((Iterable)BeansKt.getSecurity().getProjectsUnordered(user2.getEntity(), Permission.valueOf((String)permissionName), false), (XdEntityType)((XdEntityType)XdProject.Companion));
    }

    public static final /* synthetic */ ReentrantLock access$getQueueLock$p(CustomFieldsPermissionsCache $this) {
        return $this.queueLock;
    }

    public static final /* synthetic */ LinkedList access$getRecalculationRequestQueue$p(CustomFieldsPermissionsCache $this) {
        return $this.recalculationRequestQueue;
    }

    public static final /* synthetic */ ReentrantLock access$getCalculationLock$p(CustomFieldsPermissionsCache $this) {
        return $this.calculationLock;
    }

    public static final /* synthetic */ Condition access$isRecalculated$p(CustomFieldsPermissionsCache $this) {
        return $this.isRecalculated;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0000H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/ring/cache/CustomFieldsPermissionsCache$CacheCalculator;", "", "merge", "other", "recalculate", "Ljetbrains/youtrack/ring/cache/PermissionsCacheData;", "data", "youtrack-ring-integration"})
    public static interface CacheCalculator {
        @NotNull
        public PermissionsCacheData recalculate(@NotNull PermissionsCacheData var1);

        @NotNull
        public CacheCalculator merge(@NotNull CacheCalculator var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/ring/cache/CustomFieldsPermissionsCache$NoopCacheCalculator;", "Ljetbrains/youtrack/ring/cache/CustomFieldsPermissionsCache$CacheCalculator;", "()V", "merge", "other", "recalculate", "Ljetbrains/youtrack/ring/cache/PermissionsCacheData;", "data", "youtrack-ring-integration"})
    public static final class NoopCacheCalculator
    implements CacheCalculator {
        public static final NoopCacheCalculator INSTANCE;

        @Override
        @NotNull
        public PermissionsCacheData recalculate(@NotNull PermissionsCacheData data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return data;
        }

        @Override
        @NotNull
        public CacheCalculator merge(@NotNull CacheCalculator other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return other;
        }

        private NoopCacheCalculator() {
        }

        static {
            NoopCacheCalculator noopCacheCalculator;
            INSTANCE = noopCacheCalculator = new NoopCacheCalculator();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/ring/cache/CustomFieldsPermissionsCache$PartialCacheCalculator;", "Ljetbrains/youtrack/ring/cache/CustomFieldsPermissionsCache$CacheCalculator;", "users", "Lkotlin/sequences/Sequence;", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "(Ljetbrains/youtrack/ring/cache/CustomFieldsPermissionsCache;Lkotlin/sequences/Sequence;)V", "getUsers", "()Lkotlin/sequences/Sequence;", "merge", "other", "recalculate", "Ljetbrains/youtrack/ring/cache/PermissionsCacheData;", "data", "youtrack-ring-integration"})
    public final class PartialCacheCalculator
    implements CacheCalculator {
        @NotNull
        private final Sequence<XdUser> users;

        @Override
        @NotNull
        public PermissionsCacheData recalculate(@NotNull PermissionsCacheData data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return new PermissionsCacheData(data, this.users);
        }

        @Override
        @NotNull
        public CacheCalculator merge(@NotNull CacheCalculator other) {
            CacheCalculator cacheCalculator;
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            CacheCalculator cacheCalculator2 = other;
            if (cacheCalculator2 instanceof FullCacheCalculator) {
                cacheCalculator = other;
            } else if (cacheCalculator2 instanceof PartialCacheCalculator) {
                cacheCalculator = new PartialCacheCalculator((Sequence<? extends XdUser>)SequencesKt.plus(this.users, ((PartialCacheCalculator)other).users));
            } else if (cacheCalculator2 instanceof NoopCacheCalculator) {
                cacheCalculator = this;
            } else {
                throw (Throwable)new IllegalStateException("Don't know how to proceed with " + Reflection.getOrCreateKotlinClass(other.getClass()));
            }
            return cacheCalculator;
        }

        @NotNull
        public final Sequence<XdUser> getUsers() {
            return this.users;
        }

        public PartialCacheCalculator(Sequence<? extends XdUser> users) {
            Intrinsics.checkParameterIsNotNull(users, (String)"users");
            this.users = users;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0001H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/ring/cache/CustomFieldsPermissionsCache$FullCacheCalculator;", "Ljetbrains/youtrack/ring/cache/CustomFieldsPermissionsCache$CacheCalculator;", "()V", "merge", "other", "recalculate", "Ljetbrains/youtrack/ring/cache/PermissionsCacheData;", "data", "youtrack-ring-integration"})
    public static final class FullCacheCalculator
    implements CacheCalculator {
        public static final FullCacheCalculator INSTANCE;

        @Override
        @NotNull
        public PermissionsCacheData recalculate(@NotNull PermissionsCacheData data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return new PermissionsCacheData();
        }

        @Override
        @NotNull
        public FullCacheCalculator merge(@NotNull CacheCalculator other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return this;
        }

        private FullCacheCalculator() {
        }

        static {
            FullCacheCalculator fullCacheCalculator;
            INSTANCE = fullCacheCalculator = new FullCacheCalculator();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/cache/CustomFieldsPermissionsCache$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

