/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\bJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0012R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\n0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/ring/cache/HubUuidCache;", "", "()V", "permissionIdCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljetbrains/youtrack/core/security/Permission;", "", "projectUuids", "Ljetbrains/exodus/entitystore/Entity;", "uuidToYoutrackProjects", "", "getPermissionId", "permission", "getProjectId", "project", "getProjects", "projectUuid", "recalculate", "", "Companion", "youtrack-ring-integration"})
public final class HubUuidCache {
    private volatile ConcurrentHashMap<String, List<Entity>> uuidToYoutrackProjects = new ConcurrentHashMap();
    private volatile ConcurrentHashMap<Entity, String> projectUuids = new ConcurrentHashMap();
    private final ConcurrentHashMap<Permission, String> permissionIdCache = new ConcurrentHashMap();
    public static final Companion Companion = new Companion(null);

    public final void recalculate() {
        if (BeansKt.getRingConfig().isEnabled()) {
            Permission[] $this$forEach$iv = Permission.values();
            boolean $i$f$forEach = false;
            Permission[] permissionArray = $this$forEach$iv;
            int n = permissionArray.length;
            for (int i = 0; i < n; ++i) {
                Permission element$iv;
                Permission it = element$iv = permissionArray[i];
                boolean bl = false;
                String id2 = EntityExtensionsKt.getHubUuid(it);
                if (id2 != null) {
                    this.permissionIdCache.put(it, id2);
                    continue;
                }
                Companion.getLogger().error("Permission " + it + " has no Hub mapping");
            }
            ConcurrentHashMap<String, List> uuidToYoutrackProjects = new ConcurrentHashMap<String, List>();
            ConcurrentHashMap<Entity, String> projectUuids = new ConcurrentHashMap<Entity, String>();
            for (Project hubProject : jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectDAO().getAllItems(true)) {
                boolean element$iv = false;
                List projectsInHubProject = new ArrayList();
                for (Resource resource : hubProject.getResources()) {
                    Entity project;
                    EntityIterator iterator2;
                    EntityIterable projects2;
                    TransientStoreSession transientStoreSession = jetbrains.youtrack.gaprest.BeansKt.getTransientEntityStore().getThreadSession();
                    if (transientStoreSession == null) {
                        Intrinsics.throwNpe();
                    }
                    Resource resource2 = resource;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resource2, (String)"resource");
                    Intrinsics.checkExpressionValueIsNotNull((Object)transientStoreSession.find("Project", "$$hubId$$", (Comparable)((Object)resource2.getId())), (String)"transientEntityStore.thr\u2026pter.HUB_ID, resource.id)");
                    Intrinsics.checkExpressionValueIsNotNull((Object)projects2.iterator(), (String)"projects.iterator()");
                    if (!iterator2.hasNext()) continue;
                    Entity entity = project = DnqUtils.cast((Object)iterator2.next(), (String)"Project");
                    Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"project");
                    projectsInHubProject.add(entity);
                    projectUuids.put(project, hubProject.getId());
                }
                uuidToYoutrackProjects.put(hubProject.getId(), projectsInHubProject);
            }
            this.uuidToYoutrackProjects = uuidToYoutrackProjects;
            this.projectUuids = projectUuids;
        }
    }

    @NotNull
    public final List<Entity> getProjects(@NotNull String projectUuid) {
        Intrinsics.checkParameterIsNotNull((Object)projectUuid, (String)"projectUuid");
        List list = this.uuidToYoutrackProjects.get(projectUuid);
        if (list == null) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"uuidToYoutrackProjects[projectUuid] ?: listOf()");
        return list;
    }

    @Nullable
    public final String getProjectId(@NotNull Entity project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.projectUuids.get(project);
    }

    @Nullable
    public final String getPermissionId(@NotNull Permission permission) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        return this.permissionIdCache.get(permission);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/cache/HubUuidCache$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

