/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.dao.api.permissionCache.Handler;
import jetbrains.jetpass.dao.api.permissionCache.StringInterner;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.persistent.XdSuperUser;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.cache.BasePermissionsData;
import jetbrains.youtrack.ring.cache.BeansKt;
import jetbrains.youtrack.ring.cache.CustomFieldAccessHandler;
import jetbrains.youtrack.ring.cache.HubPermissionsData;
import jetbrains.youtrack.ring.cache.PermissionsCacheDataKt;
import jetbrains.youtrack.ring.cache.ProjectCustomFieldsSnapshot;
import jetbrains.youtrack.ring.cache.SuperUserHubPermissionsData;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanCreationNotAllowedException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001d\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/ring/cache/PermissionsCacheData;", "", "()V", "source", "recalculateFor", "Lkotlin/sequences/Sequence;", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "(Ljetbrains/youtrack/ring/cache/PermissionsCacheData;Lkotlin/sequences/Sequence;)V", "pcfSnapshot", "Ljetbrains/youtrack/ring/cache/ProjectCustomFieldsSnapshot;", "userPermissions", "", "", "Ljetbrains/youtrack/ring/cache/BasePermissionsData;", "getUserPermissions$youtrack_ring_integration", "()Ljava/util/Map;", "calculate", "", "users", "Companion", "youtrack-ring-integration"})
public final class PermissionsCacheData {
    private final ProjectCustomFieldsSnapshot pcfSnapshot;
    @NotNull
    private final Map<String, BasePermissionsData> userPermissions;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, BasePermissionsData> getUserPermissions$youtrack_ring_integration() {
        return this.userPermissions;
    }

    private final void calculate(Sequence<? extends XdUser> users) {
        long time = System.currentTimeMillis();
        StringInterner interner = BeansKt.getCustomFieldPermissionCacheInterner();
        Map roughHandles = new HashMap();
        Map fineHandles = new HashMap();
        int counter = 0;
        for (XdUser user2 : users) {
            try {
                Object object;
                Object object2;
                String ringUserId = EntityExtensionsKt.getHubUuid((XdEntity)user2);
                if (ringUserId == null) {
                    if (user2.isService() || user2.isSystem()) continue;
                    Companion.getLogger().error("User " + user2.getLogin() + " is not associated with hub.");
                    continue;
                }
                ++counter;
                User ringUser = (User)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserDAO().get(ringUserId);
                if (ringUser == null) {
                    Companion.getLogger().error("User " + user2.getLogin() + " has ring id " + ringUserId + " unknown to Hub");
                    continue;
                }
                Handler handle = new Handler(ringUser, interner);
                Map $this$getOrPut$iv = roughHandles;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(handle);
                if (value$iv == null) {
                    boolean bl = false;
                    CustomFieldAccessHandler answer$iv = new CustomFieldAccessHandler(user2, ringUser, this.pcfSnapshot, interner);
                    $this$getOrPut$iv.put(handle, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                CustomFieldAccessHandler fieldHandle = (CustomFieldAccessHandler)object2;
                Map $this$getOrPut$iv2 = fineHandles;
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(fieldHandle);
                if (value$iv2 == null) {
                    boolean bl = false;
                    HubPermissionsData answer$iv = new HubPermissionsData(ringUserId, user2.getEntityId(), this.pcfSnapshot);
                    $this$getOrPut$iv2.put(fieldHandle, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                BasePermissionsData data = (BasePermissionsData)object;
                this.userPermissions.put(ringUserId, data);
            }
            catch (BeanCreationNotAllowedException e) {
                throw (Throwable)e;
            }
            catch (Exception e) {
                Companion.getLogger().warn("Failed to build permission cache record for user " + EntityExtensionsKt.getHubUuid((XdEntity)user2), (Throwable)e);
            }
        }
        SuperUserHubPermissionsData superUserData = new SuperUserHubPermissionsData(this.pcfSnapshot);
        for (XdSuperUser superUser : XdQueryKt.toList((XdQuery)XdSuperUser.Companion.all())) {
            this.userPermissions.put(PermissionsCacheDataKt.getUserKey((XdUser)superUser), superUserData);
        }
        Companion.getLogger().info("Custom field permission cache for " + counter + " users built in " + (System.currentTimeMillis() - time) + " ms");
        Companion.getLogger().debug((Function0)new Function0<String>(this, roughHandles, fineHandles){
            final /* synthetic */ PermissionsCacheData this$0;
            final /* synthetic */ Map $roughHandles;
            final /* synthetic */ Map $fineHandles;

            @NotNull
            public final String invoke() {
                return "CFPC: [Field snapshots: " + PermissionsCacheData.access$getPcfSnapshot$p(this.this$0).getProjectCustomFields().size() + ", Rough handles: " + this.$roughHandles.size() + ", Fine handles: " + this.$fineHandles.size() + ']';
            }
            {
                this.this$0 = permissionsCacheData;
                this.$roughHandles = map;
                this.$fineHandles = map2;
                super(0);
            }
        });
    }

    public PermissionsCacheData() {
        final long time = System.currentTimeMillis();
        Companion.getLogger().debug("Rebuilding Hub-based custom field permission cache...");
        this.userPermissions = new ConcurrentHashMap();
        this.pcfSnapshot = new ProjectCustomFieldsSnapshot();
        Companion.getLogger().debug((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                return "Custom field snapshot built in " + (System.currentTimeMillis() - time) + " ms";
            }
        });
        this.calculate((Sequence<? extends XdUser>)XdQueryKt.asSequence((XdQuery)XdUser.Companion.getAllUsers()));
    }

    public PermissionsCacheData(@NotNull PermissionsCacheData source, @NotNull Sequence<? extends XdUser> recalculateFor) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(recalculateFor, (String)"recalculateFor");
        Companion.getLogger().debug("Updating Hub-based custom field permission cache incrementally...");
        this.userPermissions = source.userPermissions;
        this.pcfSnapshot = new ProjectCustomFieldsSnapshot();
        this.calculate(recalculateFor);
    }

    public static final /* synthetic */ ProjectCustomFieldsSnapshot access$getPcfSnapshot$p(PermissionsCacheData $this) {
        return $this.pcfSnapshot;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/cache/PermissionsCacheData$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

