/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.client;

import jetbrains.charisma.authentication.LoginContext;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.oauth2.OAuth2Client;
import jetbrains.jetpass.client.oauth2.token.OAuth2ResourceOwnerFlow;
import jetbrains.youtrack.ring.client.BeansKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="hubClient")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/ring/client/AuthClientWrapper;", "", "()V", "accountsClient", "Ljetbrains/jetpass/client/accounts/BaseAccountsClient;", "getAccountsClient", "()Ljetbrains/jetpass/client/accounts/BaseAccountsClient;", "accountsClientWithLongTimeouts", "getAccountsClientWithLongTimeouts", "anonymousAccountsClient", "getAnonymousAccountsClient", "buildOwnerFlow", "Ljetbrains/jetpass/client/oauth2/token/OAuth2ResourceOwnerFlow;", "login", "", "password", "context", "Ljetbrains/charisma/authentication/LoginContext;", "youtrack-ring-integration"})
public final class AuthClientWrapper {
    @Nullable
    public final String login(@NotNull LoginContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = context.getLogin();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.login");
        String string2 = context.getPassword();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.password");
        return this.buildOwnerFlow(string, string2).getToken().getUser();
    }

    private final OAuth2ResourceOwnerFlow buildOwnerFlow(String login, String password) {
        OAuth2Client oauth2Client = BeansKt.getHubClientFactory().getClients().getOauthClient();
        OAuth2ResourceOwnerFlow.Builder ownerFlowBuilder = oauth2Client.resourceOwnerFlow();
        ownerFlowBuilder.clientId(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
        ownerFlowBuilder.addScope(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
        ownerFlowBuilder.clientSecret(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getSecret());
        ownerFlowBuilder.username(login);
        ownerFlowBuilder.password(password);
        return ownerFlowBuilder.build();
    }

    @NotNull
    public final BaseAccountsClient getAccountsClient() {
        return BeansKt.getHubClientFactory().getClients().getAccountsClient();
    }

    @NotNull
    public final BaseAccountsClient getAnonymousAccountsClient() {
        return BeansKt.getHubClientFactory().getClients().getAnonymousAccountsClient();
    }

    @NotNull
    public final BaseAccountsClient getAccountsClientWithLongTimeouts() {
        return BeansKt.getHubClientFactory().getClients().getAccountsClientForApi();
    }
}

