/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export;

import java.util.List;
import javax.ws.rs.WebApplicationException;
import jetbrains.charisma.persistent.ReadOnlyKt;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.Filter;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.export.IncrementalExporter;
import jetbrains.youtrack.ring.sync.service.RingService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u000f\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/ring/export/IncrementalExporter;", "", "()V", "services", "", "Ljetbrains/youtrack/ring/sync/service/RingService;", "getServices", "()Ljava/util/List;", "setServices", "(Ljava/util/List;)V", "exceptionSafe", "", "closure", "Lkotlin/Function0;", "export", "exportServices", "isHubLicenseValid", "", "Companion", "youtrack-ring-integration"})
public final class IncrementalExporter {
    @Autowired
    @NotNull
    public List<? extends RingService> services;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<RingService> getServices() {
        List<RingService> list = this.services;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"services");
        }
        return list;
    }

    public final void setServices(@NotNull List<? extends RingService> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.services = list;
    }

    public final void export() {
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ IncrementalExporter this$0;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (ReadOnlyKt.isReadonly()) {
                    IncrementalExporter.Companion.getLogger().warn("YouTrack is readonly, skipping Hub export actions");
                    return;
                }
                IncrementalExporter.access$exportServices(this.this$0);
                if (!IncrementalExporter.access$isHubLicenseValid(this.this$0)) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Hub's license is invalid, skipping export actions");
                    return;
                }
                IncrementalExporter.access$exceptionSafe(this.this$0, export.1.INSTANCE);
                IncrementalExporter.access$exceptionSafe(this.this$0, export.2.INSTANCE);
                IncrementalExporter.access$exceptionSafe(this.this$0, export.3.INSTANCE);
                IncrementalExporter.access$exceptionSafe(this.this$0, export.4.INSTANCE);
            }
            {
                this.this$0 = incrementalExporter;
                super(1);
            }
        }));
    }

    private final void exportServices() {
        this.exceptionSafe((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ IncrementalExporter this$0;

            public final void invoke() {
                IncrementalExporter.Companion.getLogger().info("Exporting service data...");
                Iterable $this$forEach$iv = this.this$0.getServices();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    RingService it = (RingService)element$iv;
                    boolean bl = false;
                    it.update();
                }
            }
            {
                this.this$0 = incrementalExporter;
                super(0);
            }
        }));
    }

    private final void exceptionSafe(Function0<Unit> closure) {
        try {
            closure.invoke();
        }
        catch (WebApplicationException e) {
            String response = (String)e.getResponse().readEntity(String.class);
            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Got error while exporting data into Hub: " + response, e);
        }
        catch (Exception e) {
            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Got error while exporting data into Hub: " + e.getMessage(), e);
        }
    }

    private final boolean isHubLicenseValid() {
        Filter filter = (Filter)new Filter(null, 1, null).query("service: 0-0-0-0-0");
        return BeansKt.getHubClient().getAccountsClient().getPermissionClient().getPermissionPage((BaseFilter)filter, null).getItems().size() > 10;
    }

    public static final /* synthetic */ void access$exportServices(IncrementalExporter $this) {
        $this.exportServices();
    }

    public static final /* synthetic */ boolean access$isHubLicenseValid(IncrementalExporter $this) {
        return $this.isHubLicenseValid();
    }

    public static final /* synthetic */ void access$exceptionSafe(IncrementalExporter $this, Function0 closure) {
        $this.exceptionSafe((Function0<Unit>)closure);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/export/IncrementalExporter$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

