/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.client.accounts.CertificateClient;
import jetbrains.jetpass.client.accounts.KeyStoreClient;
import jetbrains.jetpass.rest.dto.CertificateJSON;
import jetbrains.jetpass.rest.dto.KeyStoreDataJSON;
import jetbrains.jetpass.rest.dto.KeyStoreJSON;
import jetbrains.youtrack.api.application.AppLifecycleListenerAdapter;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.ssl.XdKeyStorage;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.core.ssl.XdTrustStorage;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.listeners.hub.KeyStoreHubEventListener;
import jetbrains.youtrack.ring.listeners.hub.TrustedCertificateHubEventListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/ring/export/KeyStoreStartupSynchronizer;", "Ljetbrains/youtrack/api/application/AppLifecycleListenerAdapter;", "()V", "deleteEntry", "", "hubUuid", "", "getEntry", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "start", "youtrack-ring-integration"})
public final class KeyStoreStartupSynchronizer
extends AppLifecycleListenerAdapter {
    public void start() {
        if (BeansKt.getRingConfig().isEnabled() && !BeansKt.getRingConfig().hasEmbeddedHub()) {
            KeyStoreClient keyStoreClient = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getStoreClient();
            for (KeyStoreJSON json : keyStoreClient.getKeyStorePage(null, KeyStoreHubEventListener.Companion.getPARTIAL()).getKeystores()) {
                if (!XdQueryKt.isEmpty((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdStorageEntry.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdStorageEntry, XdSearchingNode>(json){
                    final /* synthetic */ KeyStoreJSON $json;

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdStorageEntry it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$json.getName()));
                    }
                    {
                        this.$json = keyStoreJSON;
                        super(2);
                    }
                })))) continue;
                try {
                    String password;
                    KeyStoreDataJSON dataJson;
                    if (json.getData() == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataJson, (String)"json.data!!");
                    String string = dataJson.getBytes();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dataJson.bytes!!");
                    CharSequence charSequence = string;
                    String string2 = "\n";
                    boolean bl = false;
                    string2 = new Regex(string2);
                    String string3 = "";
                    boolean bl2 = false;
                    byte[] bytes = Base64.decodeBase64((String)string2.replace(charSequence, string3));
                    if (dataJson.getPassword() == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)password, (String)"dataJson.password!!");
                    XdStorageEntry xdEntry = (XdStorageEntry)CollectionsKt.first((Iterable)((XdKeyStorage)XdExtensionsKt.toXd((Entity)((Entity)jetbrains.charisma.ssl.keystore.BeansKt.getKeyStorage()))).importKeyStore((InputStream)new ByteArrayInputStream(bytes), password, null));
                    String string4 = json.getName();
                    if (string4 == null) {
                        Intrinsics.throwNpe();
                    }
                    xdEntry.setName(string4);
                    EntityExtensionsKt.setHubUuid((XdEntity)xdEntry, json.getId());
                    LegacySupportKt.flush();
                }
                catch (Exception e) {
                    KeyStoreHubEventListener.Companion.getLogger().warn("Failed to import SSL key from hub - " + json.getName() + ". Reason: " + e.getMessage());
                }
            }
            CertificateClient certificateClient = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getCertificateClient();
            for (CertificateJSON json : certificateClient.getCertificatePage(null, TrustedCertificateHubEventListener.Companion.getPARTIAL()).getCertificates()) {
                if (Intrinsics.areEqual((Object)json.isDisabled(), (Object)true)) {
                    this.deleteEntry(json.getId());
                    continue;
                }
                if (!XdQueryKt.isEmpty((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)jetbrains.charisma.ssl.keystore.BeansKt.getTrustStorage().getEntries()), (Function2)((Function2)new Function2<FilteringContext, XdStorageEntry, XdSearchingNode>(json){
                    final /* synthetic */ CertificateJSON $json;

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdStorageEntry it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$json.getName()));
                    }
                    {
                        this.$json = certificateJSON;
                        super(2);
                    }
                })))) continue;
                ByteArrayInputStream stream = new ByteArrayInputStream(Base64.decodeBase64((String)json.getData()));
                XdTrustStorage xdTrustStorage = jetbrains.charisma.ssl.keystore.BeansKt.getTrustStorage();
                InputStream inputStream = stream;
                String string = json.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json.name!!");
                XdStorageEntry entry = xdTrustStorage.addTrustedCert(inputStream, string, null);
                String string5 = json.getName();
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                entry.setName(string5);
                String string6 = json.getId();
                if (string6 == null) {
                    Intrinsics.throwNpe();
                }
                entry.setName(string6);
            }
            LegacySupportKt.flush();
        }
    }

    private final XdStorageEntry getEntry(String hubUuid) {
        Object v0;
        block1: {
            Iterable iterable = XdQueryKt.toList((XdQuery)((XdQuery)jetbrains.charisma.ssl.keystore.BeansKt.getTrustStorage().getEntries()));
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                XdStorageEntry it = (XdStorageEntry)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)EntityExtensionsKt.getHubUuid((XdEntity)it), (Object)hubUuid)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void deleteEntry(String hubUuid) {
        block0: {
            XdStorageEntry xdStorageEntry = this.getEntry(hubUuid);
            if (xdStorageEntry == null) break block0;
            XdStorageEntry xdStorageEntry2 = xdStorageEntry;
            boolean bl = false;
            boolean bl2 = false;
            XdStorageEntry it = xdStorageEntry2;
            boolean bl3 = false;
            TrustedCertificateHubEventListener.Companion.getLogger().info("Certificate " + it.getName() + " is disabled or deleted in Hub, removing local instance");
            it.delete();
        }
    }
}

