/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.adapter;

import java.util.Collection;
import java.util.List;
import jetbrains.jetpass.client.BaseField;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.OrganizationClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.OrganizationJSON;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.core.persistent.XdOrganization;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.export.FailureExportResult;
import jetbrains.youtrack.ring.export.SuccessExportResult;
import jetbrains.youtrack.ring.export.adapter.XdEntityHubSyncAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/ring/export/adapter/OrganizationHubSyncAdapter;", "Ljetbrains/youtrack/ring/export/adapter/XdEntityHubSyncAdapter;", "Ljetbrains/youtrack/core/persistent/XdOrganization;", "()V", "export", "Ljetbrains/youtrack/api/ring/HubExportResult;", "youtrackEntity", "youtrack-ring-integration"})
public final class OrganizationHubSyncAdapter
extends XdEntityHubSyncAdapter<XdOrganization> {
    @Override
    @NotNull
    public HubExportResult export(@NotNull XdOrganization youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        try {
            HubExportResult hubExportResult;
            Filter filter = new Filter(null, 1, null);
            filter.query("name: {" + youtrackEntity.getName() + '}');
            OrganizationClient client2 = BeansKt.getHubClient().getAccountsClient().getOrganizationClient();
            FieldPartial partial = new FieldPartial((BaseField[])new Partial.Organization[]{Partial.Organization.ID});
            List hubOrganizations2 = client2.getOrganizationPage((BaseFilter)filter, partial).getOrganizations();
            Collection collection = hubOrganizations2;
            boolean bl = false;
            if (!collection.isEmpty()) {
                String string = ((OrganizationJSON)hubOrganizations2.get(0)).getId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hubOrganizations[0].id!!");
                String ringId2 = string;
                EntityExtensionsKt.setHubUuid((XdEntity)youtrackEntity, ringId2);
                hubExportResult = new SuccessExportResult(ringId2, "Organization " + youtrackEntity.getName() + " linked with Hub");
            } else {
                OrganizationJSON organizationJSON = new OrganizationJSON();
                OrganizationClient organizationClient = client2;
                boolean bl2 = false;
                boolean bl3 = false;
                OrganizationJSON it = organizationJSON;
                boolean bl4 = false;
                it.setName(youtrackEntity.getName());
                OrganizationJSON organizationJSON2 = organizationJSON;
                OrganizationJSON result2 = OrganizationClient.createOrganization$default((OrganizationClient)organizationClient, (OrganizationJSON)organizationJSON2, null, (int)2, null);
                EntityExtensionsKt.setHubUuid((XdEntity)youtrackEntity, result2.getId());
                String string = result2.getId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.id!!");
                hubExportResult = new SuccessExportResult(string, "Organization " + youtrackEntity.getName() + " exported into Hub");
            }
            return hubExportResult;
        }
        catch (Exception e) {
            return new FailureExportResult("The following organization cannot be exported to hub: " + youtrackEntity.getName(), e);
        }
    }
}

