/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.adapter;

import jetbrains.jetpass.api.IdItem;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.ring.export.adapter.ProjectHubSyncAdapter;
import jetbrains.youtrack.ring.impl.BeansKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/ring/export/adapter/ProjectEmbeddedHubSyncAdapter;", "Ljetbrains/youtrack/ring/export/adapter/ProjectHubSyncAdapter;", "()V", "isMutable", "", "projectUuid", "", "remove", "", "youtrackEntity", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "update", "Companion", "youtrack-ring-integration"})
public final class ProjectEmbeddedHubSyncAdapter
extends ProjectHubSyncAdapter {
    public static final Companion Companion = new Companion(null);

    @Override
    public void update(@NotNull XdProject youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        super.update(youtrackEntity);
        String hubProject = jetbrains.charisma.ring.BeansKt.getRingDataStore().getProjectRingId(youtrackEntity);
        if (hubProject == null) {
            Companion.getLogger().warn("Project " + youtrackEntity.getDisplayName() + " has invalid or missing Hub mappings, skipping update");
        } else if (this.isMutable(hubProject)) {
            jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectDAO().update(hubProject, (IdItem)this.getDtoBuilder().buildProject(youtrackEntity));
        }
    }

    @Override
    public void remove(@NotNull XdProject youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        String hubProject = jetbrains.charisma.ring.BeansKt.getRingDataStore().getProjectRingId(youtrackEntity);
        if (hubProject == null) {
            Companion.getLogger().warn("Project " + youtrackEntity.getDisplayName() + " has invalid or missing Hub mappings, unable to delete it in Hub");
        } else if (this.isMutable(hubProject)) {
            this.getProjectClient().deleteProject(hubProject, null);
        }
        super.remove(youtrackEntity);
    }

    private final boolean isMutable(String projectUuid) {
        return Intrinsics.areEqual((Object)BeansKt.getHubGlobalProjectUuid(), (Object)projectUuid) ^ true;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/export/adapter/ProjectEmbeddedHubSyncAdapter$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

