/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.ProjectClient;
import jetbrains.jetpass.client.accounts.ResourceClient;
import jetbrains.jetpass.dao.api.ItemNotFoundException;
import jetbrains.jetpass.dao.api.NotUniqueFieldException;
import jetbrains.jetpass.dao.remote.api.security.RemoteProjectDAO;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ResourceJSON;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.persistent.XdProjectExportSpec;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.export.FailureExportResult;
import jetbrains.youtrack.ring.export.SuccessExportResult;
import jetbrains.youtrack.ring.export.adapter.HubSyncAdapter;
import jetbrains.youtrack.ring.export.adapter.XdEntityHubSyncAdapter;
import jetbrains.youtrack.ring.export.dto.ProjectDtoBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Ljetbrains/youtrack/ring/export/adapter/ProjectHubSyncAdapter;", "Ljetbrains/youtrack/ring/export/adapter/XdEntityHubSyncAdapter;", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "()V", "dtoBuilder", "Ljetbrains/youtrack/ring/export/dto/ProjectDtoBuilder;", "getDtoBuilder", "()Ljetbrains/youtrack/ring/export/dto/ProjectDtoBuilder;", "projectClient", "Ljetbrains/jetpass/client/accounts/ProjectClient;", "getProjectClient", "()Ljetbrains/jetpass/client/accounts/ProjectClient;", "resourceClient", "Ljetbrains/jetpass/client/accounts/ResourceClient;", "getResourceClient", "()Ljetbrains/jetpass/client/accounts/ResourceClient;", "add", "Ljetbrains/youtrack/api/ring/HubExportResult;", "youtrackEntity", "addResource", "Ljetbrains/jetpass/rest/dto/ResourceJSON;", "project", "bulkExport", "", "entities", "", "findProjectToLinkWith", "Ljetbrains/jetpass/api/security/Project;", "localProject", "findResourceToLinkWith", "remove", "update", "Companion", "youtrack-ring-integration"})
public class ProjectHubSyncAdapter
extends XdEntityHubSyncAdapter<XdProject> {
    @NotNull
    private final ProjectDtoBuilder dtoBuilder = new ProjectDtoBuilder();
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final ProjectDtoBuilder getDtoBuilder() {
        return this.dtoBuilder;
    }

    private final ResourceClient getResourceClient() {
        return BeansKt.getHubClient().getAccountsClient().getResourceClient();
    }

    @NotNull
    protected final ProjectClient getProjectClient() {
        return BeansKt.getHubClient().getAccountsClient().getProjectClient();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bulkExport(@NotNull Iterable<XdProject> entities) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
        Filter filter = new Filter(null, 1, null);
        filter.query("service: " + jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
        filter.top(Integer.MAX_VALUE);
        ResourceClient.Page page = this.getResourceClient().getResourcePage((BaseFilter)filter, (FieldPartial)Partial.resource((Partial.Resource[])new Partial.Resource[]{Partial.Resource.ID}));
        Iterable $this$map$iv = page.getResources();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceJSON resourceJSON = (ResourceJSON)item$iv$iv;
            Collection collection2 = collection;
            boolean bl = false;
            String string = it.getId();
            collection2.add(string);
        }
        List resourceIds = (List)collection;
        Iterable<XdProject> $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object e : $this$forEach$iv) {
            XdProject localProject = (XdProject)e;
            boolean bl = false;
            if (resourceIds.contains(EntityExtensionsKt.getHubUuid((XdEntity)localProject))) {
                try {
                    this.update(localProject);
                }
                catch (WebApplicationException e2) {
                    String response = (String)e2.getResponse().readEntity(String.class);
                    Companion.getLogger().warn(response, (Throwable)e2);
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Got error while exporting data into Hub: " + response);
                }
                catch (Exception e3) {
                    Companion.getLogger().warn("", (Throwable)e3);
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Got error while exporting data into Hub: " + e3.getMessage());
                }
                continue;
            }
            this.add(localProject);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public HubExportResult add(@NotNull XdProject youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        try {
            ResourceJSON hubResource2 = this.addResource(youtrackEntity);
            EntityExtensionsKt.setHubUuid((XdEntity)youtrackEntity, hubResource2.getId());
            try {
                void hubProject;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = this.findProjectToLinkWith(youtrackEntity);
                if ((Project)hubProject.element == null) {
                    hubProject.element = (Project)this.getProjectClient().createProject(this.dtoBuilder.buildProject(youtrackEntity), null);
                }
                HubSyncAdapter.retry$default(this, 0, (Function0)new Function0<Unit>((Ref.ObjectRef)hubProject, hubResource2){
                    final /* synthetic */ Ref.ObjectRef $hubProject;
                    final /* synthetic */ ResourceJSON $hubResource;

                    public final void invoke() {
                        RemoteProjectDAO remoteProjectDAO = BeansKt.getRingApi().getProjectDAO();
                        String string = ((Project)this.$hubProject.element).getId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hubProject.id");
                        String string2 = this.$hubResource.getId();
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"hubResource.id!!");
                        remoteProjectDAO.addResource(string, string2);
                    }
                    {
                        this.$hubProject = objectRef;
                        this.$hubResource = resourceJSON;
                        super(0);
                    }
                }, 1, null);
            }
            catch (NotUniqueFieldException e) {
                HubSyncAdapter.retry$default(this, 0, (Function0)new Function0<Unit>(this, youtrackEntity, hubResource2){
                    final /* synthetic */ ProjectHubSyncAdapter this$0;
                    final /* synthetic */ XdProject $youtrackEntity;
                    final /* synthetic */ ResourceJSON $hubResource;

                    public final void invoke() {
                        RemoteProjectDAO remoteProjectDAO = BeansKt.getRingApi().getProjectDAO();
                        Project project = ProjectHubSyncAdapter.access$findProjectToLinkWith(this.this$0, this.$youtrackEntity);
                        if (project == null) {
                            Intrinsics.throwNpe();
                        }
                        String string = project.getId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"findProjectToLinkWith(youtrackEntity)!!.id");
                        String string2 = this.$hubResource.getId();
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"hubResource.id!!");
                        remoteProjectDAO.addResource(string, string2);
                    }
                    {
                        this.this$0 = projectHubSyncAdapter;
                        this.$youtrackEntity = xdProject;
                        this.$hubResource = resourceJSON;
                        super(0);
                    }
                }, 1, null);
            }
            String string = hubResource2.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hubResource.id!!");
            return new SuccessExportResult(string, youtrackEntity.getDisplayName() + " exported into Hub");
        }
        catch (Exception e) {
            return new FailureExportResult("The following project cannot be exported to Hub: " + youtrackEntity.getDisplayName(), e);
        }
    }

    @Override
    public void update(@NotNull XdProject youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        String resourceId = EntityExtensionsKt.getHubUuid((XdEntity)youtrackEntity);
        if (resourceId != null) {
            ResourceJSON resource = this.dtoBuilder.build(youtrackEntity);
            resource.setId(resourceId);
            HubSyncAdapter.retry$default(this, 0, (Function0)new Function0<Unit>(resourceId, resource){
                final /* synthetic */ String $resourceId;
                final /* synthetic */ ResourceJSON $resource;

                public final void invoke() {
                    BeansKt.getRingApi().getResourceDAO().update(this.$resourceId, (IdItem)this.$resource);
                }
                {
                    this.$resourceId = string;
                    this.$resource = resourceJSON;
                    super(0);
                }
            }, 1, null);
        } else {
            Companion.getLogger().warn("No associated Hub resource found for YouTrack project " + youtrackEntity.getDisplayName());
        }
    }

    @Override
    public void remove(@NotNull XdProject youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        String resourceId = EntityExtensionsKt.getHubUuid((XdEntity)youtrackEntity);
        if (resourceId != null) {
            try {
                BeansKt.getRingApi().getResourceDAO().delete(resourceId);
            }
            catch (ItemNotFoundException e) {
                Companion.getLogger().info("Skipping resource " + resourceId + " removal. Resource doesn't exist in Hub.");
            }
        } else {
            Companion.getLogger().warn("No associated Hub resource found for YouTrack project " + youtrackEntity.getDisplayName());
        }
    }

    private final ResourceJSON addResource(XdProject project) {
        ResourceJSON resourceJSON;
        ResourceJSON json = this.dtoBuilder.build(project);
        try {
            ResourceJSON hubResource2 = (ResourceJSON)HubSyncAdapter.retry$default(this, 0, (Function0)new Function0<ResourceJSON>(this, json){
                final /* synthetic */ ProjectHubSyncAdapter this$0;
                final /* synthetic */ ResourceJSON $json;

                @NotNull
                public final ResourceJSON invoke() {
                    return ProjectHubSyncAdapter.access$getResourceClient$p(this.this$0).createResource(this.$json, null);
                }
                {
                    this.this$0 = projectHubSyncAdapter;
                    this.$json = resourceJSON;
                    super(0);
                }
            }, 1, null);
            Companion.getLogger().info("Project " + project.getDisplayName() + " exported as Hub resource '" + hubResource2.getName() + "' with UUID " + hubResource2.getId());
        }
        catch (WebApplicationException e) {
            Companion.getLogger().warn("Hub resource export failed: " + (String)e.getResponse().readEntity(String.class));
            Response response = e.getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"e.response");
            if (response.getStatus() != 409) {
                throw (Throwable)e;
            }
            resourceJSON = this.findResourceToLinkWith(json);
        }
        return resourceJSON;
    }

    private final ResourceJSON findResourceToLinkWith(ResourceJSON localProject) {
        ResourceClient resourceClient = this.getResourceClient();
        String string = localProject.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localProject.name!!");
        ResourceJSON resource = resourceClient.getResourceByName(string, null);
        if (resource == null) {
            List byKey = this.getResourceClient().getResourcePage(new Filter(null, 1, null).query("key: {" + localProject.getKey() + '}'), null).getItems();
            if (byKey.isEmpty()) {
                throw (Throwable)new IllegalStateException("Resource " + localProject.getName() + " can't be exported into Hub: conflict has been detected and there's nothing suitable to link with");
            }
            resource = (ResourceJSON)byKey.get(0);
        }
        return resource;
    }

    private final Project findProjectToLinkWith(XdProject localProject) {
        Object v0;
        block4: {
            XdProjectExportSpec exportSpec2 = (XdProjectExportSpec)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdProjectExportSpec.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdProjectExportSpec, XdSearchingNode>(localProject){
                final /* synthetic */ XdProject $localProject;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdProjectExportSpec it) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return $this$filter.eq((XdEntity)it.getLocalProject(), (XdEntity)this.$localProject);
                }
                {
                    this.$localProject = xdProject;
                    super(2);
                }
            })));
            if (exportSpec2 != null) {
                ProjectJSON hubProject = this.getProjectClient().getProject(exportSpec2.getHubProjectToExportResourceInto(), null);
                if (hubProject == null) {
                    Companion.getLogger().warn("Failed to add resource " + localProject.getDisplayName() + " to a project " + exportSpec2.getHubProjectToExportResourceInto() + ". Desired project does not seem to exist in Hub");
                } else {
                    exportSpec2.delete();
                    return (Project)hubProject;
                }
            }
            ProjectClient.Filter filter = ProjectClient.Companion.filter();
            filter.top(Integer.MAX_VALUE);
            filter.archived(Boolean.valueOf(true));
            Iterable $this$firstOrNull$iv = this.getProjectClient().getProjectPage((BaseFilter)filter, null).getProjects();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ProjectJSON it = (ProjectJSON)element$iv;
                boolean bl = false;
                if (!(StringsKt.equals((String)it.getKey(), (String)localProject.getShortName(), (boolean)true) || StringsKt.equals((String)it.getName(), (String)localProject.getName(), (boolean)true))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        return v0;
    }

    public static final /* synthetic */ Project access$findProjectToLinkWith(ProjectHubSyncAdapter $this, XdProject localProject) {
        return $this.findProjectToLinkWith(localProject);
    }

    public static final /* synthetic */ ResourceClient access$getResourceClient$p(ProjectHubSyncAdapter $this) {
        return $this.getResourceClient();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/export/adapter/ProjectHubSyncAdapter$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

