/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.RoleClient;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.core.security.DefaultRole;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.export.FailureExportResult;
import jetbrains.youtrack.ring.export.SuccessExportResult;
import jetbrains.youtrack.ring.export.adapter.HubSyncAdapter;
import jetbrains.youtrack.ring.export.adapter.XdEntityHubSyncAdapter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/ring/export/adapter/RoleHubSyncAdapter;", "Ljetbrains/youtrack/ring/export/adapter/XdEntityHubSyncAdapter;", "Ljetbrains/youtrack/persistent/security/XdRole;", "()V", "roleClient", "Ljetbrains/jetpass/client/accounts/RoleClient;", "getRoleClient", "()Ljetbrains/jetpass/client/accounts/RoleClient;", "add", "Ljetbrains/youtrack/api/ring/HubExportResult;", "youtrackEntity", "remove", "", "toDto", "Ljetbrains/jetpass/rest/dto/RoleJSON;", "role", "toHubRoleName", "", "name", "update", "youtrack-ring-integration"})
public final class RoleHubSyncAdapter
extends XdEntityHubSyncAdapter<XdRole> {
    private final RoleClient getRoleClient() {
        return BeansKt.getHubClient().getAccountsClient().getRoleClient();
    }

    @Override
    @NotNull
    public HubExportResult add(@NotNull XdRole youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        try {
            HubExportResult hubExportResult;
            Filter filter = new Filter(null, 1, null);
            filter.query("name: {" + this.toHubRoleName(youtrackEntity.getName()) + "} or name: {" + youtrackEntity.getName() + '}');
            List hubRoles2 = this.getRoleClient().getRolePage((BaseFilter)filter, null).getItems();
            RoleJSON roleDto = this.toDto(youtrackEntity);
            if (!hubRoles2.isEmpty()) {
                String string = ((RoleJSON)hubRoles2.get(0)).getId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hubRoles[0].id!!");
                String ringId2 = string;
                this.getRoleClient().updateRole(ringId2, roleDto);
                EntityExtensionsKt.setHubUuid((XdEntity)youtrackEntity, ringId2);
                hubExportResult = new SuccessExportResult(ringId2, "Role " + youtrackEntity.getName() + " linked with Hub");
            } else {
                RoleJSON result2 = (RoleJSON)HubSyncAdapter.retry$default(this, 0, (Function0)new Function0<RoleJSON>(this, roleDto){
                    final /* synthetic */ RoleHubSyncAdapter this$0;
                    final /* synthetic */ RoleJSON $roleDto;

                    @NotNull
                    public final RoleJSON invoke() {
                        return RoleHubSyncAdapter.access$getRoleClient$p(this.this$0).createRole(this.$roleDto, null);
                    }
                    {
                        this.this$0 = roleHubSyncAdapter;
                        this.$roleDto = roleJSON;
                        super(0);
                    }
                }, 1, null);
                EntityExtensionsKt.setHubUuid((XdEntity)youtrackEntity, result2.getId());
                String string = result2.getId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.id!!");
                hubExportResult = new SuccessExportResult(string, "Role " + youtrackEntity.getName() + " exported into Hub");
            }
            return hubExportResult;
        }
        catch (Exception e) {
            return new FailureExportResult("The following role cannot be exported to hub: " + youtrackEntity.getName(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final RoleJSON toDto(XdRole role) {
        Collection<PermissionJSON> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        RoleJSON roleDto = new RoleJSON();
        roleDto.setName(role.getName());
        roleDto.setDescription(role.getDescription());
        Iterable iterable = role.getPermissions();
        RoleJSON roleJSON = roleDto;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void permission;
            Permission permission2 = (Permission)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            PermissionJSON json = new PermissionJSON();
            json.setId(EntityExtensionsKt.getHubUuidNotNull((Permission)permission));
            PermissionJSON permissionJSON = json;
            collection.add(permissionJSON);
        }
        collection = (List)destination$iv$iv;
        roleJSON.setPermissions((Iterable)collection);
        return roleDto;
    }

    private final String toHubRoleName(String name) {
        String string = name;
        return Intrinsics.areEqual((Object)string, (Object)DefaultRole.SYSTEM_ADMIN.getName()) ? "System Admin" : (Intrinsics.areEqual((Object)string, (Object)DefaultRole.PROJECT_ADMIN.getName()) ? "Project Admin" : (Intrinsics.areEqual((Object)string, (Object)DefaultRole.DEVELOPER.getName()) ? "Developer" : name));
    }

    @Override
    public void update(@NotNull XdRole youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        this.getRoleClient().updateRole(EntityExtensionsKt.getHubUuidNotNull((XdEntity)youtrackEntity), this.toDto(youtrackEntity));
    }

    @Override
    public void remove(@NotNull XdRole youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        this.getRoleClient().deleteRole(EntityExtensionsKt.getHubUuidNotNull((XdEntity)youtrackEntity), null);
    }

    public static final /* synthetic */ RoleClient access$getRoleClient$p(RoleHubSyncAdapter $this) {
        return $this.getRoleClient();
    }
}

