/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.adapter;

import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.export.FailureExportResult;
import jetbrains.youtrack.ring.export.HubUserExporter;
import jetbrains.youtrack.ring.export.SuccessExportResult;
import jetbrains.youtrack.ring.export.adapter.HubSyncAdapter;
import jetbrains.youtrack.ring.export.adapter.XdEntityHubSyncAdapter;
import jetbrains.youtrack.ring.export.dto.HubDtoBuilder;
import jetbrains.youtrack.ring.sync.RingUser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/ring/export/adapter/UserHubSyncAdapter;", "Ljetbrains/youtrack/ring/export/adapter/XdEntityHubSyncAdapter;", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "dtoBuilder", "Ljetbrains/youtrack/ring/export/dto/HubDtoBuilder;", "Ljetbrains/jetpass/rest/dto/UserJSON;", "(Ljetbrains/youtrack/ring/export/dto/HubDtoBuilder;)V", "userClient", "Ljetbrains/jetpass/client/accounts/UserClient;", "getUserClient", "()Ljetbrains/jetpass/client/accounts/UserClient;", "add", "Ljetbrains/youtrack/api/ring/HubExportResult;", "youtrackEntity", "bulkExport", "", "entities", "", "doExport", "Ljetbrains/youtrack/ring/export/SuccessExportResult;", "user", "linkUserWithHub", "ringId", "", "remove", "update", "Companion", "youtrack-ring-integration"})
public final class UserHubSyncAdapter
extends XdEntityHubSyncAdapter<XdUser> {
    private final HubDtoBuilder<XdUser, UserJSON> dtoBuilder;
    public static final Companion Companion = new Companion(null);

    private final UserClient getUserClient() {
        return BeansKt.getHubClient().getAccountsClient().getUserClient();
    }

    @Override
    @NotNull
    public HubExportResult add(@NotNull XdUser youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        Exception exception = null;
        try {
            return this.doExport(youtrackEntity);
        }
        catch (WebApplicationException e) {
            exception = (Exception)((Object)e);
            Response response = e.getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"e.response");
            if (response.getStatus() == 409) {
                Filter filter = (Filter)new Filter(null, 1, null).query("login: " + youtrackEntity.getLogin());
                UserJSON userJSON = (UserJSON)CollectionsKt.firstOrNull((List)this.getUserClient().getUserPage((BaseFilter)filter, null).getItems());
                if (userJSON != null) {
                    UserJSON userJSON2 = userJSON;
                    boolean bl = false;
                    boolean bl2 = false;
                    UserJSON it = userJSON2;
                    boolean bl3 = false;
                    String string = it.getId();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.id!!");
                    return this.linkUserWithHub(youtrackEntity, string);
                }
            } else {
                Response response2 = e.getResponse();
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"e.response");
                if (response2.getStatus() == 403) {
                    Companion.getLogger().warn("Got 403 from Hub on user export, will try once again with user " + youtrackEntity.getLogin() + " banned");
                    youtrackEntity.setBanned(true);
                    return this.doExport(youtrackEntity);
                }
            }
        }
        catch (Exception e) {
            exception = e;
        }
        return new FailureExportResult("Following user cannot be exported to hub: " + youtrackEntity.getLogin(), exception);
    }

    private final SuccessExportResult doExport(XdUser user2) {
        UserJSON userJson = this.dtoBuilder.build(user2);
        String ringId2 = (String)HubSyncAdapter.retry$default(this, 0, (Function0)new Function0<String>(this, userJson){
            final /* synthetic */ UserHubSyncAdapter this$0;
            final /* synthetic */ UserJSON $userJson;

            @Nullable
            public final String invoke() {
                return UserHubSyncAdapter.access$getUserClient$p(this.this$0).createUser(this.$userJson, null).getId();
            }
            {
                this.this$0 = userHubSyncAdapter;
                this.$userJson = userJSON;
                super(0);
            }
        }, 1, null);
        EntityExtensionsKt.setHubUuid((XdEntity)user2, ringId2);
        BeansKt.getRingApi().syncNow();
        String string = ringId2;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return new SuccessExportResult(string, "User " + user2.getLogin() + " exported into Hub");
    }

    @NotNull
    public final HubExportResult linkUserWithHub(@NotNull XdUser user2, @NotNull String ringId2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)ringId2, (String)"ringId");
        try {
            UserJSON dto = this.dtoBuilder.build(user2);
            if (!user2.getRoot() && !ConfigurationUtil.isYoutrackHosted()) {
                IdItem idItem = BeansKt.getRingApi().getUserDAO().get(ringId2);
                if (idItem == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)idItem, (String)"ringApi.userDAO[ringId]!!");
                Boolean bl = ((User)idItem).isBanned();
                if (bl == null) {
                    Intrinsics.throwNpe();
                }
                user2.setBanned(bl.booleanValue());
            }
            dto.setBanned(Boolean.valueOf(user2.getBanned()));
            HubSyncAdapter.retry$default(this, 0, (Function0)new Function0<Unit>(ringId2, dto){
                final /* synthetic */ String $ringId;
                final /* synthetic */ UserJSON $dto;

                public final void invoke() {
                    BeansKt.getRingApi().getUserDAO().update(this.$ringId, (IdItem)this.$dto);
                }
                {
                    this.$ringId = string;
                    this.$dto = userJSON;
                    super(0);
                }
            }, 1, null);
        }
        catch (Exception e) {
            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Got an error while linking user with Hub. His/her local data will be discarded.", e);
        }
        EntityExtensionsKt.setHubUuid((XdEntity)user2, ringId2);
        return new SuccessExportResult(ringId2, "User " + user2.getLogin() + " linked with an existing Hub user");
    }

    @Override
    public void bulkExport(@NotNull Iterable<? extends XdUser> entities) {
        Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
        HubUserExporter exporter = new HubUserExporter(this, this.dtoBuilder);
        exporter.export(entities);
        Entity entity = jetbrains.youtrack.core.security.BeansKt.getSecurity().getGuest();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"security.guest");
        new RingUser(EntityExtensionsKt.getHubUuidNotNull(XdExtensionsKt.toXd((Entity)entity))).resolveAndSync();
    }

    @Override
    public void update(@NotNull XdUser youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        this.getUserClient().updateUser(EntityExtensionsKt.getHubUuidNotNull((XdEntity)youtrackEntity), this.dtoBuilder.build(youtrackEntity));
    }

    @Override
    public void remove(@NotNull XdUser youtrackEntity) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackEntity, (String)"youtrackEntity");
        throw (Throwable)new UnsupportedOperationException("Hub users should be removed via Hub");
    }

    public UserHubSyncAdapter(@NotNull HubDtoBuilder<? super XdUser, ? extends UserJSON> dtoBuilder) {
        Intrinsics.checkParameterIsNotNull(dtoBuilder, (String)"dtoBuilder");
        this.dtoBuilder = dtoBuilder;
    }

    public static final /* synthetic */ UserClient access$getUserClient$p(UserHubSyncAdapter $this) {
        return $this.getUserClient();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/export/adapter/UserHubSyncAdapter$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

