/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import jetbrains.jetpass.rest.dto.EmailJSON;
import jetbrains.jetpass.rest.dto.JabberJSON;
import jetbrains.jetpass.rest.dto.ProfileJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.core.persistent.XdPersistentFile;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.persistent.XdUserExtKt;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.export.BeansKt;
import jetbrains.youtrack.ring.export.dto.HubDtoBuilder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0002H\u0004\u00a8\u0006\f"}, d2={"Ljetbrains/youtrack/ring/export/dto/ExportUserHubDtoBuilder;", "Ljetbrains/youtrack/ring/export/dto/HubDtoBuilder;", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "Ljetbrains/jetpass/rest/dto/UserJSON;", "()V", "build", "entity", "getUserGroupsJSON", "", "Ljetbrains/jetpass/rest/dto/UserGroupJSON;", "user", "Companion", "youtrack-ring-integration"})
public class ExportUserHubDtoBuilder
implements HubDtoBuilder<XdUser, UserJSON> {
    private static final String HUB_EMAIL_REGEXP = "([\\w-]+([+.][\\w-]+)*)@([\\w-]+\\.)+[a-z]{2,}$";
    private static final Pattern HUB_EMAIL_PATTERN;
    public static final Companion Companion;

    @Override
    @NotNull
    public UserJSON build(@NotNull XdUser entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        UserJSON json = new UserJSON();
        json.setBanned(Boolean.valueOf(entity.getBanned()));
        json.setName(entity.getVisibleName());
        ProfileJSON profile = new ProfileJSON();
        JabberJSON jabber = new JabberJSON();
        jabber.setJabber(entity.getJabberAccountName());
        profile.setJabber(jabber);
        profile.setEmail(Companion.toEmailJson(entity));
        json.setProfile(profile);
        json.setLogin(entity.getLogin());
        json.setProjectRoles((Iterable)BeansKt.getRoleJsonBuilder().toHubProjectRolesJson(XdUserExtKt.getUserRoles((XdUser)entity)));
        json.setGroups((Iterable)this.getUserGroupsJSON(entity));
        json.setDetails(BeansKt.getUserDetailJsonBuilder().getUserDetails(entity));
        return json;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<UserGroupJSON> getUserGroupsJSON(@NotNull XdUser user2) {
        void $this$mapTo$iv$iv;
        XdUserGroup it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        UserGroupJSON allUsersGroup = new UserGroupJSON();
        allUsersGroup.setId(EntityExtensionsKt.getHubUuid((XdEntity)jetbrains.charisma.persistent.BeansKt.getXdAllUsersGroup()));
        Iterable $this$filter$iv = XdQueryKt.toList((XdQuery)((XdQuery)user2.getGroups()));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (XdUserGroup)element$iv$iv;
            boolean bl = false;
            if (!(EntityExtensionsKt.getHubUuid((XdEntity)it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (XdUserGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserGroupJSON userGroup = new UserGroupJSON();
            userGroup.setId(EntityExtensionsKt.getHubUuid((XdEntity)it));
            UserGroupJSON userGroupJSON = userGroup;
            collection.add(userGroupJSON);
        }
        List userGroups = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)userGroups, (Object)allUsersGroup);
    }

    static {
        Companion = new Companion(null);
        HUB_EMAIL_PATTERN = Pattern.compile(HUB_EMAIL_REGEXP, 2);
    }

    @Override
    @Nullable
    public String getDataUri(@NotNull XdPersistentFile $this$dataUri) {
        Intrinsics.checkParameterIsNotNull((Object)$this$dataUri, (String)"$this$dataUri");
        return HubDtoBuilder.DefaultImpls.getDataUri(this, $this$dataUri);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/youtrack/ring/export/dto/ExportUserHubDtoBuilder$Companion;", "Lmu/KLogging;", "()V", "HUB_EMAIL_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "HUB_EMAIL_REGEXP", "", "toEmailJson", "Ljetbrains/jetpass/rest/dto/EmailJSON;", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        @Nullable
        public final EmailJSON toEmailJson(@NotNull XdUser user2) {
            EmailJSON emailJSON;
            Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
            String string = user2.getEmail();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String email = string2;
                boolean bl3 = false;
                if (HUB_EMAIL_PATTERN.matcher(email).matches()) {
                    EmailJSON json = new EmailJSON();
                    json.setEmail(user2.getEmail());
                    if (user2.getRoot()) {
                        json.setVerified(Boolean.valueOf(true));
                    }
                    return json;
                }
                Companion.getLogger().warn("Email " + user2.getEmail() + " is not valid and cannot be exported into Hub");
                emailJSON = null;
            } else {
                emailJSON = null;
            }
            return emailJSON;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

