/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.persistent.XdPersistentFile;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.export.dto.HubDtoBuilder;
import jetbrains.youtrack.ring.export.dto.PermissionHubDtoBuilder$WhenMappings;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0016R \u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/ring/export/dto/PermissionHubDtoBuilder;", "Ljetbrains/youtrack/ring/export/dto/HubDtoBuilder;", "Ljetbrains/youtrack/core/security/Permission;", "Ljetbrains/jetpass/rest/dto/PermissionJSON;", "()V", "hubEntityTypeAlias", "", "kotlin.jvm.PlatformType", "getHubEntityTypeAlias", "(Ljetbrains/youtrack/core/security/Permission;)Ljava/lang/String;", "hubOperationAlias", "getHubOperationAlias", "build", "permission", "youtrack-ring-integration"})
public final class PermissionHubDtoBuilder
implements HubDtoBuilder<Permission, PermissionJSON> {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PermissionJSON build(@NotNull Permission permission) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        PermissionJSON permissionDto = new PermissionJSON();
        permissionDto.setName(permission.getVisibleName());
        permissionDto.setDescription(permission.getHumanizedDescription());
        String string = permission.getKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"permission.key");
        if (StringsKt.startsWith$default((String)string, (String)"JetBrains.YouTrack", (boolean)false, (int)2, null)) {
            Collection<PermissionJSON> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            permissionDto.setKey(permission.getKey());
            permissionDto.setOperation(this.getHubOperationAlias(permission));
            permissionDto.setEntityType(this.getHubEntityTypeAlias(permission));
            permissionDto.setGlobal(Boolean.valueOf(permission.isGlobal()));
            List list = permission.getImpliedPermissions();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"permission.impliedPermissions");
            Iterable iterable = list;
            PermissionJSON permissionJSON = permissionDto;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void implied;
                Permission permission2 = (Permission)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                PermissionJSON permissionJSON2 = new PermissionJSON();
                boolean bl2 = false;
                boolean bl3 = false;
                PermissionJSON $this$apply = permissionJSON2;
                boolean bl4 = false;
                void v2 = implied;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"implied");
                $this$apply.setId(EntityExtensionsKt.getHubUuidNotNull((Permission)v2));
                PermissionJSON permissionJSON3 = permissionJSON2;
                collection.add(permissionJSON3);
            }
            collection = (List)destination$iv$iv;
            permissionJSON.setImpliedPermissions((Iterable)collection);
        }
        return permissionDto;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getHubOperationAlias(@NotNull Permission $this$hubOperationAlias) {
        Operation operation;
        Operation operation2 = $this$hubOperationAlias.getOperation();
        if (operation2 != null) {
            switch (PermissionHubDtoBuilder$WhenMappings.$EnumSwitchMapping$0[operation2.ordinal()]) {
                case 1: {
                    operation = Operation.CREATE;
                    return operation.toString();
                }
                case 2: {
                    operation = Operation.READ;
                    return operation.toString();
                }
                case 3: {
                    operation = Operation.READ;
                    return operation.toString();
                }
                case 4: {
                    operation = Operation.UPDATE;
                    return operation.toString();
                }
                case 5: {
                    operation = Operation.UPDATE;
                    return operation.toString();
                }
                case 6: {
                    operation = Operation.READ;
                    return operation.toString();
                }
                case 7: {
                    operation = Operation.READ;
                    return operation.toString();
                }
                case 8: {
                    operation = Operation.UPDATE;
                    return operation.toString();
                }
                case 9: {
                    operation = Operation.DELETE;
                    return operation.toString();
                }
                case 10: {
                    operation = Operation.READ;
                    return operation.toString();
                }
            }
        }
        operation = $this$hubOperationAlias.getOperation();
        return operation.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getHubEntityTypeAlias(@NotNull Permission $this$hubEntityTypeAlias) {
        String string;
        String string2 = $this$hubEntityTypeAlias.getPersistentClass();
        if (string2 != null) {
            switch (string2) {
                case "Article": {
                    string = BeansKt.getLocalizer().localizedMsg("PermissionHubDtoBuilder.Article", new Object[0]);
                    return string;
                }
                case "ArticleComment": {
                    string = BeansKt.getLocalizer().localizedMsg("PermissionHubDtoBuilder.Article_comment", new Object[0]);
                    return string;
                }
                case "Issue": {
                    string = BeansKt.getLocalizer().localizedMsg("PermissionHubDtoBuilder.Issue", new Object[0]);
                    return string;
                }
                case "IssueAttachment": {
                    string = BeansKt.getLocalizer().localizedMsg("PermissionHubDtoBuilder.Issue_attachment", new Object[0]);
                    return string;
                }
                case "IssueComment": {
                    string = BeansKt.getLocalizer().localizedMsg("PermissionHubDtoBuilder.Issue_comment", new Object[0]);
                    return string;
                }
                case "IssueWorkItem": {
                    string = BeansKt.getLocalizer().localizedMsg("PermissionHubDtoBuilder.Issue_work_item", new Object[0]);
                    return string;
                }
                case "Report": {
                    string = BeansKt.getLocalizer().localizedMsg("PermissionHubDtoBuilder.Report", new Object[0]);
                    return string;
                }
                case "Visibility": {
                    string = BeansKt.getLocalizer().localizedMsg("PermissionHubDtoBuilder.Issue", new Object[0]);
                    return string;
                }
                case "WatchFolder": {
                    string = BeansKt.getLocalizer().localizedMsg("PermissionHubDtoBuilder.Watch_folder", new Object[0]);
                    return string;
                }
            }
        }
        string = $this$hubEntityTypeAlias.getPersistentClass();
        return string;
    }

    @Override
    @Nullable
    public String getDataUri(@NotNull XdPersistentFile $this$dataUri) {
        Intrinsics.checkParameterIsNotNull((Object)$this$dataUri, (String)"$this$dataUri");
        return HubDtoBuilder.DefaultImpls.getDataUri(this, $this$dataUri);
    }
}

