/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.export.dto;

import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ResourceJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.core.persistent.XdPersistentFile;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.persistent.XdProjectExtKt;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.export.dto.HubDtoBuilder;
import jetbrains.youtrack.ring.persistence.BeansKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/ring/export/dto/ProjectDtoBuilder;", "Ljetbrains/youtrack/ring/export/dto/HubDtoBuilder;", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "Ljetbrains/jetpass/rest/dto/ResourceJSON;", "()V", "build", "entity", "buildProject", "Ljetbrains/jetpass/rest/dto/ProjectJSON;", "project", "youtrack-ring-integration"})
public final class ProjectDtoBuilder
implements HubDtoBuilder<XdProject, ResourceJSON> {
    @Override
    @NotNull
    public ResourceJSON build(@NotNull XdProject entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        ResourceJSON resource = new ResourceJSON();
        resource.setKey(entity.getShortName());
        resource.setName(entity.getName());
        ServiceJSON service = new ServiceJSON();
        service.setId(BeansKt.getRingSettings().getServiceId());
        resource.setService(service);
        resource.setType("youtrack-project");
        if (EntityExtensionsKt.getHubUuid((XdEntity)entity) != null) {
            resource.setHomeUrl("admin/editProject/" + EntityExtensionsKt.getHubUuid((XdEntity)entity));
        }
        return resource;
    }

    @NotNull
    public final ProjectJSON buildProject(@NotNull XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ProjectJSON hubProject = new ProjectJSON();
        UserJSON projectLead = new UserJSON();
        projectLead.setId(EntityExtensionsKt.getHubUuid((XdEntity)XdProjectExtKt.getLeader((XdProject)project)));
        hubProject.setKey(project.getShortName());
        hubProject.setName(project.getName());
        if (XdProjectExtKt.getIcon((XdProject)project) == null) {
            hubProject.setDefaultIcon(Boolean.valueOf(true));
            hubProject.setIconUrl("");
        } else {
            XdPersistentFile xdPersistentFile = XdProjectExtKt.getIcon((XdProject)project);
            hubProject.setIcon(xdPersistentFile != null ? this.getDataUri(xdPersistentFile) : null);
        }
        hubProject.setDescription(project.getDescription());
        hubProject.setArchived(Boolean.valueOf(project.getArchived()));
        if (!XdProjectExtKt.getLeader((XdProject)project).isGuest() && projectLead.getId() != null) {
            hubProject.setOwner(projectLead);
        }
        return hubProject;
    }

    @Override
    @Nullable
    public String getDataUri(@NotNull XdPersistentFile $this$dataUri) {
        Intrinsics.checkParameterIsNotNull((Object)$this$dataUri, (String)"$this$dataUri");
        return HubDtoBuilder.DefaultImpls.getDataUri(this, $this$dataUri);
    }
}

