/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import com.intellij.hub.auth.OAuthException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import jetbrains.charisma.authentication.BaseAuthenticationManager;
import jetbrains.charisma.authentication.IAuthenticationManager;
import jetbrains.charisma.authentication.LoginContext;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.HubReplicatingMarker;
import jetbrains.youtrack.ring.impl.HubAuthenticationManager;
import jetbrains.youtrack.ring.maintenance.BeansKt;
import jetbrains.youtrack.ring.sync.RingUser;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KLogging;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import webr.framework.controller.BaseApplication;

@Component(value="hubAuthenticationManager")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/ring/impl/HubAuthenticationManager;", "Ljetbrains/charisma/authentication/BaseAuthenticationManager;", "()V", "assertRingIntegrationIsEnabled", "", "authorize", "Ljetbrains/exodus/entitystore/Entity;", "context", "Ljetbrains/charisma/authentication/LoginContext;", "getLogin", "Ljetbrains/charisma/authentication/IAuthenticationManager$LoginUrlBuilder;", "getLogout", "Ljetbrains/charisma/authentication/IAuthenticationManager$LogoutUrlBuilder;", "getRelativeUrl", "", "absoluteUrl", "logLegacyRestLogin", "Companion", "youtrack-ring-integration"})
public final class HubAuthenticationManager
extends BaseAuthenticationManager {
    @NotNull
    private static final KLogger legacyAuthLogger;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entity authorize(@NotNull LoginContext context) {
        String user2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.assertRingIntegrationIsEnabled();
        String string = context.getPassword();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.password");
        if (StringsKt.startsWith$default((String)string, (String)"perm:", (boolean)false, (int)2, null)) {
            try {
                XdUser xdUser = jetbrains.charisma.persistent.BeansKt.getHubUuidResolver().resolveUserByAuthHeader("Bearer " + context.getPassword());
                return xdUser != null ? xdUser.getEntity() : null;
            }
            catch (Exception e) {
                Companion.getLogger().warn("Rest login attempt failed for user [" + context.getLogin() + ']', (Throwable)e);
            }
        }
        try {
            user2 = jetbrains.youtrack.ring.client.BeansKt.getHubClient().login(context);
            this.logLegacyRestLogin(context);
        }
        catch (OAuthException e) {
            String message2 = "Rest login attempt failed: " + e.getMessage();
            if (StringsKt.contains$default((CharSequence)message2, (CharSequence)"Invalid resource owner credentials", (boolean)false, (int)2, null)) {
                Companion.getLogger().info(message2);
            } else {
                Companion.getLogger().warn(message2);
            }
            user2 = null;
        }
        catch (Throwable t) {
            Companion.getLogger().warn("Rest login attempt failed for user [" + context.getLogin() + ']', t);
            user2 = null;
        }
        String remoteUserId = user2;
        if (remoteUserId == null && (user2 = context.getUser()) != null) {
            remoteUserId = EntityExtensionsKt.getHubUuid((Entity)user2);
        }
        if (remoteUserId != null) {
            Entity entity;
            boolean $i$f$muteEverything = false;
            try {
                HubReplicatingMarker.INSTANCE.suspendRingNotificationsForThread();
                jetbrains.youtrack.api.application.BeansKt.getRuleEngine().addIgnoreThread();
                jetbrains.charisma.persistent.BeansKt.getSystemApplyEventMarker().add();
                BeansKt.getEventIssueListener().addIgnoreThread();
                boolean bl = false;
                XdUser xdUser = new RingUser(remoteUserId).resolveOrSyncIfMissing();
                Entity resolved = xdUser != null ? xdUser.getEntity() : null;
                LegacySupportKt.flush();
                entity = resolved;
            }
            finally {
                HubReplicatingMarker.INSTANCE.resumeRingNotificationsForThread();
                jetbrains.youtrack.api.application.BeansKt.getRuleEngine().removeIgnoreThread();
                jetbrains.charisma.persistent.BeansKt.getSystemApplyEventMarker().remove();
                BeansKt.getEventIssueListener().removeIgnoreThread();
            }
            return entity;
        }
        return null;
    }

    private final void logLegacyRestLogin(LoginContext context) {
        String string = context.getPassword();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.password");
        if (!StringsKt.startsWith$default((String)string, (String)"perm:", (boolean)false, (int)2, null)) {
            String string2 = context.getPassword();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.password");
            CharSequence charSequence = string2;
            Regex regex = new Regex("[0-9A-Z]{4}(-[0-9A-Z]{4}){4}");
            boolean bl = false;
            if (!regex.matches(charSequence)) {
                String ip = "<unknown>";
                String agent2 = "<unknown>";
                if (BaseApplication.isInsideRequestProcessing()) {
                    HttpServletRequest httpServletRequest = BaseApplication.getRequest();
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpServletRequest, (String)"BaseApplication.getRequest()");
                    String string3 = httpServletRequest.getRemoteAddr();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"BaseApplication.getRequest().remoteAddr");
                    ip = string3;
                    String string4 = BaseApplication.getRequest().getHeader("User-Agent");
                    if (string4 != null) {
                        String string5 = string4;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        String it = string5;
                        boolean bl4 = false;
                        agent2 = it;
                    }
                }
                legacyAuthLogger.debug('[' + context.getLogin() + '@' + ip + "] Login/password REST API login by user agent " + agent2);
            }
        }
    }

    @NotNull
    public IAuthenticationManager.LoginUrlBuilder getLogin() {
        this.assertRingIntegrationIsEnabled();
        return (IAuthenticationManager.LoginUrlBuilder)new BaseAuthenticationManager.LoginUrlBuilder(this){
            final /* synthetic */ HubAuthenticationManager this$0;

            /*
             * Unable to fully structure code
             */
            @NotNull
            public String url() {
                try {
                    if (this.returnTo == null) ** GOTO lbl-1000
                    v0 = this.returnTo;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"returnTo");
                    var2_1 = v0;
                    var3_2 = false;
                    if (var2_1.length() == 0) lbl-1000:
                    // 2 sources

                    {
                        v1 = new StringBuilder();
                        v2 = BaseApplication.getRequest();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"BaseApplication.getRequest()");
                        v3 = v1.append(v2.getContextPath()).append("/").toString();
                    } else {
                        v3 = HubAuthenticationManager.access$getRelativeUrl(this.this$0, this.returnTo);
                    }
                    returnUrl = v3;
                    v4 = new StringBuilder();
                    v5 = BaseApplication.getRequest();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"BaseApplication.getRequest()");
                    builder = new URIBuilder(v4.append(v5.getContextPath()).append("/oauth").toString());
                    builder.addParameter("state", returnUrl);
                    if (this.message != null) {
                        builder.addParameter("message", this.message);
                    }
                    if (this.renew) {
                        builder.setFragment("renew");
                    }
                    v6 = builder.build().toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"builder.build().toString()");
                    result = v6;
                    return StringsKt.startsWith$default((String)result, (String)"/", (boolean)false, (int)2, null) != false ? result : '/' + result;
                }
                catch (URISyntaxException e) {
                    throw (Throwable)new RuntimeException(e);
                }
            }
            {
                this.this$0 = $outer;
                super((BaseAuthenticationManager)$outer);
            }
        };
    }

    @NotNull
    public IAuthenticationManager.LogoutUrlBuilder getLogout() {
        this.assertRingIntegrationIsEnabled();
        return (IAuthenticationManager.LogoutUrlBuilder)new BaseAuthenticationManager.LogoutUrlBuilder(this){
            final /* synthetic */ HubAuthenticationManager this$0;

            @NotNull
            public String url() {
                String string;
                String afterLoginUrl = jetbrains.charisma.main.BeansKt.getSecurityNavigator().getAfterLoginUrl();
                if (afterLoginUrl == null) {
                    String string2 = this.this$0.getLogin().renew().url();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"login.renew().url()");
                } else {
                    String string3 = this.this$0.getLogin().renew().returnTo(afterLoginUrl).url();
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"login.renew().returnTo(afterLoginUrl).url()");
                }
                return string;
            }
            {
                this.this$0 = $outer;
                super((BaseAuthenticationManager)$outer);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getRelativeUrl(String absoluteUrl) {
        if (absoluteUrl == null || StringsKt.startsWith$default((String)absoluteUrl, (String)"/", (boolean)false, (int)2, null)) return absoluteUrl;
        try {
            String string;
            String query;
            URL url = new URL(absoluteUrl);
            String string2 = query = url.getQuery();
            if (string2 != null) {
                CharSequence charSequence = string2;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    string = url.getPath() + '?' + query;
                    return string;
                }
            }
            string = url.getPath();
            return string;
        }
        catch (MalformedURLException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    private final void assertRingIntegrationIsEnabled() {
        LegacySupportKt.transactional((Function1)assertRingIntegrationIsEnabled.1.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        legacyAuthLogger = Companion.logger("jetbrains.youtrack.auth.legacy");
    }

    public static final /* synthetic */ String access$getRelativeUrl(HubAuthenticationManager $this, String absoluteUrl) {
        return $this.getRelativeUrl(absoluteUrl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/ring/impl/HubAuthenticationManager$Companion;", "Lmu/KLogging;", "()V", "legacyAuthLogger", "Lmu/KLogger;", "getLegacyAuthLogger", "()Lmu/KLogger;", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final KLogger getLegacyAuthLogger() {
            return legacyAuthLogger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

