/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.auth.module.core.rest.client.json.CoreauthmoduleJSON;
import jetbrains.jetpass.client.accounts.AuthModuleClient;
import jetbrains.jetpass.dao.api.NotUniqueFieldException;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.HubReplicatingMarker;
import jetbrains.youtrack.ring.export.adapter.HubSyncAdapter;
import jetbrains.youtrack.ring.export.dto.DisableTotpHubDtoBuilder;
import jetbrains.youtrack.ring.export.dto.DisableWebauthnHubDtoBuilder;
import jetbrains.youtrack.ring.export.dto.HubDtoBuilder;
import jetbrains.youtrack.ring.export.dto.RestoreRootUserHubDtoBuilder;
import jetbrains.youtrack.ring.impl.BeansKt;
import jetbrains.youtrack.ring.impl.HubRootRestorer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.apache.commons.lang.RandomStringUtils;

@org.springframework.stereotype.Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u000b\u001a\u00020\u0004J\b\u0010\f\u001a\u00020\u0004H\u0002J\b\u0010\r\u001a\u00020\u0004H\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/ring/impl/HubRootRestorer;", "", "()V", "disable2fa", "", "freeLicenseSlot", "gatherAllPermissions", "", "Ljetbrains/jetpass/rest/dto/PermissionJSON;", "getAuthModuleClient", "Ljetbrains/jetpass/client/accounts/AuthModuleClient;", "postRestoredRootToHub", "restoreAdminRole", "restoreCoreAuthModule", "restoreRootUser", "Companion", "youtrack-ring-integration"})
public final class HubRootRestorer {
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postRestoredRootToHub() {
        boolean suspended = HubReplicatingMarker.INSTANCE.areRingNotificationsForThreadSuspended();
        if (!suspended) {
            HubReplicatingMarker.INSTANCE.suspendRingNotificationsForThread();
        }
        try {
            this.restoreCoreAuthModule();
            this.restoreAdminRole();
            LegacySupportKt.flush();
            try {
                this.restoreRootUser();
            }
            catch (ForbiddenException e) {
                this.freeLicenseSlot();
                this.restoreRootUser();
            }
            this.disable2fa();
            jetbrains.youtrack.ring.client.BeansKt.getRingApi().syncNow();
            Companion.getLogger().info("Root user account has been reset");
        }
        finally {
            HubReplicatingMarker.INSTANCE.resumeRingNotificationsForThread();
        }
    }

    private final void restoreCoreAuthModule() {
        for (AuthmoduleJSON module : this.getAuthModuleClient().getAuthModulePage(null, null).getItems()) {
            if (!(module instanceof CoreauthmoduleJSON)) continue;
            module.setDisabled(Boolean.valueOf(false));
            AuthModuleClient authModuleClient = this.getAuthModuleClient();
            String string = module.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.getId()!!");
            authModuleClient.updateAuthModule(string, module);
        }
    }

    private final void restoreAdminRole() {
        XdRole adminRole2 = (XdRole)XdQueryKt.first((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdRole.Companion.all(), (Function2)restoreAdminRole.adminRole.1.INSTANCE));
        RoleJSON roleDto = new RoleJSON();
        roleDto.setPermissions((Iterable)this.gatherAllPermissions());
        HubSyncAdapter<XdRole> adapter2 = jetbrains.youtrack.ring.export.BeansKt.getHubAdapterFactory().getRoleAdapter();
        if (adapter2.isExported(adminRole2) && jetbrains.youtrack.ring.client.BeansKt.getRingApi().getRoleDAO().get(EntityExtensionsKt.getHubUuid((XdEntity)adminRole2)) != null) {
            jetbrains.youtrack.ring.client.BeansKt.getRingApi().getRoleDAO().update(EntityExtensionsKt.getHubUuidNotNull((XdEntity)adminRole2), (IdItem)roleDto);
        } else {
            Role created = null;
            roleDto.setName(adminRole2.getName());
            roleDto.setDescription(adminRole2.getDescription());
            try {
                created = (Role)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getRoleDAO().create((IdItem)roleDto);
            }
            catch (NotUniqueFieldException e) {
                roleDto.setName(roleDto.getName() + ' ' + RandomStringUtils.randomAlphabetic((int)5));
                created = (Role)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getRoleDAO().create((IdItem)roleDto);
            }
            EntityExtensionsKt.setHubUuid((XdEntity)adminRole2, created.getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PermissionJSON> gatherAllPermissions() {
        void $this$mapTo$iv$iv;
        PermissionJSON permissionJSON;
        Object object;
        void $this$mapTo$iv$iv2;
        IdItem idItem = jetbrains.youtrack.ring.client.BeansKt.getRingApi().getServiceDAO().get(BeansKt.getHubServiceUuid());
        if (idItem == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)idItem, (String)"ringApi.serviceDAO[hubServiceUuid]!!");
        Iterable iterable = ((Service)idItem).getPermissions();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"ringApi.serviceDAO[hubServiceUuid]!!.permissions");
        Iterable $this$map$iv = iterable;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        jetbrains.youtrack.core.security.Permission[] destination$iv$iv = (jetbrains.youtrack.core.security.Permission[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p1;
            Permission permission = (Permission)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            permissionJSON = new PermissionJSON((Permission)p1);
            object.add(permissionJSON);
        }
        List hubPermissions = (List)destination$iv$iv;
        jetbrains.youtrack.core.security.Permission[] $this$map$iv2 = jetbrains.youtrack.core.security.Permission.values();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
        boolean $i$f$mapTo2 = false;
        void var8_12 = $this$mapTo$iv$iv;
        int n = ((void)var8_12).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_19 = item$iv$iv = var8_12[i];
            object = destination$iv$iv2;
            boolean bl = false;
            PermissionJSON permission = new PermissionJSON();
            permission.setId(EntityExtensionsKt.getHubUuid((jetbrains.youtrack.core.security.Permission)it));
            permissionJSON = permission;
            object.add(permissionJSON);
        }
        List youtrackPermissions = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)hubPermissions, (Iterable)youtrackPermissions);
    }

    private final void restoreRootUser() {
        Entity entity = jetbrains.youtrack.core.security.BeansKt.getSecurity().getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"security.root");
        XdUser root = (XdUser)XdExtensionsKt.toXd((Entity)entity);
        try {
            jetbrains.youtrack.ring.export.BeansKt.getHubAdapterFactory().getUserAdapter(new RestoreRootUserHubDtoBuilder(false)).update(root);
        }
        catch (NotFoundException e) {
            jetbrains.youtrack.ring.export.BeansKt.getHubAdapterFactory().getUserAdapter(new RestoreRootUserHubDtoBuilder(true)).add(root);
        }
    }

    private final void disable2fa() {
        for (HubDtoBuilder builder : new HubDtoBuilder[]{new DisableTotpHubDtoBuilder(), new DisableWebauthnHubDtoBuilder()}) {
            try {
                HubSyncAdapter<XdUser> hubSyncAdapter = jetbrains.youtrack.ring.export.BeansKt.getHubAdapterFactory().getUserAdapter(builder);
                Entity entity = jetbrains.youtrack.core.security.BeansKt.getSecurity().getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"security.root");
                hubSyncAdapter.update((XdUser)XdExtensionsKt.toXd((Entity)entity));
            }
            catch (BadRequestException badRequestException) {
            }
            catch (Exception e) {
                Companion.getLogger().warn("Can't reset 2FA for the root user", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void freeLicenseSlot() {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = (Iterable)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserDAO().getAllItems();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            User it = (User)element$iv$iv;
            boolean bl = false;
            Boolean bl2 = it.isBanned();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"it.isBanned");
            if (bl2.booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                User it = (User)a;
                boolean bl2 = false;
                Iterable iterable = it.getGroups();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"it.groups");
                it = (User)b;
                Comparable comparable = Integer.valueOf(CollectionUtilKt.getSize((Iterable)iterable));
                bl2 = false;
                Iterable iterable2 = it.getGroups();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"it.groups");
                Integer n = CollectionUtilKt.getSize((Iterable)iterable2);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        };
        User victim = (User)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator));
        UserJSON json = new UserJSON(victim);
        json.setBanned(Boolean.valueOf(true));
        json.setBanReason("Banned to restore root administrator account");
        jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserDAO().update(json.getId(), (IdItem)json);
    }

    private final AuthModuleClient getAuthModuleClient() {
        return jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getAuthModuleClient();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/impl/HubRootRestorer$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

