/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.dao.api.authority.UserDAO;
import jetbrains.jetpass.dao.api.permissionCache.PermissionQuery;
import jetbrains.jetpass.sequence.Sequence;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.ring.RingAPI;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.persistent.UserImpl;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.ring.BeansKt;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.cache.AllProjectsCache;
import jetbrains.youtrack.ring.cache.HubUuidCache;
import jetbrains.youtrack.ring.impl.HubSecurityImpl;
import jetbrains.youtrack.security.BaseSecurity;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="ringSecurity")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 72\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001d2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0004H\u0016J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001d2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0004J(\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0004H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%2\u0006\u0010&\u001a\u00020\u0010H\u0016J\u0018\u0010'\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J \u0010'\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0010H\u0016J\u0018\u0010)\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J \u0010*\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u000fH\u0016J\u0018\u0010*\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u000fH\u0016J\u0006\u0010,\u001a\u00020-J\u0018\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fH\u0016JI\u00101\u001a\u0002H2\"\u000e\b\u0000\u00102*\b\u0012\u0004\u0012\u00020\u001003*\b\u0012\u0004\u0012\u00020\u000f0#2\u0006\u0010 \u001a\u00020\u00042\u0018\u00104\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0#\u0012\u0004\u0012\u0002H205H\u0002\u00a2\u0006\u0002\u00106R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\t8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0004*\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u000f*\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000f*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u00068"}, d2={"Ljetbrains/youtrack/ring/impl/HubSecurityImpl;", "Ljetbrains/youtrack/security/BaseSecurity;", "()V", "<set-?>", "", "initComplete", "getInitComplete", "()Z", "projectsCache", "Ljetbrains/youtrack/ring/cache/AllProjectsCache;", "remoteApi", "Ljetbrains/youtrack/api/ring/RingAPI;", "uuidCache", "Ljetbrains/youtrack/ring/cache/HubUuidCache;", "_uuid", "", "Ljetbrains/exodus/entitystore/Entity;", "get_uuid", "(Ljetbrains/exodus/entitystore/Entity;)Ljava/lang/String;", "isSystemOrService", "(Ljetbrains/exodus/entitystore/Entity;)Z", "uuid", "getUuid", "Ljetbrains/youtrack/core/security/Permission;", "(Ljetbrains/youtrack/core/security/Permission;)Ljava/lang/String;", "getGuestUuid", "getImplementationName", "localize", "getProjects", "", "user", "permission", "includeArchived", "userRingId", "getProjectsUnordered", "", "getProjectsWithRoles", "", "group", "hasPermission", "project", "hasPermissionInGlobalProject", "hasRole", "roleName", "init", "", "restoreRoot", "login", "password", "mapToYouTrackProjects", "T", "", "resultFactory", "Lkotlin/Function1;", "(Ljava/util/Collection;ZLkotlin/jvm/functions/Function1;)Ljava/util/Collection;", "Companion", "youtrack-ring-integration"})
public final class HubSecurityImpl
extends BaseSecurity {
    @Autowired
    private AllProjectsCache projectsCache;
    @Autowired
    private HubUuidCache uuidCache;
    private volatile RingAPI remoteApi;
    private volatile boolean initComplete;
    public static final Companion Companion = new Companion(null);

    public final boolean getInitComplete() {
        return this.initComplete;
    }

    public final void init() {
        HubUuidCache hubUuidCache = this.uuidCache;
        if (hubUuidCache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uuidCache");
        }
        hubUuidCache.recalculate();
        this.remoteApi = jetbrains.youtrack.ring.client.BeansKt.getRingApi();
        this.initComplete = true;
    }

    @NotNull
    public List<Entity> getProjects(@NotNull Entity user2, @NotNull Permission permission, boolean includeArchived) {
        List<Entity> list;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (this.isSystemOrService(user2)) {
            AllProjectsCache allProjectsCache = this.projectsCache;
            if (allProjectsCache == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectsCache");
            }
            list = allProjectsCache.getAllProjectsSorted(includeArchived);
        } else {
            list = this.getProjects(this.getUuid(user2), permission, includeArchived);
        }
        return list;
    }

    @NotNull
    public final List<Entity> getProjects(@NotNull String userRingId, @NotNull Permission permission, boolean includeArchived) {
        Intrinsics.checkParameterIsNotNull((Object)userRingId, (String)"userRingId");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        RingAPI ringAPI = this.remoteApi;
        if (ringAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
        }
        PermissionQuery permissionQuery = ringAPI.getPermissionCache().user(userRingId);
        String string = this.getUuid(permission);
        if (string == null) {
            string = "";
        }
        return (List)this.mapToYouTrackProjects(permissionQuery.withPermission(string).getAccessibleProjects(), includeArchived, getProjects.1.INSTANCE);
    }

    @NotNull
    public Collection<Entity> getProjectsUnordered(@Nullable Entity user2, @NotNull Permission permission, boolean includeArchived) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (this.isSystemOrService(user2)) {
            AllProjectsCache allProjectsCache = this.projectsCache;
            if (allProjectsCache == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectsCache");
            }
            return allProjectsCache.getAllProjectsSorted(includeArchived);
        }
        try {
            RingAPI ringAPI = this.remoteApi;
            if (ringAPI == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
            }
            PermissionQuery permissionQuery = ringAPI.getPermissionCache().user(this.getUuid(user2));
            String string = this.getUuid(permission);
            if (string == null) {
                string = "";
            }
            return this.mapToYouTrackProjects(permissionQuery.withPermission(string).getAccessibleProjectsUnordered(), includeArchived, getProjectsUnordered.1.INSTANCE);
        }
        catch (IllegalStateException e) {
            Entity entity;
            Companion.getLogger().warn("Failed to fetch accessible projects for user " + ((entity = user2) != null && (entity = (XdUser)XdExtensionsKt.toXd((Entity)entity)) != null ? entity.getLogin() : null), (Throwable)e);
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public Set<Entity> getProjectsWithRoles(@NotNull Entity group2) {
        Intrinsics.checkParameterIsNotNull((Object)group2, (String)"group");
        XdUserGroup xdGroup = (XdUserGroup)XdUserGroup.Companion.wrap(group2);
        String uuid2 = EntityExtensionsKt.getHubUuid((XdEntity)xdGroup);
        if (uuid2 != null) {
            try {
                if (EntityExtensionsKt.isTeam(xdGroup)) {
                    HubUuidCache hubUuidCache = jetbrains.youtrack.ring.sync.BeansKt.getHubUuidCache();
                    String string = EntityExtensionsKt.getTeamHubProjectUuid(xdGroup);
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    CollectionsKt.toSet((Iterable)hubUuidCache.getProjects(string));
                } else {
                    RingAPI ringAPI = this.remoteApi;
                    if (ringAPI == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
                    }
                    this.mapToYouTrackProjects(ringAPI.getPermissionCache().group(uuid2).getAccessibleProjectsUnordered(), false, getProjectsWithRoles.1.INSTANCE);
                }
            }
            catch (IllegalStateException e) {
                Companion.getLogger().error("User group " + xdGroup.getName() + " with id " + uuid2 + " does not make sense in Hub, no relevant group icon will be shown");
            }
        }
        boolean bl = false;
        return SetsKt.emptySet();
    }

    private final <T extends Collection<Entity>> T mapToYouTrackProjects(@NotNull Collection<String> $this$mapToYouTrackProjects, boolean includeArchived, Function1<? super Collection<String>, ? extends T> resultFactory) {
        Collection result2 = (Collection)resultFactory.invoke($this$mapToYouTrackProjects);
        if ($this$mapToYouTrackProjects.contains(jetbrains.youtrack.ring.impl.BeansKt.getHubGlobalProjectUuid())) {
            AllProjectsCache allProjectsCache = this.projectsCache;
            if (allProjectsCache == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectsCache");
            }
            result2.addAll((Collection)allProjectsCache.getAllProjectsSorted(includeArchived));
        } else if (includeArchived) {
            Iterable $this$forEach$iv = $this$mapToYouTrackProjects;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String uuid2 = (String)element$iv;
                boolean bl = false;
                HubUuidCache hubUuidCache = this.uuidCache;
                if (hubUuidCache == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uuidCache");
                }
                result2.addAll((Collection)hubUuidCache.getProjects(uuid2));
            }
        } else {
            Iterable $this$forEach$iv = $this$mapToYouTrackProjects;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String uuid3 = (String)element$iv;
                boolean bl = false;
                HubUuidCache hubUuidCache = this.uuidCache;
                if (hubUuidCache == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uuidCache");
                }
                Iterable $this$forEach$iv2 = hubUuidCache.getProjects(uuid3);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Entity entity = (Entity)element$iv2;
                    boolean bl2 = false;
                    AllProjectsCache allProjectsCache = this.projectsCache;
                    if (allProjectsCache == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"projectsCache");
                    }
                    if (allProjectsCache.getArchived().contains(entity)) continue;
                    result2.add(entity);
                }
            }
        }
        return (T)result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasPermission(@NotNull Entity user2, @NotNull Permission permission) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (this.isSystemOrService(user2)) return true;
        RingAPI ringAPI = this.remoteApi;
        if (ringAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
        }
        PermissionQuery permissionQuery = ringAPI.getPermissionCache().user(this.getUuid(user2));
        String string = this.getUuid(permission);
        if (string == null) {
            string = "";
        }
        if (!permissionQuery.withPermission(string).canAccess()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasPermissionInGlobalProject(@NotNull Entity user2, @NotNull Permission permission) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (this.isSystemOrService(user2)) return true;
        RingAPI ringAPI = this.remoteApi;
        if (ringAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
        }
        PermissionQuery permissionQuery = ringAPI.getPermissionCache().user(this.getUuid(user2));
        String string = this.getUuid(permission);
        if (string == null) {
            string = "";
        }
        if (!permissionQuery.withPermission(string).canAccessGlobal()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasPermission(@NotNull Entity user2, @NotNull Permission permission, @NotNull Entity project) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (this.isSystemOrService(user2)) return true;
        AllProjectsCache allProjectsCache = this.projectsCache;
        if (allProjectsCache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectsCache");
        }
        if (allProjectsCache.getArchived().contains(project)) return false;
        RingAPI ringAPI = this.remoteApi;
        if (ringAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
        }
        PermissionQuery permissionQuery = ringAPI.getPermissionCache().user(this.getUuid(user2));
        String string2 = this.getUuid(permission);
        if (string2 == null) {
            string2 = "";
        }
        PermissionQuery permissionQuery2 = permissionQuery.withPermission(string2);
        HubUuidCache hubUuidCache = this.uuidCache;
        if (hubUuidCache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uuidCache");
        }
        if ((string = hubUuidCache.getProjectId(project)) == null) {
            string = "";
        }
        if (!permissionQuery2.toProject(string).canAccess()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasRole(@NotNull Entity user2, @NotNull String roleName) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)roleName, (String)"roleName");
        if (this.isSystemOrService(user2)) {
            return true;
        }
        RingAPI ringAPI = this.remoteApi;
        if (ringAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
        }
        Sequence sequence = ringAPI.getRoleDAO().getByName(roleName);
        Sequence sequence2 = sequence;
        if (sequence == null) return false;
        Role role = (Role)sequence2.first();
        sequence2 = role;
        if (role == null) return false;
        String string = sequence2.getId();
        String id2 = string;
        if (id2 == null) return false;
        RingAPI ringAPI2 = this.remoteApi;
        if (ringAPI2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
        }
        if (!ringAPI2.getPermissionCache().user(this.getUuid(user2)).withRole(id2).canAccess()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasRole(@NotNull Entity user2, @NotNull Entity project, @NotNull String roleName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)roleName, (String)"roleName");
        if (this.isSystemOrService(user2)) {
            return true;
        }
        RingAPI ringAPI = this.remoteApi;
        if (ringAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
        }
        Sequence sequence = ringAPI.getRoleDAO().getByName(roleName);
        Sequence sequence2 = sequence;
        if (sequence == null) return false;
        Role role = (Role)sequence2.first();
        sequence2 = role;
        if (role == null) return false;
        String string2 = sequence2.getId();
        String id2 = string2;
        if (id2 == null) return false;
        RingAPI ringAPI2 = this.remoteApi;
        if (ringAPI2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
        }
        PermissionQuery permissionQuery = ringAPI2.getPermissionCache().user(this.getUuid(user2), false).withRole(id2);
        HubUuidCache hubUuidCache = this.uuidCache;
        if (hubUuidCache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uuidCache");
        }
        if ((string = hubUuidCache.getProjectId(project)) == null) {
            string = "";
        }
        if (!permissionQuery.toProject(string).canAccess()) return false;
        return true;
    }

    public void restoreRoot(@NotNull String login, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        try {
            BeansKt.getRingAuditLog().withActivity("Root restore", (Function0<Unit>)((Function0)new Function0<Unit>(this, login, password){
                final /* synthetic */ HubSecurityImpl this$0;
                final /* synthetic */ String $login;
                final /* synthetic */ String $password;

                public final void invoke() {
                    HubSecurityImpl.access$restoreRoot$s137266933(this.this$0, this.$login, this.$password);
                    jetbrains.youtrack.ring.impl.BeansKt.getHubRootRestorer().postRestoredRootToHub();
                }
                {
                    this.this$0 = hubSecurityImpl;
                    this.$login = string;
                    this.$password = string2;
                    super(0);
                }
            }));
        }
        catch (Exception e) {
            Companion.getLogger().warn("Unable to restore root password", (Throwable)e);
        }
    }

    private final String getUuid(@NotNull Permission $this$uuid) {
        HubUuidCache hubUuidCache = this.uuidCache;
        if (hubUuidCache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uuidCache");
        }
        return hubUuidCache.getPermissionId($this$uuid);
    }

    private final String getUuid(@Nullable Entity $this$uuid) {
        if ($this$uuid == null) {
            return this.getGuestUuid();
        }
        return this.get_uuid($this$uuid);
    }

    private final String get_uuid(@NotNull Entity $this$_uuid) {
        String string = EntityExtensionsKt.getHubUuid($this$_uuid);
        if (string == null) {
            String string2 = this.getGuestUuid();
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Companion.getLogger().error("User " + ((XdUser)XdUser.Companion.wrap($this$_uuid)).getLogin() + " is not associated with Hub, using guest permissions");
            return string2;
        }
        String uuid2 = string;
        RingAPI ringAPI = this.remoteApi;
        if (ringAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
        }
        if (ringAPI.getUserDAO().get(uuid2) == null) {
            Companion.getLogger().error("User uuid " + uuid2 + " for user " + ((XdUser)XdUser.Companion.wrap($this$_uuid)).getLogin() + " does not make sense in Hub, using guest permissions");
            return this.getGuestUuid();
        }
        return uuid2;
    }

    private final String getGuestUuid() {
        Entity entity = jetbrains.youtrack.core.security.BeansKt.getSecurity().getGuest();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"security.guest");
        String string = EntityExtensionsKt.getHubUuid(entity);
        if (string == null) {
            RingAPI ringAPI = this.remoteApi;
            if (ringAPI == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remoteApi");
            }
            UserDAO userDAO = ringAPI.getUserDAO();
            Intrinsics.checkExpressionValueIsNotNull((Object)userDAO, (String)"remoteApi.userDAO");
            User user2 = userDAO.getGuest();
            Intrinsics.checkExpressionValueIsNotNull((Object)user2, (String)"remoteApi.userDAO.guest");
            String string2 = user2.getId();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"remoteApi.userDAO.guest.id");
        }
        return string;
    }

    private final boolean isSystemOrService(@Nullable Entity $this$isSystemOrService) {
        BasePersistentClassImpl basePersistentClassImpl = DnqUtils.getPersistentClassInstance((Entity)$this$isSystemOrService, (String)"User");
        if (basePersistentClassImpl == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.core.persistent.UserImpl");
        }
        UserImpl userImpl = (UserImpl)basePersistentClassImpl;
        return userImpl.isSystem($this$isSystemOrService) || userImpl.isService($this$isSystemOrService);
    }

    @NotNull
    public String getImplementationName(boolean localize) {
        String string = localize ? jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("HubSecurityImpl.Hub_permission_management", new Object[0]) : "Hub permission management";
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (localize) localizer.\u2026ub permission management\"");
        return string;
    }

    public static final /* synthetic */ void access$restoreRoot$s137266933(HubSecurityImpl $this, String login, String password) {
        super.restoreRoot(login, password);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/impl/HubSecurityImpl$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

