/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.api.ring.HubUuidResolver;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.sync.RingGroup;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="hubUuidResolver")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/ring/impl/HubUuidResolverImpl;", "Ljetbrains/youtrack/api/ring/HubUuidResolver;", "()V", "findUsersByVcsUsername", "", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "name", "", "resolveGroup", "Ljetbrains/youtrack/core/persistent/user/XdUserGroup;", "hubUuid", "resolveProjectByResourceUuid", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "hubResourceUuid", "resolveProjectByUuidOnly", "uuid", "resolveRole", "Ljetbrains/exodus/entitystore/Entity;", "resolveUser", "resolveUserByAuthHeader", "header", "resolveUserByUuidOnly", "resolveUserGroupByUuidOnly", "Companion", "youtrack-ring-integration"})
public final class HubUuidResolverImpl
implements HubUuidResolver {
    public static final Companion Companion = new Companion(null);

    @Nullable
    public XdProject resolveProjectByResourceUuid(@NotNull String hubResourceUuid) {
        Resource hubResource2;
        Intrinsics.checkParameterIsNotNull((Object)hubResourceUuid, (String)"hubResourceUuid");
        XdProject project = this.resolveProjectByUuidOnly(hubResourceUuid);
        if (BeansKt.getRingConfig().isEnabled() && project == null && (hubResource2 = (Resource)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getResourceDAO().get(hubResourceUuid)) != null) {
            Iterator iterator2 = hubResource2.getAliases().iterator();
            while (iterator2.hasNext()) {
                Alias alias;
                Alias alias2 = alias = (Alias)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)alias2, (String)"alias");
                String string = alias2.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"alias.id");
                XdProject locatedByAlias = this.resolveProjectByUuidOnly(string);
                if (locatedByAlias == null) continue;
                project = locatedByAlias;
            }
        }
        return project;
    }

    private final XdProject resolveProjectByUuidOnly(String uuid2) {
        return (XdProject)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdProject.Companion), (NodeBase)((NodeBase)new PropertyEqual("$$hubId$$", (Comparable)((Object)uuid2)))));
    }

    @Nullable
    public XdUser resolveUserByAuthHeader(@Nullable String header) {
        return (XdUser)LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, XdUser>(header){
            final /* synthetic */ String $header;

            @Nullable
            public final XdUser invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return jetbrains.youtrack.ring.sync.BeansKt.getHubUserResolver().resolveByAuthHeader(this.$header);
            }
            {
                this.$header = string;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<XdUser> findUsersByVcsUsername(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (BeansKt.getRingConfig().isEnabled()) {
            try {
                void $this$mapNotNullTo$iv$iv;
                Filter filter = new Filter(null, 1, null);
                filter.query("vcsUserName: {" + name + '}');
                Iterable $this$mapNotNull$iv = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getUserClient().getUserPage((BaseFilter)filter, null).getUsers();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    XdUser xdUser;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    UserJSON it = (UserJSON)element$iv$iv;
                    boolean bl2 = false;
                    String string = it.getId();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    if (this.resolveUser(string) == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    XdUser it$iv$iv = xdUser;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            catch (Exception e) {
                Companion.getLogger().warn("Failed to resolve Hub user by VCS user name " + name, (Throwable)e);
            }
        }
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    @Nullable
    public XdUser resolveUser(@Nullable String hubUuid) {
        if (hubUuid == null) {
            return null;
        }
        XdUser user2 = this.resolveUserByUuidOnly(hubUuid);
        if (BeansKt.getRingConfig().isEnabled()) {
            User hubUser;
            if (user2 == null && (hubUser = (User)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserDAO().get(hubUuid)) != null) {
                Iterator iterator2 = hubUser.getAliases().iterator();
                while (iterator2.hasNext()) {
                    Alias alias;
                    Alias alias2 = alias = (Alias)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)alias2, (String)"alias");
                    String string = alias2.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"alias.id");
                    XdUser localUserByAlias = this.resolveUserByUuidOnly(string);
                    if (localUserByAlias == null) continue;
                    user2 = localUserByAlias;
                }
            }
            if (user2 == null) {
                user2 = jetbrains.youtrack.ring.sync.BeansKt.getHubUserResolver().resolve(hubUuid);
            }
        }
        return user2;
    }

    @Nullable
    public XdUserGroup resolveGroup(@NotNull String hubUuid) {
        Intrinsics.checkParameterIsNotNull((Object)hubUuid, (String)"hubUuid");
        XdUserGroup group2 = this.resolveUserGroupByUuidOnly(hubUuid);
        if (BeansKt.getRingConfig().isEnabled()) {
            UserGroup hubGroup;
            if (group2 == null && (hubGroup = (UserGroup)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserGroupDAO().get(hubUuid)) != null) {
                Iterator iterator2 = hubGroup.getAliases().iterator();
                while (iterator2.hasNext()) {
                    Alias alias;
                    Alias alias2 = alias = (Alias)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)alias2, (String)"alias");
                    String string = alias2.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"alias.id");
                    XdUserGroup localUserByAlias = this.resolveUserGroupByUuidOnly(string);
                    if (localUserByAlias == null) continue;
                    group2 = localUserByAlias;
                }
            }
            if (group2 == null) {
                group2 = new RingGroup(hubUuid).resolve();
            }
        }
        return group2;
    }

    @NotNull
    public Entity resolveRole(@NotNull String hubUuid) {
        Object element$iv2;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)hubUuid, (String)"hubUuid");
            Iterable $this$first$iv = XdQueryKt.asIterable((XdQuery)XdRole.Companion.all());
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                XdRole it = (XdRole)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)hubUuid, (Object)EntityExtensionsKt.getHubUuid((XdEntity)it))) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((XdRole)element$iv2).getEntity();
    }

    private final XdUserGroup resolveUserGroupByUuidOnly(String uuid2) {
        return (XdUserGroup)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdUserGroup.Companion), (NodeBase)((NodeBase)new PropertyEqual("$$hubId$$", (Comparable)((Object)uuid2)))));
    }

    @Nullable
    public final XdUser resolveUserByUuidOnly(@NotNull String uuid2) {
        Intrinsics.checkParameterIsNotNull((Object)uuid2, (String)"uuid");
        return (XdUser)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdUser.Companion), (NodeBase)((NodeBase)new PropertyEqual("$$hubId$$", (Comparable)((Object)uuid2)))));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/impl/HubUuidResolverImpl$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

