/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.main.SingleElementApplicationStateListener;
import jetbrains.charisma.persistent.ReadOnlyKt;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.youtrack.api.application.ApplicationState;
import jetbrains.youtrack.api.ring.RingConfig;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.ring.BeansKt;
import jetbrains.youtrack.ring.client.ConnectionTestResult;
import jetbrains.youtrack.ring.client.RemoteApiAsyncInitJob;
import jetbrains.youtrack.ring.impl.RingConfigImpl;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="ringConfig")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\"\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/ring/impl/RingConfigImpl;", "Ljetbrains/youtrack/api/ring/RingConfig;", "Ljetbrains/charisma/main/SingleElementApplicationStateListener;", "()V", "embeddedHubDisabled", "", "hasEmbeddedHub", "changed", "", "getYouTrackServiceId", "", "getYoutrackMobileServiceId", "getYoutrackMobileServiceSecret", "initHubIntegration", "isBroken", "isEnabled", "isReadOnly", "logHubWakeUpAttempt", "result", "Ljetbrains/youtrack/ring/client/ConnectionTestResult;", "attempt", "", "hubWakeUpAttemptsMax", "wakeUpHub", "Companion", "youtrack-ring-integration"})
public final class RingConfigImpl
extends SingleElementApplicationStateListener
implements RingConfig {
    private final boolean hasEmbeddedHub = Intrinsics.areEqual((Object)"true", (Object)ConfigurationParameter.getParameter((String)"jetbrains.youtrack.hasEmbeddedHub"));
    private final boolean embeddedHubDisabled = Boolean.getBoolean("jetbrains.youtrack.disableBundledHub");
    private static final int HUB_WAKEUP_ATTEMPTS = 3;
    private static final int HOSTED_HUB_WAKEUP_ATTEMPTS_ON_NOT_FOUND = 15;
    public static final Companion Companion = new Companion(null);

    public boolean isEnabled() {
        return Intrinsics.areEqual((Object)jetbrains.youtrack.ring.client.BeansKt.getHubClientFactory().getLastConnectionTestResult(), (Object)ConnectionTestResult.Companion.getOK());
    }

    public boolean isBroken() {
        return jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getEnabled() && !this.isEnabled();
    }

    public boolean isReadOnly() {
        return jetbrains.youtrack.ring.maintenance.BeansKt.getHubReadOnlyManager().isReadOnly();
    }

    public boolean hasEmbeddedHub() {
        return this.hasEmbeddedHub && !this.embeddedHubDisabled;
    }

    @Nullable
    public String getYouTrackServiceId() {
        return jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId();
    }

    @NotNull
    public String getYoutrackMobileServiceSecret() {
        return jetbrains.youtrack.ring.sync.BeansKt.getYoutrackMobileService().getSecret();
    }

    @NotNull
    public String getYoutrackMobileServiceId() {
        return jetbrains.youtrack.ring.sync.BeansKt.getYoutrackMobileService().getUuid();
    }

    public void changed() {
        if (!ReadOnlyKt.isReadonly()) {
            LegacySupportKt.transactional((Function1)changed.1.INSTANCE);
        }
        if (((Boolean)LegacySupportKt.transactional((Function1)changed.2.INSTANCE)).booleanValue()) {
            jetbrains.youtrack.ring.rest.BeansKt.getHubIntegrationJobRunner().submitJob(new RemoteApiAsyncInitJob());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initHubIntegration() {
        if (((Boolean)LegacySupportKt.transactional((Function1)initHubIntegration.1.INSTANCE)).booleanValue()) {
            void runRefactorings;
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = true;
            Companion.getLogger().info("Hub integration is enabled");
            this.wakeUpHub();
            try {
                void result2;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = ConnectionTestResult.Companion.getNOT_YET_DEFINED();
                LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>((Ref.ObjectRef)result2, (Ref.BooleanRef)runRefactorings){
                    final /* synthetic */ Ref.ObjectRef $result;
                    final /* synthetic */ Ref.BooleanRef $runRefactorings;

                    public final void invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$result.element = jetbrains.youtrack.ring.client.BeansKt.getHubClientFactory().testConnection();
                        if (Intrinsics.areEqual((Object)((ConnectionTestResult)this.$result.element), (Object)ConnectionTestResult.Companion.getSERVICE_NOT_REGISTERED()) && jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId() != null && jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getSecret() != null) {
                            RingConfigImpl.Companion.getLogger().info("New YouTrack service will be registered in Hub");
                            BeansKt.getRingAuditLog().withActivity("Service registration", (Function0<Unit>)((Function0)initHubIntegration.1.INSTANCE));
                            this.$runRefactorings.element = false;
                            this.$result.element = jetbrains.youtrack.ring.client.BeansKt.getHubClientFactory().testConnection();
                        }
                    }
                    {
                        this.$result = objectRef;
                        this.$runRefactorings = booleanRef;
                        super(1);
                    }
                }));
                if (((ConnectionTestResult)result2.element).isSuccessful()) {
                    Companion.getLogger().info("Tested connection to Hub: " + ((ConnectionTestResult)result2.element).getMessage(false));
                    BeansKt.getRingAuditLog().withActivity("Startup export", (Function0<Unit>)((Function0)initHubIntegration.3.INSTANCE));
                    LegacySupportKt.transactional((Function1)initHubIntegration.4.INSTANCE);
                } else {
                    Companion.getLogger().error("Hub integration init failed: " + ((ConnectionTestResult)result2.element).getMessage(false));
                }
            }
            catch (Exception e) {
                Companion.getLogger().error("Can't initialize Hub integration", (Throwable)e);
            }
            boolean bl = runRefactorings.element = runRefactorings.element && jetbrains.youtrack.ring.client.BeansKt.getHubClientFactory().testConnection().isSuccessful() && !ReadOnlyKt.isReadonly();
            if (runRefactorings.element) {
                BeansKt.getRingAuditLog().withActivity("Hub refactorings", (Function0<Unit>)((Function0)initHubIntegration.5.INSTANCE));
            }
        }
        jetbrains.youtrack.ring.listeners.BeansKt.getDbListenersInstaller().installEntityListeners();
    }

    /*
     * WARNING - void declaration
     */
    private final void wakeUpHub() {
        int hubWakeUpAttemptsMax;
        int attempt = 0;
        int n = hubWakeUpAttemptsMax = ConfigurationUtil.isYoutrackHosted() ? 15 : 3;
        while (attempt < hubWakeUpAttemptsMax) {
            void result2;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            try {
                LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>((Ref.ObjectRef)result2){
                    final /* synthetic */ Ref.ObjectRef $result;

                    public final void invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$result.element = jetbrains.youtrack.ring.client.BeansKt.getHubClientFactory().testConnection();
                    }
                    {
                        this.$result = objectRef;
                        super(1);
                    }
                }));
                this.logHubWakeUpAttempt((ConnectionTestResult)result2.element, ++attempt, hubWakeUpAttemptsMax);
                if ((ConnectionTestResult)result2.element == ConnectionTestResult.Companion.getCANT_CONNECT() || (ConnectionTestResult)result2.element == ConnectionTestResult.Companion.getTIMEOUT()) {
                    Thread.sleep(10000L);
                    continue;
                }
                if ((ConnectionTestResult)result2.element == ConnectionTestResult.Companion.getWRONG_URL()) {
                    Thread.sleep(2000L);
                    continue;
                }
                return;
            }
            catch (Exception e) {
                this.logHubWakeUpAttempt((ConnectionTestResult)result2.element, ++attempt, hubWakeUpAttemptsMax);
                Companion.getLogger().warn("Exception during waking up hub", (Throwable)e);
                Thread.sleep(10000L);
            }
        }
    }

    private final void logHubWakeUpAttempt(ConnectionTestResult result2, int attempt, int hubWakeUpAttemptsMax) {
        String domain = ConfigurationParameter.getParameter((String)"domain");
        StringBuilder builder = new StringBuilder("Establishing connection to Hub");
        if (domain != null) {
            builder.append(", domain - ").append(domain);
        }
        builder.append(". Attempt ").append(attempt).append(" of ").append(hubWakeUpAttemptsMax);
        ConnectionTestResult connectionTestResult = result2;
        builder.append(". Result: ").append(connectionTestResult != null ? connectionTestResult.getMessage(false) : null);
        Companion.getLogger().info(builder.toString());
    }

    public RingConfigImpl() {
        super(ApplicationState.SPRING_INITIALIZED);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/ring/impl/RingConfigImpl$Companion;", "Lmu/KLogging;", "()V", "HOSTED_HUB_WAKEUP_ATTEMPTS_ON_NOT_FOUND", "", "HUB_WAKEUP_ATTEMPTS", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

