/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import java.net.URL;
import java.util.Calendar;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.security.Organization;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.youtrack.api.ring.RingDataStore;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.persistent.XdOrganization;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component(value="ringDataStore")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/ring/impl/RingDataStoreImpl;", "Ljetbrains/youtrack/api/ring/RingDataStore;", "()V", "findHubProject", "Ljetbrains/jetpass/api/security/Project;", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "getGroupRingId", "", "userGroup", "Ljetbrains/youtrack/core/persistent/user/XdUserGroup;", "getOrganizationRingId", "organization", "Ljetbrains/youtrack/core/persistent/XdOrganization;", "getPermissionRingId", "permission", "Ljetbrains/youtrack/core/security/Permission;", "getProject", "ringId", "getProjectDefaultIconUrl", "getProjectIconUrl", "getProjectResourceId", "getProjectRingId", "getUserRingId", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "Companion", "ProjectDecorator", "youtrack-ring-integration"})
public final class RingDataStoreImpl
implements RingDataStore {
    public static final Companion Companion = new Companion(null);

    @Nullable
    public String getPermissionRingId(@NotNull Permission permission) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        return EntityExtensionsKt.getHubUuid(permission);
    }

    @Nullable
    public String getUserRingId(@NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return EntityExtensionsKt.getHubUuid((XdEntity)user2);
    }

    @Nullable
    public String getGroupRingId(@NotNull XdUserGroup userGroup) {
        Intrinsics.checkParameterIsNotNull((Object)userGroup, (String)"userGroup");
        return EntityExtensionsKt.getHubUuid((XdEntity)userGroup);
    }

    @Nullable
    public XdProject getProject(@NotNull String ringId2) {
        Intrinsics.checkParameterIsNotNull((Object)ringId2, (String)"ringId");
        return (XdProject)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.asQuery((Iterable)jetbrains.youtrack.ring.sync.BeansKt.getHubUuidCache().getProjects(ringId2), (XdEntityType)((XdEntityType)XdProject.Companion)));
    }

    @Nullable
    public String getProjectRingId(@NotNull XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object object = this.findHubProject(project);
        if (object == null || (object = object.getId()) == null) {
            object = (String)((Function0)new Function0(project){
                final /* synthetic */ XdProject $project;

                @Nullable
                public final Void invoke() {
                    RingDataStoreImpl.Companion.getLogger().warn("No valid Hub id found for project " + this.$project.getName());
                    return null;
                }
                {
                    this.$project = xdProject;
                    super(0);
                }
            }).invoke();
        }
        return object;
    }

    @Nullable
    public String getProjectResourceId(@NotNull XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return EntityExtensionsKt.getHubUuid((XdEntity)project);
    }

    @Nullable
    public String getProjectIconUrl(@NotNull XdProject project) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        try {
            Project project2 = this.findHubProject(project);
            string = project2 != null ? project2.getIconUrl() : null;
        }
        catch (Exception e) {
            Companion.getLogger().warn("Failed to load icon for project " + project.getName());
            string = null;
        }
        return string;
    }

    @Nullable
    public String getProjectDefaultIconUrl(@NotNull XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return "";
    }

    @Nullable
    public String getOrganizationRingId(@NotNull XdOrganization organization) {
        Intrinsics.checkParameterIsNotNull((Object)organization, (String)"organization");
        return EntityExtensionsKt.getHubUuid((XdEntity)organization);
    }

    private final Project findHubProject(XdProject project) {
        String resourceId = this.getProjectResourceId(project);
        if (resourceId != null) {
            Project project2;
            Project hubProject;
            Resource resource = (Resource)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getResourceDAO().get(resourceId);
            Object object = hubProject = resource != null ? resource.getProject() : null;
            if (BeansKt.getRingConfig().hasEmbeddedHub()) {
                ProjectDecorator projectDecorator;
                Project project3 = hubProject;
                if (project3 != null) {
                    Project project4 = project3;
                    boolean bl = false;
                    boolean bl2 = false;
                    Project it = project4;
                    boolean bl3 = false;
                    projectDecorator = new ProjectDecorator(it);
                } else {
                    projectDecorator = null;
                }
                project2 = projectDecorator;
            } else {
                project2 = hubProject;
            }
            return project2;
        }
        return null;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J-\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\n0\u0007H\u0096\u0001J\u0011\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\f0\fH\u0096\u0001J\u0011\u0010\r\u001a\n \t*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J\u0011\u0010\u000f\u001a\n \t*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J\u0011\u0010\u0010\u001a\n \t*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0011\u0010\u0012\u001a\n \t*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J\u0011\u0010\u0013\u001a\n \t*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J\u0011\u0010\u0014\u001a\n \t*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J\u0011\u0010\u0015\u001a\n \t*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J\u0011\u0010\u0017\u001a\n \t*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J-\u0010\u0019\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u001a0\u001a \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u001a0\u001a\u0018\u00010\n0\u0007H\u0096\u0001J-\u0010\u001b\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u001c0\u001c \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u001c0\u001c\u0018\u00010\n0\u0007H\u0096\u0001J\u0011\u0010\u001d\u001a\n \t*\u0004\u0018\u00010\u001e0\u001eH\u0096\u0001J-\u0010\u001f\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u001a0\u001a \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u001a0\u001a\u0018\u00010\n0\u0007H\u0096\u0001J\u0016\u0010 \u001a\n \t*\u0004\u0018\u00010!0!H\u0096\u0001\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\n \t*\u0004\u0018\u00010!0!H\u0096\u0001\u00a2\u0006\u0002\u0010\"J\u0016\u0010$\u001a\n \t*\u0004\u0018\u00010!0!H\u0096\u0001\u00a2\u0006\u0002\u0010\"J\u0016\u0010%\u001a\n \t*\u0004\u0018\u00010!0!H\u0096\u0001\u00a2\u0006\u0002\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006&"}, d2={"Ljetbrains/youtrack/ring/impl/RingDataStoreImpl$ProjectDecorator;", "Ljetbrains/jetpass/api/security/Project;", "project", "(Ljetbrains/youtrack/ring/impl/RingDataStoreImpl;Ljetbrains/jetpass/api/security/Project;)V", "getProject", "()Ljetbrains/jetpass/api/security/Project;", "getAliases", "", "Ljetbrains/jetpass/api/Alias;", "kotlin.jvm.PlatformType", "", "getCreationTime", "Ljava/util/Calendar;", "getDashboard", "", "getDescription", "getIcon", "getIconUrl", "getId", "getKey", "getName", "getOrganization", "Ljetbrains/jetpass/api/security/Organization;", "getOwner", "Ljetbrains/jetpass/api/authority/User;", "getProjectRoles", "Ljetbrains/jetpass/api/security/ProjectRole;", "getResources", "Ljetbrains/jetpass/api/security/Resource;", "getTeam", "Ljetbrains/jetpass/api/authority/ProjectTeam;", "getTransitiveProjectRoles", "isArchived", "", "()Ljava/lang/Boolean;", "isDefaultIcon", "isGlobal", "isMyFavorite", "youtrack-ring-integration"})
    private final class ProjectDecorator
    implements Project {
        @NotNull
        private final Project project;

        @NotNull
        public String getIconUrl() {
            URL url = new URL(this.project.getIconUrl());
            return url.getPath() + '?' + url.getQuery();
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public ProjectDecorator(Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.project = project;
        }

        public Iterable<Alias> getAliases() {
            return this.project.getAliases();
        }

        public Calendar getCreationTime() {
            return this.project.getCreationTime();
        }

        public String getDashboard() {
            return this.project.getDashboard();
        }

        public String getDescription() {
            return this.project.getDescription();
        }

        public String getIcon() {
            return this.project.getIcon();
        }

        public String getId() {
            return this.project.getId();
        }

        public String getKey() {
            return this.project.getKey();
        }

        public String getName() {
            return this.project.getName();
        }

        public Organization getOrganization() {
            return this.project.getOrganization();
        }

        public User getOwner() {
            return this.project.getOwner();
        }

        public Iterable<ProjectRole> getProjectRoles() {
            return this.project.getProjectRoles();
        }

        public Iterable<Resource> getResources() {
            return this.project.getResources();
        }

        public ProjectTeam getTeam() {
            return this.project.getTeam();
        }

        public Iterable<ProjectRole> getTransitiveProjectRoles() {
            return this.project.getTransitiveProjectRoles();
        }

        public Boolean isArchived() {
            return this.project.isArchived();
        }

        public Boolean isDefaultIcon() {
            return this.project.isDefaultIcon();
        }

        public Boolean isGlobal() {
            return this.project.isGlobal();
        }

        public Boolean isMyFavorite() {
            return this.project.isMyFavorite();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/impl/RingDataStoreImpl$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

