/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.impl;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.auth.module.core.rest.client.json.CoreuserdetailsJSON;
import jetbrains.jetpass.dao.remote.api.authority.RemoteProjectTeamDAO;
import jetbrains.jetpass.rest.dto.ProfileJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.api.ring.RingImporter;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.export.adapter.HubSyncAdapter;
import jetbrains.youtrack.ring.export.dto.ExportGroupHubDtoBuilder;
import jetbrains.youtrack.ring.export.dto.ExportUserHubDtoBuilder;
import jetbrains.youtrack.ring.impl.BeansKt;
import jetbrains.youtrack.ring.impl.RingImporterImpl;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component(value="ringImporter")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t*\u0001\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/ring/impl/RingImporterImpl;", "Ljetbrains/youtrack/api/ring/RingImporter;", "()V", "groupBuilder", "Ljetbrains/youtrack/ring/export/dto/ExportGroupHubDtoBuilder;", "userBuilder", "jetbrains/youtrack/ring/impl/RingImporterImpl$userBuilder$1", "Ljetbrains/youtrack/ring/impl/RingImporterImpl$userBuilder$1;", "addToHubXd", "T", "Lkotlinx/dnq/XdEntity;", "entity", "name", "", "adapter", "Ljetbrains/youtrack/ring/export/adapter/HubSyncAdapter;", "(Lkotlinx/dnq/XdEntity;Ljava/lang/String;Ljetbrains/youtrack/ring/export/adapter/HubSyncAdapter;)Lkotlinx/dnq/XdEntity;", "assertImportIsPossible", "", "importGroup", "Ljetbrains/exodus/entitystore/Entity;", "group", "project", "role", "importProject", "importRole", "importTeam", "importUser", "user", "youtrack-ring-integration"})
public final class RingImporterImpl
implements RingImporter {
    private final ExportGroupHubDtoBuilder groupBuilder = new ExportGroupHubDtoBuilder();
    private final userBuilder.1 userBuilder = new ExportUserHubDtoBuilder(){

        @NotNull
        public UserJSON build(@NotNull XdUser entity) {
            UserJSON json;
            block2: {
                ProfileJSON profileJSON;
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                json = super.build(entity);
                Iterable iterable = json.getDetails();
                if (iterable != null && (iterable = CollectionsKt.filterIsInstance((Iterable)iterable, CoreuserdetailsJSON.class)) != null) {
                    Iterable $this$forEach$iv = iterable;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        CoreuserdetailsJSON it = (CoreuserdetailsJSON)element$iv;
                        boolean bl = false;
                        it.setPasswordChangeRequired(Boolean.valueOf(true));
                    }
                }
                if ((profileJSON = json.getProfile()) == null || (profileJSON = profileJSON.getEmail()) == null) break block2;
                profileJSON.setVerified(Boolean.valueOf(true));
            }
            return json;
        }
    };

    @NotNull
    public Entity importUser(@NotNull Entity user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        this.assertImportIsPossible();
        XdUser xdUser = (XdUser)XdUser.Companion.wrap(user2);
        return this.addToHubXd((XdEntity)xdUser, xdUser.getLogin(), jetbrains.youtrack.ring.export.BeansKt.getHubAdapterFactory().getUserAdapter(this.userBuilder)).getEntity();
    }

    @NotNull
    public Entity importRole(@NotNull Entity role) {
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        this.assertImportIsPossible();
        XdRole xdRole = (XdRole)XdRole.Companion.wrap(role);
        return this.addToHubXd((XdEntity)xdRole, xdRole.getName(), jetbrains.youtrack.ring.export.BeansKt.getHubAdapterFactory().getRoleAdapter()).getEntity();
    }

    @NotNull
    public Entity importGroup(@NotNull Entity group2) {
        Intrinsics.checkParameterIsNotNull((Object)group2, (String)"group");
        this.assertImportIsPossible();
        XdUserGroup xdGroup = (XdUserGroup)XdUserGroup.Companion.wrap(group2);
        return this.addToHubXd((XdEntity)xdGroup, xdGroup.getName(), jetbrains.youtrack.ring.export.BeansKt.getHubAdapterFactory().getGroupAdapter(this.groupBuilder)).getEntity();
    }

    @NotNull
    public Entity importProject(@NotNull Entity project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.assertImportIsPossible();
        XdProject xdProject = (XdProject)XdProject.Companion.wrap(project);
        return this.addToHubXd((XdEntity)xdProject, xdProject.getName(), jetbrains.youtrack.ring.export.BeansKt.getHubAdapterFactory().getProjectAdapter()).getEntity();
    }

    @NotNull
    public Entity importGroup(@NotNull Entity group2, @NotNull Entity project, @NotNull Entity role) {
        Intrinsics.checkParameterIsNotNull((Object)group2, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        this.assertImportIsPossible();
        this.importGroup(group2);
        return this.importTeam(group2, project, role);
    }

    @NotNull
    public Entity importTeam(@NotNull Entity group2, @NotNull Entity project, @NotNull Entity role) {
        Intrinsics.checkParameterIsNotNull((Object)group2, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        this.assertImportIsPossible();
        RemoteProjectTeamDAO remoteProjectTeamDAO = jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectTeamDAO();
        Entity entity = BeansKt.getRingTeamApi().getProjectTeam(project);
        if (entity == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"ringTeamApi.getProjectTeam(project)!!");
        String string = EntityExtensionsKt.getHubUuid(XdUserGroup.Companion.wrap(entity));
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = EntityExtensionsKt.getHubUuid(XdUserGroup.Companion.wrap(group2));
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        remoteProjectTeamDAO.includeGroup(string, string2);
        return group2;
    }

    private final void assertImportIsPossible() {
        if (!jetbrains.youtrack.config.BeansKt.getRingConfig().isEnabled()) {
            throw (Throwable)new IllegalStateException("Hub is not available at the moment ");
        }
        jetbrains.youtrack.ring.maintenance.BeansKt.getHubReadOnlyManager().assertIsNotReadOnly();
    }

    private final <T extends XdEntity> T addToHubXd(T entity, String name, HubSyncAdapter<T> adapter2) {
        this.assertImportIsPossible();
        if (adapter2.isExported(entity)) {
            throw (Throwable)new IllegalArgumentException(entity.getEntity().getType() + " " + name + " is already imported into Hub");
        }
        HubExportResult result2 = adapter2.export(entity);
        if (result2.hasError()) {
            throw (Throwable)new RingImporter.ExportFailedException(result2);
        }
        return entity;
    }
}

