/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.listeners.db;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.InputStream;
import jetbrains.exodus.database.IEntityListener;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityAdapter;
import jetbrains.exodus.entitystore.EventsMultiplexer;
import jetbrains.teamsys.dnq.runtime.eventsCompat.EventsMultiplexerLegacy;
import jetbrains.xodus.lang.EntitiesKt;
import jetbrains.youtrack.api.application.AppLifecycleListenerAdapter;
import jetbrains.youtrack.ring.listeners.BeansKt;
import jetbrains.youtrack.ring.listeners.BundleRestClient;
import jetbrains.youtrack.ring.listeners.db.BackupLocationEntityListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KLogging;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004*\u0001\u0004\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/ring/listeners/db/BackupLocationEntityListener;", "Ljetbrains/youtrack/api/application/AppLifecycleListenerAdapter;", "()V", "adapter", "jetbrains/youtrack/ring/listeners/db/BackupLocationEntityListener$adapter$1", "Ljetbrains/youtrack/ring/listeners/db/BackupLocationEntityListener$adapter$1;", "notifyBundlePlatformAboutBaseUrlChange", "", "location", "", "start", "stop", "Companion", "youtrack-ring-integration"})
public final class BackupLocationEntityListener
extends AppLifecycleListenerAdapter {
    private final adapter.1 adapter = new EntityAdapter<TransientEntity>(this){
        final /* synthetic */ BackupLocationEntityListener this$0;

        public void updatedSync(@NotNull TransientEntity old, @NotNull TransientEntity current) {
            Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            if (EntityOperations.hasChanges((TransientEntity)old, (String)"backupLocation") && BeansKt.getBundleRestClient().getShouldNotifyBundle()) {
                Object object = EntitiesKt.get((Entity)((Entity)current), (String)"backupLocation");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                BackupLocationEntityListener.access$notifyBundlePlatformAboutBaseUrlChange(this.this$0, (String)object);
            }
        }
        {
            this.this$0 = $outer;
        }
    };
    public static final Companion Companion = new Companion(null);

    private final void notifyBundlePlatformAboutBaseUrlChange(String location) {
        try {
            HttpResponse response = BundleRestClient.post$default(BeansKt.getBundleRestClient(), "bundle.backups-dir", location, false, 4, null);
            StatusLine statusLine = response.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
            if (statusLine.getStatusCode() == 200) {
                Companion.getLogger().info("New backup location [" + location + "] propagated to bundle");
            } else {
                KLogger kLogger = Companion.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("Failed to post backup location [").append(location).append("] to bundle: ");
                HttpEntity httpEntity = response.getEntity();
                Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"response.entity");
                kLogger.info(stringBuilder.append(IOUtils.readLines((InputStream)httpEntity.getContent())).toString());
            }
        }
        catch (Exception e) {
            Companion.getLogger().warn("Can't propagate backup location to bundle", (Throwable)e);
        }
    }

    public void start() {
        block0: {
            EventsMultiplexer eventsMultiplexer = EventsMultiplexerLegacy.getInstance();
            if (eventsMultiplexer == null) break block0;
            eventsMultiplexer.addListener("DatabaseBackupConfig", (IEntityListener)this.adapter);
        }
    }

    public void stop() {
        EventsMultiplexerLegacy.removeListenerSafe((String)"DatabaseBackupConfig", (IEntityListener)((IEntityListener)this.adapter));
    }

    public static final /* synthetic */ void access$notifyBundlePlatformAboutBaseUrlChange(BackupLocationEntityListener $this, String location) {
        $this.notifyBundlePlatformAboutBaseUrlChange(location);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/listeners/db/BackupLocationEntityListener$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

