/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.listeners.hub;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.event.Event;
import jetbrains.jetpass.api.ssl.KeyStore;
import jetbrains.jetpass.client.BaseField;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.KeyStoreClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.KeyStoreDataJSON;
import jetbrains.jetpass.rest.dto.KeyStoreJSON;
import jetbrains.youtrack.core.ssl.XdKeyStorage;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.listeners.hub.FilteringHubEventListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/ring/listeners/hub/KeyStoreHubEventListener;", "Ljetbrains/youtrack/ring/listeners/hub/FilteringHubEventListener;", "Ljetbrains/jetpass/api/ssl/KeyStore;", "()V", "addOrUpdateEntry", "", "event", "Ljetbrains/jetpass/api/event/Event;", "client", "Ljetbrains/jetpass/client/accounts/KeyStoreClient;", "getEntry", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "handleAdded", "handleRemoved", "handleUpdated", "Companion", "youtrack-ring-integration"})
public final class KeyStoreHubEventListener
extends FilteringHubEventListener<KeyStore> {
    @NotNull
    private static final FieldPartial<Partial.KeyStore> PARTIAL;
    public static final Companion Companion;

    @Override
    protected void handleAdded(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.addOrUpdateEntry(event);
    }

    @Override
    protected void handleUpdated(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.addOrUpdateEntry(event);
    }

    @Override
    protected void handleRemoved(@NotNull Event event) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            XdStorageEntry xdStorageEntry = this.getEntry(event);
            if (xdStorageEntry == null) break block0;
            xdStorageEntry.delete();
        }
    }

    private final void addOrUpdateEntry(Event event) {
        KeyStoreDataJSON dataJson;
        KeyStoreJSON json;
        KeyStoreClient keyStoreClient = this.client();
        String string = event.getTargetId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.targetId");
        KeyStoreJSON keyStoreJSON = json = keyStoreClient.getKeyStore(string, PARTIAL);
        if (keyStoreJSON == null) {
            Intrinsics.throwNpe();
        }
        KeyStoreDataJSON keyStoreDataJSON = dataJson = keyStoreJSON.getData();
        if (keyStoreDataJSON == null) {
            Intrinsics.throwNpe();
        }
        String string2 = keyStoreDataJSON.getBytes();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dataJson!!.bytes!!");
        CharSequence charSequence = string2;
        String string3 = "\n";
        boolean bl = false;
        string3 = new Regex(string3);
        String string4 = "";
        boolean bl2 = false;
        byte[] bytes = Base64.decodeBase64((String)string3.replace(charSequence, string4));
        String string5 = dataJson.getPassword();
        if (string5 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"dataJson.password!!");
        String password = string5;
        Collection imported = ((XdKeyStorage)XdExtensionsKt.toXd((Entity)((Entity)jetbrains.charisma.ssl.keystore.BeansKt.getKeyStorage()))).importKeyStore((InputStream)new ByteArrayInputStream(bytes), password, this.getEntry(event));
        if (imported.size() != 1) {
            Companion.getLogger().error("Hub keystore " + event.getTargetId() + " contains " + imported.size() + " keys, 1 expected");
        }
        XdStorageEntry xdEntry = (XdStorageEntry)CollectionsKt.first((Iterable)imported);
        String string6 = json.getName();
        if (string6 == null) {
            Intrinsics.throwNpe();
        }
        xdEntry.setName(string6);
        EntityExtensionsKt.setHubUuid((XdEntity)xdEntry, json.getId());
    }

    private final XdStorageEntry getEntry(Event event) {
        Object v0;
        block1: {
            Iterable iterable = XdQueryKt.toList((XdQuery)((XdQuery)((XdKeyStorage)XdExtensionsKt.toXd((Entity)((Entity)jetbrains.charisma.ssl.keystore.BeansKt.getKeyStorage()))).getEntries()));
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                XdStorageEntry it = (XdStorageEntry)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)EntityExtensionsKt.getHubUuid((XdEntity)it), (Object)event.getTargetId())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final KeyStoreClient client() {
        return BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getStoreClient();
    }

    public KeyStoreHubEventListener() {
        super(false);
    }

    static {
        Companion = new Companion(null);
        PARTIAL = new FieldPartial((BaseField[])new Partial.KeyStore[]{Partial.KeyStore.DATA((Partial.KeyStoreData[])new Partial.KeyStoreData[]{Partial.KeyStoreData.BYTES, Partial.KeyStoreData.PASSWORD}), Partial.KeyStore.NAME, Partial.KeyStore.ID});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/ring/listeners/hub/KeyStoreHubEventListener$Companion;", "Lmu/KLogging;", "()V", "PARTIAL", "Ljetbrains/jetpass/client/FieldPartial;", "Ljetbrains/jetpass/client/accounts/Partial$KeyStore;", "kotlin.jvm.PlatformType", "getPARTIAL", "()Ljetbrains/jetpass/client/FieldPartial;", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final FieldPartial<Partial.KeyStore> getPARTIAL() {
            return PARTIAL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

