/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.listeners.hub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import jetbrains.charisma.installation.BeansKt;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.event.Event;
import jetbrains.jetpass.api.settings.JabberSettings;
import jetbrains.jetpass.api.settings.LicenseSettings;
import jetbrains.jetpass.api.settings.PublicSettings;
import jetbrains.jetpass.api.settings.SMTPSettings;
import jetbrains.jetpass.api.settings.Settings;
import jetbrains.mps.internationalization.runtime.LocaleEntry;
import jetbrains.youtrack.api.l10n.LocalizationService;
import jetbrains.youtrack.core.persistent.XdMailSendProtocol;
import jetbrains.youtrack.core.persistent.XdNotificationsConfig;
import jetbrains.youtrack.ring.listeners.hub.FilteringHubEventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/ring/listeners/hub/SettingsHubEventListener;", "Ljetbrains/youtrack/ring/listeners/hub/FilteringHubEventListener;", "Ljetbrains/jetpass/api/settings/Settings;", "()V", "handleAdded", "", "event", "Ljetbrains/jetpass/api/event/Event;", "handleUpdated", "isValid", "", "settings", "Ljetbrains/jetpass/api/settings/JabberSettings;", "Ljetbrains/jetpass/api/settings/SMTPSettings;", "updateSettings", "Companion", "youtrack-ring-integration"})
public final class SettingsHubEventListener
extends FilteringHubEventListener<Settings> {
    public static final Companion Companion = new Companion(null);

    @Override
    protected void handleAdded(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.updateSettings(event);
    }

    @Override
    protected void handleUpdated(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.updateSettings(event);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSettings(Event event) {
        Settings settings = (Settings)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getSettingsDAO().get(event.getTargetId());
        Settings settings2 = settings;
        if (settings2 instanceof LicenseSettings) {
            Service service = ((LicenseSettings)settings).getService();
            if (Intrinsics.areEqual((Object)jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId(), (Object)(service != null ? service.getId() : null)) && !ConfigurationUtil.isYoutrackHosted()) {
                jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().setUsername(((LicenseSettings)settings).getLicenseName());
                jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().setLicense(((LicenseSettings)settings).getLicenseKey());
            }
        } else if (settings2 instanceof JabberSettings) {
            if (this.isValid((JabberSettings)settings)) {
                XdNotificationsConfig config = XdNotificationsConfig.Companion.get();
                Boolean bl = ((JabberSettings)settings).isEnabled();
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"settings.isEnabled");
                config.setEnableJabber(bl.booleanValue());
                config.setJabberServer(((JabberSettings)settings).getHost());
                config.setJabberServiceName(((JabberSettings)settings).getServiceName());
                Integer n = ((JabberSettings)settings).getPort();
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"settings.port");
                config.setJabberPort(n.intValue());
                config.setJabberLogin(((JabberSettings)settings).getLogin());
                config.setJabberPassword(((JabberSettings)settings).getPassword());
            }
        } else if (settings2 instanceof SMTPSettings) {
            if (jetbrains.youtrack.config.BeansKt.getRingConfig().hasEmbeddedHub() && this.isValid((SMTPSettings)settings)) {
                XdNotificationsConfig config = XdNotificationsConfig.Companion.get();
                Boolean bl = ((SMTPSettings)settings).isEnabled();
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"settings.isEnabled");
                config.setEnableSmtp(bl.booleanValue());
                config.setSmtpHost(((SMTPSettings)settings).getHost());
                Integer n = ((SMTPSettings)settings).getPort();
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"settings.port");
                config.setSmtpPort(n.intValue());
                config.setSmtpFrom(((SMTPSettings)settings).getFrom());
                config.setSmtpLogin(((SMTPSettings)settings).getLogin());
                config.setSmtpPassword(((SMTPSettings)settings).getPassword());
                config.setMailProtocol(XdMailSendProtocol.Companion.fromString(((SMTPSettings)settings).getProtocol()));
            }
        } else if (settings2 instanceof PublicSettings) {
            if (jetbrains.youtrack.config.BeansKt.getRingConfig().hasEmbeddedHub()) {
                void $this$filterTo$iv$iv;
                Iterable iterable = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getSupportedLocales();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"localizer.supportedLocales");
                Iterable $this$filter$iv = iterable;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LocaleEntry it = (LocaleEntry)element$iv$iv;
                    boolean bl = false;
                    LocaleEntry localeEntry = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)localeEntry, (String)"it");
                    Locale locale = localeEntry.getLocale();
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"it.locale");
                    String string = locale.getLanguage();
                    jetbrains.jetpass.api.settings.Locale locale2 = ((PublicSettings)settings).getLocale();
                    if (locale2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"settings.locale!!");
                    if (!Intrinsics.areEqual((Object)string, (Object)locale2.getLanguage())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LocaleEntry it = (LocaleEntry)element$iv;
                    boolean bl = false;
                    LocalizationService localizationService = BeansKt.getLocalizationService();
                    LocaleEntry localeEntry = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)localeEntry, (String)"it");
                    localizationService.changeLocale(localeEntry.getLocale());
                }
            }
        } else {
            Companion.getLogger().warn("Unknown settings type seceived from Hub [" + event.getTargetType() + "], ignoring");
        }
    }

    private final boolean isValid(SMTPSettings settings) {
        return settings.isEnabled() == false || settings.getHost() != null && settings.getPort() != null && settings.getFrom() != null;
    }

    private final boolean isValid(JabberSettings settings) {
        return settings.isEnabled() == false || settings.getLogin() != null && settings.getPort() != null && settings.getHost() != null && settings.getPort() != null;
    }

    public SettingsHubEventListener() {
        super(false);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/listeners/hub/SettingsHubEventListener$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

