/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.listeners.hub;

import java.util.Collection;
import java.util.Iterator;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.event.AggregationChange;
import jetbrains.jetpass.api.event.Change;
import jetbrains.jetpass.api.event.Event;
import jetbrains.youtrack.ring.listeners.hub.FilteringHubEventListener;
import jetbrains.youtrack.ring.sync.RingUser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\t\u001a\u00020\n*\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Ljetbrains/youtrack/ring/listeners/hub/UserHubEventListener;", "Ljetbrains/youtrack/ring/listeners/hub/FilteringHubEventListener;", "Ljetbrains/jetpass/api/authority/User;", "()V", "handleAdded", "", "event", "Ljetbrains/jetpass/api/event/Event;", "handleUpdated", "hasLocaleChanges", "", "Companion", "youtrack-ring-integration"})
public final class UserHubEventListener
extends FilteringHubEventListener<User> {
    public static final Companion Companion = new Companion(null);

    @Override
    protected void handleAdded(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        try {
            String string = event.getTargetId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.targetId");
            RingUser ringUser = new RingUser(string);
            ringUser.resolveAndSync();
        }
        catch (DataIntegrityViolationException e) {
            Companion.getLogger().debug("UniqueIndexViolation on user creation event handling, dropping event");
        }
    }

    @Override
    protected void handleUpdated(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String string = event.getTargetId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.targetId");
        RingUser ringUser = new RingUser(string);
        if (this.hasLocaleChanges(event)) {
            ringUser.resolveAndSyncWithLocale();
        } else {
            ringUser.resolveAndSync();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasLocaleChanges(@NotNull Event $this$hasLocaleChanges) {
        boolean bl;
        Iterable iterable = $this$hasLocaleChanges.getChanges();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"changes");
        Iterable $this$any$iv = iterable;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            Change change = (Change)element$iv;
            boolean bl2 = false;
            if (change instanceof AggregationChange) {
                boolean bl3;
                Iterable $this$any$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)((AggregationChange)change).getChildChanges(), (String)"change.childChanges");
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv2) {
                        Change childChange = (Change)element$iv2;
                        boolean bl4 = false;
                        Change change2 = childChange;
                        Intrinsics.checkExpressionValueIsNotNull((Object)change2, (String)"childChange");
                        if (!Intrinsics.areEqual((Object)change2.getFieldName(), (Object)"locale")) continue;
                        return true;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public UserHubEventListener() {
        super(false);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/listeners/hub/UserHubEventListener$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

