/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.maintenance;

import java.io.File;
import jetbrains.charisma.maintenance.FolderBackupStrategy;
import jetbrains.charisma.maintenance.OptionalBackupable;
import jetbrains.exodus.backup.Backupable;
import jetbrains.youtrack.ring.maintenance.BeansKt;
import jetbrains.youtrack.ring.maintenance.EmbeddedHubBackupable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/ring/maintenance/EmbeddedHubBackupable;", "Ljetbrains/charisma/maintenance/OptionalBackupable;", "()V", "getBackupable", "Ljetbrains/exodus/backup/Backupable;", "isRequired", "", "Companion", "EmbeddedHubBackupStrategy", "youtrack-ring-integration"})
public final class EmbeddedHubBackupable
implements OptionalBackupable {
    @Nullable
    private static final String EMBEDDED_HUB_DB;
    public static final Companion Companion;

    @NotNull
    public Backupable getBackupable() {
        return getBackupable.1.INSTANCE;
    }

    public boolean isRequired() {
        return EMBEDDED_HUB_DB != null;
    }

    static {
        Companion = new Companion(null);
        EMBEDDED_HUB_DB = System.getProperty("jetbrains.youtrack.backup.hubDatabaseLocation");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/ring/maintenance/EmbeddedHubBackupable$EmbeddedHubBackupStrategy;", "Ljetbrains/charisma/maintenance/FolderBackupStrategy;", "()V", "existingValue", "Ljava/lang/ThreadLocal;", "", "afterBackup", "", "beforeBackup", "youtrack-ring-integration"})
    private static final class EmbeddedHubBackupStrategy
    extends FolderBackupStrategy {
        private final ThreadLocal<Boolean> existingValue = new ThreadLocal();

        public void beforeBackup() {
            Companion.getLogger().debug("Backing up embedded Hub...");
            super.beforeBackup();
            try {
                if (BeansKt.getHubReadOnlyManager().isReadOnly()) {
                    this.existingValue.set(true);
                } else {
                    this.existingValue.set(false);
                    BeansKt.getHubReadOnlyManager().setReadOnly(true);
                }
            }
            catch (Exception e) {
                Companion.getLogger().warn("Failed to switch embedded Hub to readonly mode for backup, will continue anyway", (Throwable)e);
                this.existingValue.set(true);
            }
        }

        public void afterBackup() {
            super.afterBackup();
            try {
                if (!this.existingValue.get().booleanValue()) {
                    BeansKt.getHubReadOnlyManager().setReadOnly(false);
                }
            }
            catch (Exception e) {
                Companion.getLogger().warn("Failed to reset readonly flag for an embedded Hub after backup", (Throwable)e);
            }
            Companion.getLogger().debug("Embedded Hub completed");
        }

        public EmbeddedHubBackupStrategy() {
            super(new File(Companion.getEMBEDDED_HUB_DB()), "hub" + File.separator);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/ring/maintenance/EmbeddedHubBackupable$Companion;", "Lmu/KLogging;", "()V", "EMBEDDED_HUB_DB", "", "getEMBEDDED_HUB_DB", "()Ljava/lang/String;", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        @Nullable
        public final String getEMBEDDED_HUB_DB() {
            return EMBEDDED_HUB_DB;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

