/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.maintenance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.client.BaseField;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.OrganizationClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.PermissionClient;
import jetbrains.jetpass.client.accounts.ProjectTeamClient;
import jetbrains.jetpass.client.accounts.RoleClient;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.jetpass.client.accounts.UserGroupClient;
import jetbrains.jetpass.rest.dto.OrganizationJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.ResourceJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.XdOrganization;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.ring.BeansKt;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.RingAuditLog;
import jetbrains.youtrack.ring.maintenance.HubIntegrationUserActionJob;
import jetbrains.youtrack.ring.persistence.quickfix.XdGroupMappingQuickFix;
import jetbrains.youtrack.ring.persistence.quickfix.XdOrganizationMappingQuickFix;
import jetbrains.youtrack.ring.persistence.quickfix.XdProjectMappingQuickFix;
import jetbrains.youtrack.ring.persistence.quickfix.XdResourceLocationQuickFix;
import jetbrains.youtrack.ring.persistence.quickfix.XdRoleMappingQuickFix;
import jetbrains.youtrack.ring.persistence.quickfix.XdUnknownResourceQuickFix;
import jetbrains.youtrack.ring.persistence.quickfix.XdUserMappingQuickFix;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/ring/maintenance/HubMappingValidationJob;", "Ljetbrains/youtrack/ring/maintenance/HubIntegrationUserActionJob;", "()V", "ordinal", "", "getOrdinal", "()I", "uiDescription", "", "getUiDescription", "()Ljava/lang/String;", "uiName", "getUiName", "collectIds", "", "items", "", "Ljetbrains/jetpass/api/IdItem;", "preloadHubUuids", "loader", "Lkotlin/Function1;", "Ljetbrains/jetpass/client/Filter;", "run", "", "validateGroups", "validateOrganizations", "validatePermissions", "validateProjects", "validateRoles", "validateTeams", "validateUsers", "youtrack-ring-integration"})
public final class HubMappingValidationJob
extends HubIntegrationUserActionJob {
    private final int ordinal = 2;

    @Override
    @NotNull
    public String getUiName() {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("HubMappingValidationJob.Run_diagnostics", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026tionJob.Run_diagnostics\")");
        return string;
    }

    @Override
    @NotNull
    public String getUiDescription() {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("HubMappingValidationJob.Detect_broken_or_missing_links_between_YouTrack_and_Hub_data", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026n_YouTrack_and_Hub_data\")");
        return string;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    protected void run() {
        RingAuditLog ringAuditLog = BeansKt.getRingAuditLog();
        String string = this.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        ringAuditLog.withActivity(string, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("Hub mapping validation job started");
                try {
                    if (jetbrains.youtrack.config.BeansKt.getRingConfig().isEnabled()) {
                        HubMappingValidationJob.access$validatePermissions(this.this$0);
                        HubMappingValidationJob.access$validateRoles(this.this$0);
                        HubMappingValidationJob.access$validateProjects(this.this$0);
                        HubMappingValidationJob.access$validateOrganizations(this.this$0);
                        HubMappingValidationJob.access$validateGroups(this.this$0);
                        HubMappingValidationJob.access$validateTeams(this.this$0);
                        HubMappingValidationJob.access$validateUsers(this.this$0);
                    } else {
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error("Can't validate Hub mappings: No connection to Hub");
                    }
                }
                catch (Exception e) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error("Hub mapping validation job failed: " + e.getMessage());
                    throw (Throwable)e;
                }
                finally {
                    this.this$0.setStatus("Hub mapping validation job completed");
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info(this.this$0.getStatus());
                }
            }
            {
                this.this$0 = hubMappingValidationJob;
                super(0);
            }
        }));
    }

    private final void validateUsers() {
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TransientStoreSession it) {
                Collection $this$filter$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub user mapping...");
                UserClient client2 = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getUserClient();
                Partial partial = Partial.user((Partial.User[])new Partial.User[]{Partial.User.ID, Partial.User.ALIASES((Partial.Alias[])new Partial.Alias[]{Partial.Alias.ID})});
                Set hubUsers2 = HubMappingValidationJob.access$preloadHubUuids(this.this$0, (Function1)new Function1<Filter, List<? extends UserJSON>>(client2, partial){
                    final /* synthetic */ UserClient $client;
                    final /* synthetic */ Partial $partial;

                    @NotNull
                    public final List<UserJSON> invoke(@NotNull Filter filter) {
                        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                        return this.$client.getUserPage((BaseFilter)filter, (FieldPartial)this.$partial).getUsers();
                    }
                    {
                        this.$client = userClient;
                        this.$partial = partial;
                        super(1);
                    }
                });
                boolean bl = false;
                List brokenUsers = new ArrayList<E>();
                int procesed = 0;
                List userBatch = XdQueryKt.toList((XdQuery)XdQueryKt.take((XdQuery)XdUser.Companion.all(), (int)500));
                do {
                    void $this$filterTo$iv$iv;
                    Iterable iterable = userBatch;
                    List list = brokenUsers;
                    boolean $i$f$filter = false;
                    Iterator<T> iterator2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        XdUser localUser = (XdUser)element$iv$iv;
                        boolean bl2 = false;
                        if (!(!CollectionsKt.contains((Iterable)hubUsers2, (Object)EntityExtensionsKt.getHubUuid((XdEntity)localUser)) && !localUser.isService() && !localUser.isSystem())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv;
                    list.addAll(list2);
                    userBatch = XdQueryKt.toList((XdQuery)XdQueryKt.take((XdQuery)XdQueryKt.drop((XdQuery)XdUser.Companion.all(), (int)(procesed += 500)), (int)500));
                    $this$filter$iv = userBatch;
                    $i$f$filter = false;
                } while (!$this$filter$iv.isEmpty());
                if (brokenUsers.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All users have valid mappings in Hub");
                } else {
                    Iterable $this$forEach$iv = brokenUsers;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        XdUser user2 = (XdUser)element$iv;
                        boolean bl3 = false;
                        String string = EntityExtensionsKt.getHubUuid((XdEntity)user2);
                        String message2 = string == null ? "User " + user2.getLogin() + " is not exported to hub" : "User " + user2.getLogin() + " has invalid Hub mapping";
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error(message2, XdUserMappingQuickFix.Companion.new(user2));
                    }
                }
            }
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }
        }));
    }

    private final void validateGroups() {
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TransientStoreSession it) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub user group mapping...");
                UserGroupClient ugClient = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getUserGroupClient();
                Partial partial = Partial.userGroup((Partial.UserGroup[])new Partial.UserGroup[]{Partial.UserGroup.ID, Partial.UserGroup.ALIASES((Partial.Alias[])new Partial.Alias[]{Partial.Alias.ID})});
                Set hubGroups2 = HubMappingValidationJob.access$preloadHubUuids(this.this$0, (Function1)new Function1<Filter, List<? extends UserGroupJSON>>(ugClient, partial){
                    final /* synthetic */ UserGroupClient $ugClient;
                    final /* synthetic */ Partial $partial;

                    @NotNull
                    public final List<UserGroupJSON> invoke(@NotNull Filter filter) {
                        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                        return this.$ugClient.getUserGroupPage((BaseFilter)filter, (FieldPartial)this.$partial).getUsergroups();
                    }
                    {
                        this.$ugClient = userGroupClient;
                        this.$partial = partial;
                        super(1);
                    }
                });
                Iterable $this$filter$iv = XdQueryKt.toList((XdQuery)XdUserGroup.Companion.all());
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    XdUserGroup localGroup2 = (XdUserGroup)element$iv$iv;
                    boolean bl = false;
                    if (!(!EntityExtensionsKt.isTeam(localGroup2) && !CollectionsKt.contains((Iterable)hubGroups2, (Object)EntityExtensionsKt.getHubUuid((XdEntity)localGroup2)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List brokenGroups = (List)destination$iv$iv;
                if (brokenGroups.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All user groups have valid mappings in Hub");
                } else {
                    Iterable $this$forEach$iv = brokenGroups;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        XdUserGroup group2 = (XdUserGroup)element$iv;
                        boolean bl = false;
                        String string = EntityExtensionsKt.getHubUuid((XdEntity)group2);
                        String message2 = string == null ? "User group " + group2.getName() + " is not exported to hub" : "User group " + group2.getName() + " has invalid Hub mapping";
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error(message2, XdGroupMappingQuickFix.Companion.new(group2));
                    }
                }
            }
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }
        }));
    }

    private final void validateTeams() {
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TransientStoreSession it) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub project team mapping...");
                ProjectTeamClient client2 = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getProjectTeamClient();
                Partial partial = Partial.projectTeam((Partial.ProjectTeam[])new Partial.ProjectTeam[]{Partial.ProjectTeam.ID});
                Set hubTeams2 = HubMappingValidationJob.access$preloadHubUuids(this.this$0, (Function1)new Function1<Filter, List<? extends ProjectTeamJSON>>(client2, partial){
                    final /* synthetic */ ProjectTeamClient $client;
                    final /* synthetic */ Partial $partial;

                    @NotNull
                    public final List<ProjectTeamJSON> invoke(@NotNull Filter filter) {
                        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                        return this.$client.getProjectTeamPage((BaseFilter)filter, (FieldPartial)this.$partial).getProjectteams();
                    }
                    {
                        this.$client = projectTeamClient;
                        this.$partial = partial;
                        super(1);
                    }
                });
                Iterable $this$filter$iv = XdQueryKt.toList((XdQuery)XdUserGroup.Companion.all());
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    XdUserGroup localGroup2 = (XdUserGroup)element$iv$iv;
                    boolean bl = false;
                    if (!(EntityExtensionsKt.isTeam(localGroup2) && !CollectionsKt.contains((Iterable)hubTeams2, (Object)EntityExtensionsKt.getHubUuid((XdEntity)localGroup2)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List brokenTeams = (List)destination$iv$iv;
                if (brokenTeams.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All project teams have valid mappings in Hub");
                } else {
                    Iterable $this$forEach$iv = brokenTeams;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        XdUserGroup group2 = (XdUserGroup)element$iv;
                        boolean bl = false;
                        String string = EntityExtensionsKt.getHubUuid((XdEntity)group2);
                        String message2 = string == null ? "Project team " + group2.getName() + " is not exported to hub" : "Project team " + group2.getName() + " has invalid Hub mapping";
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error(message2, XdGroupMappingQuickFix.Companion.new(group2));
                    }
                }
            }
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }
        }));
    }

    private final void validatePermissions() {
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TransientStoreSession it) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub permission mapping...");
                Filter filter = new Filter(null, 1, null);
                filter.query("service: 0-0-0-0-0 or service: " + jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
                PermissionClient.Page page = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getPermissionClient().getPermissionPage((BaseFilter)filter, (FieldPartial)Partial.permission((Partial.Permission[])new Partial.Permission[]{Partial.Permission.ID}));
                Set hubPermissions = HubMappingValidationJob.access$collectIds(this.this$0, page.getItems());
                Permission[] $this$filter$iv = Permission.values();
                boolean $i$f$filter = false;
                Permission[] permissionArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                void var11_11 = $this$filterTo$iv$iv;
                int n = ((void)var11_11).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void localPermission = element$iv$iv = var11_11[i];
                    boolean bl = false;
                    if (!(!CollectionsKt.contains((Iterable)hubPermissions, (Object)EntityExtensionsKt.getHubUuid((Permission)localPermission)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List brokenPermissions = (List)destination$iv$iv;
                if (brokenPermissions.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All permissions have valid mappings in Hub");
                } else {
                    Iterable $this$forEach$iv = brokenPermissions;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        String string;
                        Permission permission = (Permission)element$iv;
                        boolean bl = false;
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error((string = EntityExtensionsKt.getHubUuid(permission)) == null ? "Permission " + permission.name() + " is not exported to Hub" : "Permission " + permission.name() + " has invalid Hub mapping");
                    }
                }
            }
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }
        }));
    }

    private final void validateRoles() {
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TransientStoreSession it) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub user role mapping...");
                RoleClient client2 = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getRoleClient();
                Partial partial = Partial.role((Partial.Role[])new Partial.Role[]{Partial.Role.ID, Partial.Role.ALIASES((Partial.Alias[])new Partial.Alias[]{Partial.Alias.ID})});
                Set hubRoles2 = HubMappingValidationJob.access$preloadHubUuids(this.this$0, (Function1)new Function1<Filter, List<? extends RoleJSON>>(client2, partial){
                    final /* synthetic */ RoleClient $client;
                    final /* synthetic */ Partial $partial;

                    @NotNull
                    public final List<RoleJSON> invoke(@NotNull Filter filter) {
                        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                        return this.$client.getRolePage((BaseFilter)filter, (FieldPartial)this.$partial).getRoles();
                    }
                    {
                        this.$client = roleClient;
                        this.$partial = partial;
                        super(1);
                    }
                });
                Iterable $this$filter$iv = XdQueryKt.toList((XdQuery)XdRole.Companion.all());
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    XdRole localRole = (XdRole)element$iv$iv;
                    boolean bl = false;
                    if (!(!CollectionsKt.contains((Iterable)hubRoles2, (Object)EntityExtensionsKt.getHubUuid((XdEntity)localRole)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List brokenRoles = (List)destination$iv$iv;
                if (brokenRoles.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All roles have valid mappings in Hub");
                } else {
                    Iterable $this$forEach$iv = brokenRoles;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        XdRole role = (XdRole)element$iv;
                        boolean bl = false;
                        String string = EntityExtensionsKt.getHubUuid((XdEntity)role);
                        String message2 = string == null ? "Role " + role.getName() + " is not exported to hub" : "Role " + role.getName() + " has invalid Hub mapping";
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error(message2, XdRoleMappingQuickFix.Companion.new(role));
                    }
                }
            }
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }
        }));
    }

    private final void validateProjects() {
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TransientStoreSession it) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String resource;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                Iterator<T> $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub project mapping...");
                ServiceClient serviceClient = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getServiceClient();
                String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                ServiceClient.ResourceClient client2 = serviceClient.getResourcesClient(string);
                Partial partial = Partial.resource((Partial.Resource[])new Partial.Resource[]{Partial.Resource.ID, Partial.Resource.ALIASES((Partial.Alias[])new Partial.Alias[]{Partial.Alias.ID})});
                Set hubResources2 = HubMappingValidationJob.access$preloadHubUuids(this.this$0, (Function1)new Function1<Filter, List<? extends ResourceJSON>>(client2, partial){
                    final /* synthetic */ ServiceClient.ResourceClient $client;
                    final /* synthetic */ Partial $partial;

                    @NotNull
                    public final List<ResourceJSON> invoke(@NotNull Filter filter) {
                        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                        return this.$client.getResourcePage((BaseFilter)filter, (FieldPartial)this.$partial).getResources();
                    }
                    {
                        this.$client = resourceClient;
                        this.$partial = partial;
                        super(1);
                    }
                });
                Iterable $this$filter$iv = XdQueryKt.toList((XdQuery)XdProject.Companion.all());
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                Iterator<T> iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    T element$iv$iv = iterator2.next();
                    XdProject project = (XdProject)element$iv$iv;
                    boolean bl = false;
                    if (!(!CollectionsKt.contains((Iterable)hubResources2, (Object)EntityExtensionsKt.getHubUuid((XdEntity)project)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List brokenProjects = (List)destination$iv$iv;
                if (brokenProjects.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All projects have valid mappings in Hub ");
                    if (jetbrains.youtrack.config.BeansKt.getRingConfig().hasEmbeddedHub()) {
                        $this$forEach$iv = XdQueryKt.toList((XdQuery)XdProject.Companion.all());
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            XdProject project = (XdProject)element$iv;
                            boolean bl = false;
                            resource = client2.getResource(EntityExtensionsKt.getHubUuidNotNull((XdEntity)project), (FieldPartial)Partial.resource((Partial.Resource[])new Partial.Resource[]{Partial.Resource.PROJECT((Partial.Project[])new Partial.Project[]{Partial.Project.NAME})}));
                            ProjectJSON projectJSON = resource.getProject();
                            if (!(Intrinsics.areEqual((Object)project.getName(), (Object)(projectJSON != null ? projectJSON.getName() : null)) ^ true)) continue;
                            XdResourceLocationQuickFix fix = XdResourceLocationQuickFix.Companion.new(project);
                            ProjectJSON projectJSON2 = resource.getProject();
                            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error("Project " + project.getName() + " has wrong location in Hub (" + (projectJSON2 != null ? projectJSON2.getName() : null) + ')', fix);
                        }
                    }
                } else {
                    $this$forEach$iv = brokenProjects;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        XdProject project = (XdProject)element$iv;
                        boolean bl = false;
                        resource = EntityExtensionsKt.getHubUuid((XdEntity)project);
                        String message2 = resource == null ? "Project " + project.getName() + " is not exported to Hub" : "Project " + project.getName() + " has invalid Hub mapping";
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error(message2, XdProjectMappingQuickFix.Companion.new(project));
                    }
                }
                $this$filterTo$iv$iv = XdQueryKt.toList((XdQuery)XdProject.Companion.all());
                Set set = hubResources2;
                boolean $i$f$map = false;
                void project = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    XdProject xdProject = (XdProject)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    String string2 = EntityExtensionsKt.getHubUuid((XdEntity)it2);
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv2;
                for (String unknownUuid : CollectionsKt.filterNotNull((Iterable)SetsKt.minus((Set)set, (Iterable)collection))) {
                    ResourceJSON resource2 = client2.getResource(unknownUuid, (FieldPartial)Partial.resource((Partial.Resource[])new Partial.Resource[]{Partial.Resource.KEY}));
                    XdUnknownResourceQuickFix fix = XdUnknownResourceQuickFix.Companion.new(unknownUuid, resource2.getKey());
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error("Resource " + resource2.getKey() + " belongs to 'YouTrack', but does not have a valid project associated", fix);
                }
            }
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }
        }));
    }

    private final void validateOrganizations() {
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ HubMappingValidationJob this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TransientStoreSession it) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.setStatus("Validating Hub organization mapping...");
                OrganizationClient client2 = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getOrganizationClient();
                FieldPartial partial = new FieldPartial((BaseField[])new Partial.Organization[]{Partial.Organization.ID, Partial.Organization.PROJECTS((Partial.Project[])new Partial.Project[]{Partial.Project.ID})});
                Set hubOrganizations2 = HubMappingValidationJob.access$preloadHubUuids(this.this$0, (Function1)new Function1<Filter, List<? extends OrganizationJSON>>(client2, partial){
                    final /* synthetic */ OrganizationClient $client;
                    final /* synthetic */ FieldPartial $partial;

                    @NotNull
                    public final List<OrganizationJSON> invoke(@NotNull Filter filter) {
                        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                        return this.$client.getOrganizationPage((BaseFilter)filter, this.$partial).getOrganizations();
                    }
                    {
                        this.$client = organizationClient;
                        this.$partial = fieldPartial;
                        super(1);
                    }
                });
                Iterable $this$filter$iv = XdQueryKt.toList((XdQuery)XdOrganization.Companion.all());
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    XdOrganization project = (XdOrganization)element$iv$iv;
                    boolean bl = false;
                    if (!(!CollectionsKt.contains((Iterable)hubOrganizations2, (Object)EntityExtensionsKt.getHubUuid((XdEntity)project)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List brokenOrganizations = (List)destination$iv$iv;
                if (brokenOrganizations.isEmpty()) {
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info("All organizations have valid mappings in Hub ");
                } else {
                    Iterable $this$forEach$iv = brokenOrganizations;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        XdOrganization organization = (XdOrganization)element$iv;
                        boolean bl = false;
                        String string = EntityExtensionsKt.getHubUuid((XdEntity)organization);
                        String message2 = string == null ? "Organization " + organization.getName() + " is not exported to Hub" : "Organization " + organization.getName() + " has invalid Hub mapping";
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error(message2, XdOrganizationMappingQuickFix.Companion.new(organization));
                    }
                }
            }
            {
                this.this$0 = hubMappingValidationJob;
                super(1);
            }
        }));
    }

    private final Set<String> preloadHubUuids(Function1<? super Filter, ? extends List<? extends IdItem>> loader) {
        Collection collection;
        int hubPageSize = 250;
        HashSet uuids = new HashSet();
        Filter filter = new Filter(null, 1, null);
        List items = null;
        int skip = 0;
        filter.top(hubPageSize);
        do {
            items = (List)loader.invoke((Object)filter);
            uuids.addAll(this.collectIds(items));
            filter.skip(skip += hubPageSize);
            collection = items;
            boolean bl = false;
        } while (!collection.isEmpty());
        return uuids;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> collectIds(List<? extends IdItem> items) {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdItem idItem = (IdItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getId();
            collection.add(string);
        }
        List ids = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = items;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            IdItem item = (IdItem)element$iv$iv;
            boolean bl = false;
            if (item.getAliases() != null) {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Alias alias = (Alias)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl2 = false;
                    void v0 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
                    String string = v0.getId();
                    collection.add(string);
                }
                list = (List)destination$iv$iv3;
            } else {
                boolean bl3 = false;
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List aliases = (List)destination$iv$iv2;
        return CollectionsKt.union((Iterable)ids, (Iterable)aliases);
    }

    public HubMappingValidationJob() {
        super("Hub mapping validation job");
    }

    public static final /* synthetic */ void access$validatePermissions(HubMappingValidationJob $this) {
        $this.validatePermissions();
    }

    public static final /* synthetic */ void access$validateRoles(HubMappingValidationJob $this) {
        $this.validateRoles();
    }

    public static final /* synthetic */ void access$validateProjects(HubMappingValidationJob $this) {
        $this.validateProjects();
    }

    public static final /* synthetic */ void access$validateOrganizations(HubMappingValidationJob $this) {
        $this.validateOrganizations();
    }

    public static final /* synthetic */ void access$validateGroups(HubMappingValidationJob $this) {
        $this.validateGroups();
    }

    public static final /* synthetic */ void access$validateTeams(HubMappingValidationJob $this) {
        $this.validateTeams();
    }

    public static final /* synthetic */ void access$validateUsers(HubMappingValidationJob $this) {
        $this.validateUsers();
    }

    public static final /* synthetic */ Set access$preloadHubUuids(HubMappingValidationJob $this, Function1 loader) {
        return $this.preloadHubUuids((Function1<? super Filter, ? extends List<? extends IdItem>>)loader);
    }

    public static final /* synthetic */ Set access$collectIds(HubMappingValidationJob $this, List items) {
        return $this.collectIds(items);
    }
}

