/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.maintenance;

import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.ring.BeansKt;
import jetbrains.youtrack.ring.HubReplicatingMarker;
import jetbrains.youtrack.ring.RingAuditLog;
import jetbrains.youtrack.ring.maintenance.HubIntegrationUserActionJob;
import jetbrains.youtrack.ring.maintenance.InvalidateRemoteCachesJob;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/ring/maintenance/InvalidateRemoteCachesJob;", "Ljetbrains/youtrack/ring/maintenance/HubIntegrationUserActionJob;", "()V", "ordinal", "", "getOrdinal", "()I", "uiDescription", "", "getUiDescription", "()Ljava/lang/String;", "uiName", "getUiName", "rebuildCaches", "", "run", "Companion", "youtrack-ring-integration"})
public final class InvalidateRemoteCachesJob
extends HubIntegrationUserActionJob {
    private final int ordinal = 3;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getUiName() {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("InvalidateRemoteCachesJob.Invalidate_caches", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026esJob.Invalidate_caches\")");
        return string;
    }

    @Override
    @NotNull
    public String getUiDescription() {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("InvalidateRemoteCachesJob.Clear_local_data_caches_and_reload_fresh_data_from_Hub", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026oad_fresh_data_from_Hub\")");
        return string;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    protected void run() {
        RingAuditLog ringAuditLog = BeansKt.getRingAuditLog();
        String string = this.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        ringAuditLog.withActivity(string, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ InvalidateRemoteCachesJob this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    HubReplicatingMarker.INSTANCE.suspendRingNotificationsForThread();
                    jetbrains.youtrack.api.application.BeansKt.getRuleEngine().addIgnoreThread();
                    jetbrains.charisma.persistent.BeansKt.getSystemApplyEventMarker().add();
                    InvalidateRemoteCachesJob.access$rebuildCaches(this.this$0);
                }
                catch (Exception e) {
                    this.this$0.setStatus("Cache rebuild failed, see logs for details");
                    InvalidateRemoteCachesJob.Companion.getLogger().warn("Failed to rebuild remote api cache", (Throwable)e);
                }
                finally {
                    HubReplicatingMarker.INSTANCE.resumeRingNotificationsForThread();
                    jetbrains.youtrack.api.application.BeansKt.getRuleEngine().removeIgnoreThread();
                    jetbrains.charisma.persistent.BeansKt.getSystemApplyEventMarker().remove();
                }
            }
            {
                this.this$0 = invalidateRemoteCachesJob;
                super(0);
            }
        }));
    }

    private final void rebuildCaches() {
        this.setStatus("Resyncing remote cache...");
        LegacySupportKt.transactional((Function1)rebuildCaches.1.INSTANCE);
        this.setStatus("Updating permission caches...");
        if (jetbrains.youtrack.ring.impl.BeansKt.getHubSecurity().getInitComplete()) {
            LegacySupportKt.transactional((Function1)rebuildCaches.2.INSTANCE);
        } else {
            jetbrains.youtrack.config.BeansKt.getRingConfig().initHubIntegration();
        }
        this.setStatus("Completed");
    }

    public InvalidateRemoteCachesJob() {
        super("Invalidate Hub caches job");
    }

    public static final /* synthetic */ void access$rebuildCaches(InvalidateRemoteCachesJob $this) {
        $this.rebuildCaches();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/maintenance/InvalidateRemoteCachesJob$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

