/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.maintenance;

import java.util.Collection;
import java.util.HashSet;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.ProjectTeamClient;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.jetpass.client.accounts.UserGroupClient;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.ring.maintenance.HubIntegrationUserActionJob;
import jetbrains.youtrack.ring.sync.RingGroup;
import jetbrains.youtrack.ring.sync.RingTeam;
import jetbrains.youtrack.ring.sync.RingUser;
import jetbrains.youtrack.security.BeansKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001eH\u0002J\b\u0010$\u001a\u00020\u001aH\u0014J\u0016\u0010%\u001a\u00020\u001a2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020#0\u001eH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Ljetbrains/youtrack/ring/maintenance/SyncUsersWithHubJob;", "Ljetbrains/youtrack/ring/maintenance/HubIntegrationUserActionJob;", "()V", "groupClient", "Ljetbrains/jetpass/client/accounts/UserGroupClient;", "getGroupClient", "()Ljetbrains/jetpass/client/accounts/UserGroupClient;", "ordinal", "", "getOrdinal", "()I", "teamClient", "Ljetbrains/jetpass/client/accounts/ProjectTeamClient;", "getTeamClient", "()Ljetbrains/jetpass/client/accounts/ProjectTeamClient;", "uiDescription", "", "getUiDescription", "()Ljava/lang/String;", "uiName", "getUiName", "userClient", "Ljetbrains/jetpass/client/accounts/UserClient;", "getUserClient", "()Ljetbrains/jetpass/client/accounts/UserClient;", "loadAndSyncGroups", "", "loadAndSyncTeams", "loadAndSyncUsers", "loadGroups", "", "Ljetbrains/jetpass/rest/dto/UserGroupJSON;", "loadTeams", "Ljetbrains/jetpass/rest/dto/ProjectTeamJSON;", "loadUsers", "Ljetbrains/jetpass/rest/dto/UserJSON;", "run", "syncUsers", "ringUsers", "Companion", "youtrack-ring-integration"})
public final class SyncUsersWithHubJob
extends HubIntegrationUserActionJob {
    private final int ordinal = 0;
    private static final int RING_PAGE_SIZE = 200;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getUiName() {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("SyncUsersWithHubJob.Sync", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"SyncUsersWithHubJob.Sync\")");
        return string;
    }

    @Override
    @NotNull
    public String getUiDescription() {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("SyncUsersWithHubJob.Sync_user_accounts_and_groups_with_Hub", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026nts_and_groups_with_Hub\")");
        return string;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    private final UserClient getUserClient() {
        return jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getUserClient();
    }

    private final UserGroupClient getGroupClient() {
        return jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getUserGroupClient();
    }

    private final ProjectTeamClient getTeamClient() {
        return jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClientWithLongTimeouts().getProjectTeamClient();
    }

    @Override
    protected void run() {
        try {
            this.loadAndSyncGroups();
            this.loadAndSyncTeams();
            this.loadAndSyncUsers();
            BeansKt.getSecurityCacheContainer().invalidate();
        }
        catch (Exception e) {
            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().error("Failed to sync data with Hub", e);
        }
    }

    private final void loadAndSyncGroups() {
        this.setStatus("Syncing user groups");
        Collection<UserGroupJSON> ringGroups = this.loadGroups();
        try {
            LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(ringGroups){
                final /* synthetic */ Collection $ringGroups;

                public final void invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Iterable $this$forEach$iv = this.$ringGroups;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        UserGroupJSON it2 = (UserGroupJSON)element$iv;
                        boolean bl = false;
                        new RingGroup((UserGroup)it2).resolve();
                    }
                }
                {
                    this.$ringGroups = collection;
                    super(1);
                }
            }));
        }
        catch (Exception e) {
            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Failed to sync user group list from Hub", e);
        }
        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info(ringGroups.size() + " user groups synchronized with Hub");
    }

    private final Collection<UserGroupJSON> loadGroups() {
        int skip = 0;
        Filter filter = new Filter(null, 1, null);
        filter.top(200);
        filter.skip(skip);
        UserGroupClient.Page page = this.getGroupClient().getUserGroupPage((BaseFilter)filter, RingGroup.Companion.getSYNC_PARTIAL());
        HashSet ringUserGroups = new HashSet();
        while (true) {
            Collection collection = page.getUsergroups();
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            ringUserGroups.addAll(page.getUsergroups());
            try {
                filter.skip(skip += 200);
                page = this.getGroupClient().getUserGroupPage((BaseFilter)filter, RingGroup.Companion.getSYNC_PARTIAL());
            }
            catch (Throwable e) {
                jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Problems during loading user groups in youtrack (processed = " + (skip - 200) + ')', e);
            }
        }
        return ringUserGroups;
    }

    private final void loadAndSyncTeams() {
        this.setStatus("Syncing project teams");
        Collection<ProjectTeamJSON> projectTeams = this.loadTeams();
        try {
            LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(projectTeams){
                final /* synthetic */ Collection $projectTeams;

                public final void invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Iterable $this$forEach$iv = this.$projectTeams;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ProjectTeamJSON it2 = (ProjectTeamJSON)element$iv;
                        boolean bl = false;
                        new RingTeam((ProjectTeam)it2).resolveAndSync();
                    }
                }
                {
                    this.$projectTeams = collection;
                    super(1);
                }
            }));
        }
        catch (Exception e) {
            jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Failed to sync project team list from Hub", e);
        }
        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info(projectTeams.size() + " project teams synchronized with Hub");
    }

    private final Collection<ProjectTeamJSON> loadTeams() {
        int skip = 0;
        Filter filter = new Filter(null, 1, null);
        filter.query("not project: Global");
        filter.top(200);
        filter.skip(skip);
        ProjectTeamClient.Page page = this.getTeamClient().getProjectTeamPage((BaseFilter)filter, (FieldPartial)RingTeam.Companion.getTEAM_PARTIAL());
        HashSet hubTeams2 = new HashSet();
        while (true) {
            Collection collection = page.getProjectteams();
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            hubTeams2.addAll(page.getProjectteams());
            try {
                filter.skip(skip += 200);
                page = this.getTeamClient().getProjectTeamPage((BaseFilter)filter, (FieldPartial)RingTeam.Companion.getTEAM_PARTIAL());
            }
            catch (Throwable e) {
                jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Problems during loading project teams in youtrack (processed = " + (skip - 200) + ')', e);
            }
        }
        return hubTeams2;
    }

    private final void loadAndSyncUsers() {
        this.setStatus("Loading users");
        Collection<UserJSON> users = this.loadUsers();
        this.setStatus("Syncing users");
        this.syncUsers(users);
        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().info(users.size() + " users synced with Hub");
    }

    private final Collection<UserJSON> loadUsers() {
        int skip = 0;
        Filter filter = new Filter(null, 1, null);
        filter.top(200);
        filter.skip(skip);
        UserClient.Page page = this.getUserClient().getUserPage((BaseFilter)filter, (FieldPartial)RingUser.Companion.getSYNC_PARTIAL());
        HashSet ringUsers = new HashSet();
        while (true) {
            Collection collection = page.getUsers();
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            ringUsers.addAll(page.getUsers());
            this.setStatus(ringUsers.size() + " users loaded");
            try {
                filter.skip(skip += 200);
                page = this.getUserClient().getUserPage((BaseFilter)filter, (FieldPartial)RingUser.Companion.getSYNC_PARTIAL());
            }
            catch (Exception e) {
                jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Problems during loading users in youtrack (processed = " + (skip - 200) + ')', e);
            }
        }
        return ringUsers;
    }

    /*
     * WARNING - void declaration
     */
    private final void syncUsers(Collection<? extends UserJSON> ringUsers) {
        void count;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        int total = ringUsers.size();
        int batchSize = Math.max(1, ringUsers.size() / 1000);
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this, ringUsers, (Ref.IntRef)count, batchSize, total){
            final /* synthetic */ SyncUsersWithHubJob this$0;
            final /* synthetic */ Collection $ringUsers;
            final /* synthetic */ Ref.IntRef $count;
            final /* synthetic */ int $batchSize;
            final /* synthetic */ int $total;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                for (UserJSON json : this.$ringUsers) {
                    new RingUser((User)json).resolveAndSyncWithLocale();
                    Ref.IntRef intRef = this.$count;
                    ++intRef.element;
                    if (intRef.element % this.$batchSize != 0) continue;
                    SyncUsersWithHubJob.Companion.getLogger().info(this.$count.element + " users out of " + this.$total + " synced with Hub");
                    try {
                        LegacySupportKt.flush();
                    }
                    catch (Exception e) {
                        LegacySupportKt.revert();
                        jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Can't sync user with Hub: " + e.getMessage(), e);
                    }
                    this.this$0.setStatus(this.$count.element + " users synced");
                }
                try {
                    LegacySupportKt.flush();
                }
                catch (Exception e) {
                    LegacySupportKt.revert();
                    jetbrains.youtrack.ring.persistence.BeansKt.getPersistentLog().warn("Can't sync user with Hub: " + e.getMessage(), e);
                }
                this.this$0.setStatus(this.$total + " users synced");
            }
            {
                this.this$0 = syncUsersWithHubJob;
                this.$ringUsers = collection;
                this.$count = intRef;
                this.$batchSize = n;
                this.$total = n2;
                super(1);
            }
        }));
    }

    public SyncUsersWithHubJob() {
        super("Hub data sync job");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/ring/maintenance/SyncUsersWithHubJob$Companion;", "Lmu/KLogging;", "()V", "RING_PAGE_SIZE", "", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

