/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.persistence.quickfix;

import java.util.Collection;
import java.util.Iterator;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.jetpass.dao.remote.api.security.RemoteProjectDAO;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.sequence.Sequence;
import jetbrains.youtrack.api.ring.HubExportResult;
import jetbrains.youtrack.core.legacy.LegacyStoreContainer;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.export.FailureExportResult;
import jetbrains.youtrack.ring.export.SuccessExportResult;
import jetbrains.youtrack.ring.export.dto.ProjectDtoBuilder;
import jetbrains.youtrack.ring.persistence.BeansKt;
import jetbrains.youtrack.ring.persistence.quickfix.XdHubMappingQuickFix;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlinx.dnq.LinkDelegatesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdNaturalEntityType;
import kotlinx.dnq.link.OnDeletePolicy;
import kotlinx.dnq.link.XdToOneRequiredLink;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import kotlinx.dnq.store.container.StoreContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u0013*\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/ring/persistence/quickfix/XdResourceLocationQuickFix;", "Ljetbrains/youtrack/ring/persistence/quickfix/XdHubMappingQuickFix;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "<set-?>", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "project", "getProject", "()Ljetbrains/youtrack/core/persistent/issue/XdProject;", "setProject", "(Ljetbrains/youtrack/core/persistent/issue/XdProject;)V", "project$delegate", "Lkotlinx/dnq/link/XdToOneRequiredLink;", "apply", "Ljetbrains/youtrack/api/ring/HubExportResult;", "moveProject", "", "hasYouTrackResourceSiblings", "", "Ljetbrains/jetpass/api/security/Resource;", "targetId", "", "Companion", "youtrack-ring-integration"})
public final class XdResourceLocationQuickFix
extends XdHubMappingQuickFix {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final XdToOneRequiredLink project$delegate;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdResourceLocationQuickFix.class), "project", "getProject()Ljetbrains/youtrack/core/persistent/issue/XdProject;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final XdProject getProject() {
        return (XdProject)this.project$delegate.getValue((XdEntity)this, $$delegatedProperties[0]);
    }

    public final void setProject(@NotNull XdProject xdProject) {
        Intrinsics.checkParameterIsNotNull((Object)xdProject, (String)"<set-?>");
        this.project$delegate.setValue((XdEntity)this, $$delegatedProperties[0], (XdEntity)xdProject);
    }

    @Override
    @NotNull
    public HubExportResult apply() {
        HubExportResult hubExportResult;
        try {
            String uuid2 = EntityExtensionsKt.getHubUuidNotNull((XdEntity)this.getProject());
            Resource resource = (Resource)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getResourceDAO().get(uuid2);
            Resource resource2 = resource;
            if (Intrinsics.areEqual((Object)(resource2 != null && (resource2 = resource2.getProject()) != null ? resource2.isGlobal() : null), (Object)true)) {
                this.moveProject();
            } else if (this.hasYouTrackResourceSiblings(resource, uuid2)) {
                this.moveProject();
            } else if (jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectDAO().getByName(this.getProject().getName()).isNotEmpty()) {
                this.moveProject();
            } else {
                Resource resource3;
                ProjectJSON json = new ProjectJSON();
                json.setName(this.getProject().getName());
                jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectDAO().update((resource3 = resource) != null && (resource3 = resource3.getProject()) != null ? resource3.getId() : null, (IdItem)json);
            }
            hubExportResult = new SuccessExportResult(uuid2, "Project " + this.getProject().getName() + " has been moved to the corresponding Hub project");
        }
        catch (Exception e) {
            hubExportResult = new FailureExportResult("Failed to apply Hub resource location quickfix", e);
        }
        return hubExportResult;
    }

    private final boolean hasYouTrackResourceSiblings(@Nullable Resource $this$hasYouTrackResourceSiblings, String targetId) {
        boolean bl;
        block5: {
            Object object = $this$hasYouTrackResourceSiblings;
            if (object != null && (object = object.getProject()) != null && (object = object.getResources()) != null) {
                Object $this$any$iv = object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv = iterator2.next();
                        Resource it = (Resource)element$iv;
                        boolean bl2 = false;
                        Resource resource = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)resource, (String)"it");
                        Service service = resource.getService();
                        Intrinsics.checkExpressionValueIsNotNull((Object)service, (String)"it.service");
                        if (!(Intrinsics.areEqual((Object)service.getId(), (Object)BeansKt.getRingSettings().getServiceId()) && Intrinsics.areEqual((Object)it.getId(), (Object)targetId) ^ true)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void moveProject() {
        String string;
        Sequence hubProjects = jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectDAO().getByName(this.getProject().getName());
        if (hubProjects.isNotEmpty()) {
            Project project = (Project)hubProjects.first();
            string = project != null ? project.getId() : null;
        } else {
            string = ((Project)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectDAO().create((IdItem)new ProjectDtoBuilder().buildProject(this.getProject()))).getId();
        }
        String projectId = string;
        RemoteProjectDAO remoteProjectDAO = jetbrains.youtrack.ring.client.BeansKt.getRingApi().getProjectDAO();
        String string2 = projectId;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        remoteProjectDAO.addResource(string2, EntityExtensionsKt.getHubUuidNotNull((XdEntity)this.getProject()));
    }

    public XdResourceLocationQuickFix(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        super(entity);
        this.project$delegate = (XdToOneRequiredLink)LinkDelegatesKt.xdLink1$default((XdEntityType)((XdEntityType)XdProject.Companion), null, null, (OnDeletePolicy)((OnDeletePolicy)OnDeletePolicy.CASCADE.INSTANCE), (int)6, null).provideDelegate((XdEntity)this, $$delegatedProperties[0]);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/ring/persistence/quickfix/XdResourceLocationQuickFix$Companion;", "Lkotlinx/dnq/XdNaturalEntityType;", "Ljetbrains/youtrack/ring/persistence/quickfix/XdResourceLocationQuickFix;", "()V", "new", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "youtrack-ring-integration"})
    public static final class Companion
    extends XdNaturalEntityType<XdResourceLocationQuickFix> {
        @NotNull
        public final XdResourceLocationQuickFix new(@NotNull XdProject project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Iterable $this$forEach$iv = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdResourceLocationQuickFix, XdSearchingNode>(project){
                final /* synthetic */ XdProject $project;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdResourceLocationQuickFix it) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    return $this$filter.eq((XdEntity)it.getProject(), (XdEntity)this.$project);
                }
                {
                    this.$project = xdProject;
                    super(2);
                }
            })));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XdResourceLocationQuickFix it = (XdResourceLocationQuickFix)((Object)element$iv);
                boolean bl = false;
                it.delete();
            }
            return (XdResourceLocationQuickFix)Companion.new((Function1)new Function1<XdResourceLocationQuickFix, Unit>(project){
                final /* synthetic */ XdProject $project;

                public final void invoke(@NotNull XdResourceLocationQuickFix $this$new) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                    $this$new.setProject(this.$project);
                }
                {
                    this.$project = xdProject;
                    super(1);
                }
            });
        }

        private Companion() {
            super("ResourceLocationQuickFix", (StoreContainer)LegacyStoreContainer.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

