/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.sync;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.gaprest.BeansKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/ring/sync/HubImportSynchronizer;", "", "()V", "usersInCreation", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlin/Pair;", "Ljava/util/concurrent/CountDownLatch;", "", "doImport", "T", "spec", "Ljetbrains/youtrack/ring/sync/HubImportSynchronizer$ImportSpec;", "(Ljetbrains/youtrack/ring/sync/HubImportSynchronizer$ImportSpec;)Ljava/lang/Object;", "getLock", "", "uuid", "purgeExpiredCachedLocks", "", "releaseLock", "Companion", "ImportSpec", "youtrack-ring-integration"})
public final class HubImportSynchronizer {
    private final ConcurrentHashMap<String, Pair<CountDownLatch, Long>> usersInCreation = new ConcurrentHashMap();
    private static final long CACHE_RECORD_TTL;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T doImport(@NotNull ImportSpec<? extends T> spec) {
        Intrinsics.checkParameterIsNotNull(spec, (String)"spec");
        this.purgeExpiredCachedLocks();
        if (this.getLock(spec.getKey())) {
            try {
                T t = spec.doImport();
                return t;
            }
            finally {
                LegacySupportKt.flush();
                this.releaseLock(spec.getKey());
            }
        }
        TransientStoreSession transientStoreSession = BeansKt.getTransientEntityStore().getThreadSession();
        if (transientStoreSession == null) {
            Intrinsics.throwNpe();
        }
        if (transientStoreSession.hasChanges()) {
            LegacySupportKt.flush();
        } else {
            LegacySupportKt.revert();
        }
        T t = spec.findAlreadyImported();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    private final boolean getLock(String uuid2) {
        boolean bl;
        Pair<CountDownLatch, Long> latch = this.usersInCreation.putIfAbsent(uuid2, (Pair<CountDownLatch, Long>)new Pair((Object)new CountDownLatch(1), (Object)System.currentTimeMillis()));
        if (latch == null) {
            bl = true;
        } else {
            try {
                ((CountDownLatch)latch.getFirst()).await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Companion.getLogger().warn("Interrupted while waiting for Hub user to be synced", (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }

    private final void releaseLock(String uuid2) {
        block0: {
            Pair<CountDownLatch, Long> lock = this.usersInCreation.get(uuid2);
            Object object = lock;
            if (object == null || (object = (CountDownLatch)object.getFirst()) == null) break block0;
            ((CountDownLatch)object).countDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void purgeExpiredCachedLocks() {
        long now = System.currentTimeMillis();
        Object object = this.usersInCreation;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void key;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl2 = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Pair value = (Pair)entry2.getValue();
            if (now - ((Number)value.getSecond()).longValue() <= CACHE_RECORD_TTL) continue;
            this.usersInCreation.remove(key);
        }
    }

    static {
        Companion = new Companion(null);
        CACHE_RECORD_TTL = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\n\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/ring/sync/HubImportSynchronizer$ImportSpec;", "T", "", "key", "", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "doImport", "()Ljava/lang/Object;", "findAlreadyImported", "youtrack-ring-integration"})
    public static abstract class ImportSpec<T> {
        @NotNull
        private final String key;

        public abstract T doImport();

        @Nullable
        public abstract T findAlreadyImported();

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public ImportSpec(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            this.key = key;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/ring/sync/HubImportSynchronizer$Companion;", "Lmu/KLogging;", "()V", "CACHE_RECORD_TTL", "", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

