/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.sync;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.servlet.http.HttpServletRequest;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.ring.client.BeansKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/ring/sync/RedirectUriRegistry;", "", "()V", "baseUrls", "", "", "client", "Ljetbrains/jetpass/client/accounts/ServiceClient;", "getClient", "()Ljetbrains/jetpass/client/accounts/ServiceClient;", "ensureRedirectUriExists", "", "req", "Ljavax/servlet/http/HttpServletRequest;", "uri", "shouldAppendPortToRedirectUri", "", "updateRedirectUris", "uris", "updateServiceRedirectUris", "newBaseUrl", "Companion", "youtrack-ring-integration"})
public final class RedirectUriRegistry {
    private volatile Set<String> baseUrls = new HashSet();
    public static final Companion Companion = new Companion(null);

    private final ServiceClient getClient() {
        return BeansKt.getHubClient().getAccountsClient().getServiceClient();
    }

    public final void ensureRedirectUriExists(@NotNull HttpServletRequest req) {
        Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
        StringBuilder builder = new StringBuilder(req.getScheme());
        builder.append("://").append(req.getServerName());
        if (this.shouldAppendPortToRedirectUri(req)) {
            builder.append(":").append(req.getServerPort());
        }
        String string = req.getContextPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"req.contextPath");
        CharSequence charSequence = string;
        boolean bl = false;
        if (charSequence.length() > 0) {
            builder.append(req.getContextPath());
        }
        String string2 = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.toString()");
        this.ensureRedirectUriExists(string2);
    }

    public final void ensureRedirectUriExists(@NotNull String uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        try {
            if (!this.baseUrls.contains(uri)) {
                this.updateServiceRedirectUris(uri);
            }
        }
        catch (Exception e) {
            Companion.getLogger().warn("Failed to register redirect uri in Hub", (Throwable)e);
        }
    }

    public final void updateRedirectUris(@NotNull Set<String> uris) {
        Intrinsics.checkParameterIsNotNull(uris, (String)"uris");
        this.baseUrls = new ConcurrentSkipListSet(uris);
    }

    public final synchronized void updateServiceRedirectUris(@NotNull String newBaseUrl) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)newBaseUrl, (String)"newBaseUrl");
        Service service = (Service)BeansKt.getRingApi().getServiceDAO().get(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
        Set set2 = SetsKt.mutableSetOf((Object[])new String[]{newBaseUrl});
        RedirectUriRegistry redirectUriRegistry = this;
        boolean bl = false;
        boolean bl2 = false;
        Set $this$apply = set2;
        boolean bl3 = false;
        Collection collection = $this$apply;
        Object object = service;
        if (object == null || (object = object.getBaseUrls()) == null) {
            Collection collection2 = collection;
            boolean bl4 = false;
            List list = CollectionsKt.emptyList();
            collection = collection2;
            object = list;
        }
        CollectionsKt.addAll((Collection)collection, (Iterable)object);
        redirectUriRegistry.baseUrls = set = set2;
        ServiceJSON updatedService = new ServiceJSON();
        updatedService.setBaseUrls((Iterable)this.baseUrls);
        ServiceClient serviceClient = this.getClient();
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        serviceClient.updateService(string, updatedService);
    }

    private final boolean shouldAppendPortToRedirectUri(HttpServletRequest req) {
        return !(StringsKt.equals((String)"http", (String)req.getScheme(), (boolean)true) && req.getServerPort() == 80 || StringsKt.equals((String)"https", (String)req.getScheme(), (boolean)true) && req.getServerPort() == 443);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/sync/RedirectUriRegistry$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

