/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.sync;

import com.intellij.hub.core.data.uri.DataURI;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.youtrack.core.persistent.XdPersistentFile;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.persistent.XdUserGroupExtKt;
import jetbrains.youtrack.ring.EntityExtensionsKt;
import jetbrains.youtrack.ring.client.BeansKt;
import jetbrains.youtrack.ring.sync.MergeIterable;
import jetbrains.youtrack.ring.sync.RingGroupMerger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\b\u0010\u000b\u001a\u0004\u0018\u00010\tJ\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\tH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/ring/sync/RingGroup;", "", "hubGroupUuid", "", "(Ljava/lang/String;)V", "remoteGroup", "Ljetbrains/jetpass/api/authority/UserGroup;", "(Ljetbrains/jetpass/api/authority/UserGroup;)V", "createGroup", "Ljetbrains/youtrack/core/persistent/user/XdUserGroup;", "name", "resolve", "syncGroupDetails", "localGroup", "Companion", "youtrack-ring-integration"})
public final class RingGroup {
    private final UserGroup remoteGroup;
    @NotNull
    private static final FieldPartial<Partial.UserGroup> SYNC_PARTIAL;
    public static final Companion Companion;

    @Nullable
    public final XdUserGroup resolve() {
        XdUserGroup xdUserGroup;
        if (this.remoteGroup == null) {
            return null;
        }
        MergeIterable.GroupIterable resolved = MergeIterable.Companion.group(this.remoteGroup);
        if (!resolved.iterator().hasNext()) {
            String string = this.remoteGroup.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            xdUserGroup = this.createGroup(string);
        } else {
            xdUserGroup = new RingGroupMerger().merge(resolved);
        }
        XdUserGroup target = xdUserGroup;
        EntityExtensionsKt.setHubUuid((XdEntity)target, this.remoteGroup.getId());
        return Intrinsics.areEqual((Object)target, (Object)jetbrains.charisma.persistent.BeansKt.getXdAllUsersGroup()) ? jetbrains.charisma.persistent.BeansKt.getXdAllUsersGroup() : this.syncGroupDetails(this.remoteGroup, target);
    }

    private final XdUserGroup createGroup(String name) {
        XdUserGroup xdUserGroup = (XdUserGroup)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdUserGroup.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdUserGroup, XdSearchingNode>(name){
            final /* synthetic */ String $name;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdUserGroup it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$name));
            }
            {
                this.$name = string;
                super(2);
            }
        })));
        if (xdUserGroup == null) {
            xdUserGroup = XdUserGroup.Companion.new$default((XdUserGroup.Companion)XdUserGroup.Companion, (String)name, null, (int)2, null);
        }
        return xdUserGroup;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final XdUserGroup syncGroupDetails(UserGroup remoteGroup, XdUserGroup localGroup2) {
        if (Intrinsics.areEqual((Object)remoteGroup.getName(), (Object)localGroup2.getName()) ^ true) {
            if (XdQueryKt.isEmpty((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdUserGroup.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdUserGroup, XdSearchingNode>(remoteGroup){
                final /* synthetic */ UserGroup $remoteGroup;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdUserGroup it) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$remoteGroup.getName()));
                }
                {
                    this.$remoteGroup = userGroup;
                    super(2);
                }
            })))) {
                String string = remoteGroup.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"remoteGroup.name");
                localGroup2.setName(string);
            } else {
                Companion.getLogger().warn("User Group name " + remoteGroup.getName() + " is not unique in YouTrack and won't be applied");
            }
        }
        localGroup2.setDescription(remoteGroup.getDescription());
        EntityExtensionsKt.setHubUuid((XdEntity)localGroup2, remoteGroup.getId());
        String iconUrl = remoteGroup.getIconUrl();
        if (iconUrl != null) {
            CharSequence charSequence = iconUrl;
            boolean bl = false;
            if (charSequence.length() > 0) {
                try {
                    DataURI dataURI = new DataURI(iconUrl);
                    XdUserGroupExtKt.setIcon((XdUserGroup)localGroup2, (XdPersistentFile)((XdPersistentFile)XdPersistentFile.Companion.new((Function1)new Function1<XdPersistentFile, Unit>(dataURI){
                        final /* synthetic */ DataURI $dataURI;

                        public final void invoke(@NotNull XdPersistentFile $this$new) {
                            Intrinsics.checkParameterIsNotNull((Object)$this$new, (String)"$receiver");
                            $this$new.setContent((InputStream)new ByteArrayInputStream(this.$dataURI.getContent()));
                            $this$new.setName("group.img");
                            $this$new.setMimeType(this.$dataURI.getMimeType());
                        }
                        {
                            this.$dataURI = dataURI;
                            super(1);
                        }
                    })));
                    return localGroup2;
                }
                catch (IllegalArgumentException e) {
                    Companion.getLogger().warn("Can't import group icon for group " + localGroup2.getName(), (Throwable)e);
                    return localGroup2;
                }
            }
        }
        XdUserGroupExtKt.setIcon((XdUserGroup)localGroup2, (XdPersistentFile)null);
        return localGroup2;
    }

    public RingGroup(@Nullable UserGroup remoteGroup) {
        this.remoteGroup = remoteGroup;
    }

    public RingGroup(@NotNull String hubGroupUuid) {
        Intrinsics.checkParameterIsNotNull((Object)hubGroupUuid, (String)"hubGroupUuid");
        this((UserGroup)BeansKt.getHubClient().getAccountsClient().getUserGroupClient().getUserGroup(hubGroupUuid, SYNC_PARTIAL));
    }

    static {
        Companion = new Companion(null);
        Partial partial = Partial.userGroup((Partial.UserGroup[])new Partial.UserGroup[]{Partial.UserGroup.ID, Partial.UserGroup.ALIASES((Partial.Alias[])new Partial.Alias[]{Partial.Alias.ID, Partial.Alias.ACTION}), Partial.UserGroup.NAME, Partial.UserGroup.DESCRIPTION, Partial.UserGroup.ICON_URL, Partial.UserGroup.AUTO_JOIN});
        Intrinsics.checkExpressionValueIsNotNull((Object)partial, (String)"Partial.userGroup(Partia\u2026tial.UserGroup.AUTO_JOIN)");
        SYNC_PARTIAL = (FieldPartial)partial;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/ring/sync/RingGroup$Companion;", "Lmu/KLogging;", "()V", "SYNC_PARTIAL", "Ljetbrains/jetpass/client/FieldPartial;", "Ljetbrains/jetpass/client/accounts/Partial$UserGroup;", "getSYNC_PARTIAL", "()Ljetbrains/jetpass/client/FieldPartial;", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final FieldPartial<Partial.UserGroup> getSYNC_PARTIAL() {
            return SYNC_PARTIAL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

