/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.sync;

import java.util.Locale;
import jetbrains.jetpass.api.authority.Profile;
import jetbrains.jetpass.api.authority.User;
import jetbrains.mps.internationalization.runtime.LocaleEntry;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/ring/sync/RingUserDetailsSync;", "", "()V", "syncContacts", "", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "remoteUser", "Ljetbrains/jetpass/api/authority/User;", "syncGuestDetails", "localUser", "syncLocale", "syncLogin", "hubLogin", "", "syncUserDetails", "Companion", "youtrack-ring-integration"})
public final class RingUserDetailsSync {
    public static final Companion Companion = new Companion(null);

    public final void syncUserDetails(@NotNull XdUser localUser, @NotNull User remoteUser) {
        Intrinsics.checkParameterIsNotNull((Object)localUser, (String)"localUser");
        Intrinsics.checkParameterIsNotNull((Object)remoteUser, (String)"remoteUser");
        Companion.getLogger().trace("Syncing user data: " + localUser.getLogin());
        this.syncLogin(localUser, remoteUser.getLogin());
        this.syncContacts(localUser, remoteUser);
        if (remoteUser.getName() != null) {
            String string = remoteUser.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"remoteUser.name");
            localUser.setFullName(string);
        }
        if (remoteUser.isBanned() != null) {
            Boolean bl = remoteUser.isBanned();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"remoteUser.isBanned");
            localUser.setBanned(bl.booleanValue());
        }
    }

    public final void syncGuestDetails(@NotNull XdUser localUser, @NotNull User remoteUser) {
        Intrinsics.checkParameterIsNotNull((Object)localUser, (String)"localUser");
        Intrinsics.checkParameterIsNotNull((Object)remoteUser, (String)"remoteUser");
        Companion.getLogger().trace("Syncing user data: guest");
        if (remoteUser.isBanned() != null) {
            Boolean bl = remoteUser.isBanned();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"remoteUser.isBanned");
            localUser.setBanned(bl.booleanValue());
        }
    }

    private final void syncLogin(XdUser user2, String hubLogin) {
        if (hubLogin == null) {
            Companion.getLogger().warn("Received null login for user " + user2.getLogin() + " from Hub. Local login will be preserved.");
        } else if (Intrinsics.areEqual((Object)hubLogin, (Object)user2.getLogin()) ^ true) {
            if (XdQueryKt.isEmpty((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdUser.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdUser, XdSearchingNode>(hubLogin){
                final /* synthetic */ String $hubLogin;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdUser it) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return $this$filter.eq((Comparable)((Object)it.getLogin()), (Comparable)((Object)this.$hubLogin));
                }
                {
                    this.$hubLogin = string;
                    super(2);
                }
            })))) {
                user2.setLogin(hubLogin);
            } else {
                Companion.getLogger().warn("Cannnot update login field for user " + user2.getLogin() + ". Login value from Hub (" + hubLogin + ") is not unique.");
            }
        }
    }

    private final void syncContacts(XdUser user2, User remoteUser) {
        Profile profile = remoteUser.getProfile();
        user2.setEmail(profile != null && (profile = profile.getEmail()) != null ? profile.getEmail() : null);
        Profile profile2 = remoteUser.getProfile();
        user2.setJabberAccountName(profile2 != null && (profile2 = profile2.getJabber()) != null ? profile2.getJabber() : null);
    }

    public final void syncLocale(@NotNull XdUser user2, @NotNull User remoteUser) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)remoteUser, (String)"remoteUser");
        if (remoteUser.getProfile() != null) {
            Profile profile = remoteUser.getProfile();
            Intrinsics.checkExpressionValueIsNotNull((Object)profile, (String)"remoteUser.profile");
            jetbrains.jetpass.api.settings.Locale hubLocale = profile.getLocale();
            if (hubLocale != null) {
                Object v4;
                block5: {
                    Iterable iterable = BeansKt.getLocalizer().getSupportedLocales();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"localizer.supportedLocales");
                    Iterable $this$firstOrNull$iv = iterable;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        LocaleEntry it = (LocaleEntry)element$iv;
                        boolean bl = false;
                        LocaleEntry localeEntry = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)localeEntry, (String)"it");
                        Locale locale = localeEntry.getLocale();
                        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"it.locale");
                        if (!Intrinsics.areEqual((Object)locale.getLanguage(), (Object)hubLocale.getLanguage())) continue;
                        v4 = element$iv;
                        break block5;
                    }
                    v4 = null;
                }
                LocaleEntry localeEntry = v4;
                if (localeEntry == null) {
                    Companion.getLogger().warn("Can't sync locale for user " + user2.getLogin() + ". No matching YouTrack locale found for Hub language [" + hubLocale.getLanguage() + ']');
                } else {
                    jetbrains.charisma.service.BeansKt.getUserProfileService().getGeneralUserProfile(user2).setLocale(localeEntry.getLocale());
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/sync/RingUserDetailsSync$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

