/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.sync.service;

import java.util.List;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.UriBuilder;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.ring.sync.service.RingService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/ring/sync/service/SlackIntegrationService;", "Ljetbrains/youtrack/ring/sync/service/RingService;", "()V", "key", "", "getKey", "()Ljava/lang/String;", "secret", "getSecret", "url", "kotlin.jvm.PlatformType", "uuid", "getUuid", "getService", "Ljetbrains/jetpass/api/Service;", "isRegistered", "", "register", "", "toDto", "Ljetbrains/jetpass/rest/dto/ServiceJSON;", "update", "updateVendorData", "serviceId", "serviceSecret", "Companion", "youtrack-ring-integration"})
public final class SlackIntegrationService
implements RingService {
    private final String url = ConfigurationParameter.getParameter((String)"jetbrains.youtrack.konnector.url", (String)"https://konnector.services.jetbrains.com");
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getKey() {
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getKonnectorKey();
        if (string == null) {
            string = "service-is-disabled";
        }
        return string;
    }

    @Override
    @NotNull
    public String getUuid() {
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getKonnectorServiceId();
        if (string == null) {
            string = "service-is-disabled";
        }
        return string;
    }

    @Override
    @NotNull
    public String getSecret() {
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getKonnectorSecret();
        if (string == null) {
            string = "service-is-disabled";
        }
        return string;
    }

    @Override
    public boolean isRegistered() {
        return this.getService() != null;
    }

    @Override
    public void register() {
        jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().setKonnectorSecret(UUID.randomUUID().toString());
        jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().setKonnectorServiceId(this.getClient().createService(this.toDto(), null).getId());
        this.updateVendorData(this.getUuid(), this.getSecret());
    }

    @Override
    public void update() {
        Service service = this.getService();
        if (service == null) {
            this.register();
        } else {
            try {
                this.getClient().updateService(this.getUuid(), this.toDto());
                this.updateVendorData(this.getUuid(), this.getSecret());
            }
            catch (WebApplicationException e) {
                String response = (String)e.getResponse().readEntity(String.class);
                Companion.getLogger().warn("Slack Integration service id/secret mismatch. The service will be recreated.");
                Companion.getLogger().warn(response, (Throwable)e);
                ServiceClient serviceClient = this.getClient();
                String string = service.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"service.id");
                ServiceClient.deleteService$default((ServiceClient)serviceClient, (String)string, null, (int)2, null);
                this.register();
            }
        }
    }

    private final ServiceJSON toDto() {
        ServiceJSON service = new ServiceJSON();
        service.setId(this.getUuid());
        service.setKey(this.getKey());
        service.setSecret(this.getSecret());
        service.setTrusted(Boolean.valueOf(true));
        service.setHomeUrl(this.url);
        service.setName(BeansKt.getCentralManager().getApplicationName() + " Slack Integration");
        service.setIconUrl(this.getYouTrackIconDataUri());
        service.setRedirectUris((Iterable)CollectionsKt.listOf((Object)UriBuilder.fromPath((String)this.url).path("ring").path("oauth").build(new Object[0]).toString()));
        return service;
    }

    private final void updateVendorData(String serviceId, String serviceSecret) {
        BaseAccountsClient client2 = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAccountsClient().getHubClient().getAccountsClient(serviceId, serviceSecret, new String[0]);
        ServiceJSON service = new ServiceJSON();
        service.setApplicationName("YouTrack Slack Integration");
        service.setVersion(RingService.Companion.getVERSION());
        service.setVendor("JetBrains");
        service.setReleaseDate(RingService.Companion.getRELEASE_DATE());
        client2.getServiceClient().updateService(serviceId, service);
    }

    private final Service getService() {
        Filter filter = new Filter(null, 1, null);
        filter.query("key: " + this.getKey());
        return (Service)CollectionsKt.firstOrNull((List)this.getClient().getServicePage((BaseFilter)filter, null).getServices());
    }

    @Override
    @NotNull
    public ServiceClient getClient() {
        return RingService.DefaultImpls.getClient(this);
    }

    @Override
    @Nullable
    public String getYouTrackIconDataUri() {
        return RingService.DefaultImpls.getYouTrackIconDataUri(this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/ring/sync/service/SlackIntegrationService$Companion;", "Lmu/KLogging;", "()V", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

