/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.ring.sync.service;

import java.util.Collection;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.settings.LicenseSettings;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.pojo.api.ServiceImpl;
import jetbrains.jetpass.pojo.api.settings.LicenseSettingsImpl;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.ring.client.ConnectionTestResult;
import jetbrains.youtrack.ring.rest.BeansKt;
import jetbrains.youtrack.ring.sync.service.RingService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import webr.framework.controller.BaseApplication;
import webr.framework.url.UrlUtil;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u0004H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u0016\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/ring/sync/service/YouTrackService;", "Ljetbrains/youtrack/ring/sync/service/RingService;", "()V", "key", "", "getKey", "()Ljava/lang/String;", "secret", "getSecret", "uuid", "getUuid", "ensureBaseUrls", "", "getServiceHomeUrl", "getServiceJsonForCreate", "Ljetbrains/jetpass/rest/dto/ServiceJSON;", "getServiceJsonForUpdate", "isRegistered", "", "normalizeUrl", "url", "register", "update", "Companion", "youtrack-ring-integration"})
public final class YouTrackService
implements RingService {
    @NotNull
    private static final Partial<Partial.Service> REGISTER_PARTIAL;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getUuid() {
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Override
    @NotNull
    public String getSecret() {
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getSecret();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.getUuid();
    }

    @Override
    public boolean isRegistered() {
        return Intrinsics.areEqual((Object)jetbrains.youtrack.ring.client.BeansKt.getHubClientFactory().testConnection(), (Object)ConnectionTestResult.Companion.getSERVICE_NOT_REGISTERED()) ^ true;
    }

    @Override
    public void register() {
        ServiceClient client2 = jetbrains.youtrack.ring.client.BeansKt.getHubClient().getAnonymousAccountsClient().getServiceClient();
        ServiceJSON created = client2.createService(this.getServiceJsonForCreate(), (FieldPartial)REGISTER_PARTIAL);
        jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().setServiceId(created.getId());
        jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().setSecret(created.getSecret());
        LegacySupportKt.flush();
        this.ensureBaseUrls();
    }

    @Override
    public void update() {
        Object object;
        boolean bl;
        Object object2;
        LicenseSettings hubLicenseSettings = jetbrains.youtrack.ring.client.BeansKt.getRingApi().getSettingsDAO().getLicenseSettings();
        if (jetbrains.youtrack.config.BeansKt.getRingConfig().hasEmbeddedHub()) {
            Service service = hubLicenseSettings.getService();
            if (service == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)service, (String)"hubLicenseSettings.service!!");
            if (Intrinsics.areEqual((Object)service.getId(), (Object)jetbrains.youtrack.ring.impl.BeansKt.getHubServiceUuid())) {
                object2 = new ServiceImpl();
                boolean bl2 = false;
                bl = false;
                Object $this$apply22 = object2;
                boolean bl3 = false;
                $this$apply22.setId(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
                $this$apply22.setApplicationName("YouTrack");
                Object youtrackService = object2;
                jetbrains.youtrack.ring.client.BeansKt.getRingApi().getServiceDAO().update(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId(), (IdItem)youtrackService);
                LicenseSettingsImpl licenseSettingsImpl = new LicenseSettingsImpl();
                bl = false;
                boolean $this$apply22 = false;
                LicenseSettingsImpl $this$apply = licenseSettingsImpl;
                boolean bl4 = false;
                $this$apply.setService((Service)youtrackService);
                $this$apply.setLicenseName(jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getUsername());
                $this$apply.setLicenseKey(jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getLicense());
                LicenseSettingsImpl licenseSettings = licenseSettingsImpl;
                jetbrains.youtrack.ring.client.BeansKt.getRingApi().getSettingsDAO().update(hubLicenseSettings.getId(), (IdItem)licenseSettings);
            }
        }
        if (jetbrains.youtrack.config.BeansKt.getRingConfig().hasEmbeddedHub()) {
            UserGroupJSON allUsers = new UserGroupJSON(jetbrains.youtrack.ring.client.BeansKt.getRingApi().getUserGroupDAO().getRootUserGroup());
            Service service = (Service)jetbrains.youtrack.ring.client.BeansKt.getRingApi().getServiceDAO().get(this.getUuid());
            if (service != null) {
                object2 = service;
                boolean bl5 = false;
                bl = false;
                Object it = object2;
                boolean bl6 = false;
                this.getClient().getViewersClient(this.getUuid()).addViewer((AuthorityHolderJSON)allUsers, null);
            }
        }
        ServiceJSON json = this.getServiceJsonForUpdate();
        Iterable iterable = json.getRedirectUris();
        if (iterable == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"json.redirectUris!!");
        object2 = CollectionsKt.toMutableSet((Iterable)iterable);
        ServiceJSON serviceJSON = json;
        boolean bl7 = false;
        bl = false;
        Object it = object2;
        boolean bl8 = false;
        Collection collection = (Collection)it;
        ServiceClient serviceClient = this.getClient();
        String string = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if ((object = serviceClient.getService(string, null)) == null || (object = object.getRedirectUris()) == null) {
            Collection collection2 = collection;
            boolean bl9 = false;
            Set set = SetsKt.emptySet();
            collection = collection2;
            object = set;
        }
        CollectionsKt.addAll((Collection)collection, (Iterable)object);
        Object object3 = object2;
        serviceJSON.setRedirectUris((Iterable)CollectionsKt.sorted((Iterable)((Iterable)object3)));
        ServiceClient serviceClient2 = this.getClient();
        String string2 = jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        serviceClient2.updateService(string2, json);
        this.ensureBaseUrls();
    }

    private final ServiceJSON getServiceJsonForCreate() {
        ServiceJSON service = this.getServiceJsonForUpdate();
        service.setName(jetbrains.youtrack.config.BeansKt.getCentralManager().getApplicationName());
        return service;
    }

    private final ServiceJSON getServiceJsonForUpdate() {
        ServiceJSON serviceJSON = new ServiceJSON();
        boolean bl = false;
        boolean bl2 = false;
        ServiceJSON $this$apply = serviceJSON;
        boolean bl3 = false;
        $this$apply.setId(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getServiceId());
        $this$apply.setSecret(jetbrains.youtrack.ring.persistence.BeansKt.getRingSettings().getSecret());
        $this$apply.setHomeUrl(this.getServiceHomeUrl());
        $this$apply.setApplicationName("YouTrack");
        $this$apply.setVersion(RingService.Companion.getVERSION());
        $this$apply.setVendor("JetBrains");
        $this$apply.setIconUrl(this.getYouTrackIconDataUri());
        $this$apply.setReleaseDate(RingService.Companion.getRELEASE_DATE());
        $this$apply.setUserUriPattern("./users/:id");
        $this$apply.setGroupUriPattern("");
        $this$apply.setRedirectUris((Iterable)CollectionsKt.listOf((Object[])new String[]{"./admin/hub", "./oauth"}));
        LicenseJSON licenseJSON = new LicenseJSON();
        ServiceJSON serviceJSON2 = $this$apply;
        boolean bl4 = false;
        boolean bl5 = false;
        LicenseJSON $this$apply2 = licenseJSON;
        boolean bl6 = false;
        $this$apply2.setLicenseName(jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getUsername());
        $this$apply2.setLicenseKey(jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getLicense());
        LicenseJSON licenseJSON2 = licenseJSON;
        serviceJSON2.setLicenseSettings(licenseJSON2);
        return serviceJSON;
    }

    private final void ensureBaseUrls() {
        block1: {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            String string2 = jetbrains.charisma.persistent.BeansKt.getXdNotificationsConfig().getBaseUrl();
            if (string2 != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl3 = false;
                BeansKt.getRedirectUriRegistry().ensureRedirectUriExists(it);
            }
            HttpServletRequest httpServletRequest = BaseApplication.getRequest();
            if (httpServletRequest == null) break block1;
            string = httpServletRequest;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl4 = false;
            BeansKt.getRedirectUriRegistry().ensureRedirectUriExists((HttpServletRequest)it);
        }
    }

    private final String getServiceHomeUrl() {
        String homeUrl;
        String string;
        String string2;
        try {
            String string3 = jetbrains.charisma.persistent.BeansKt.getXdNotificationsConfig().getBaseUrl();
            if (string3 == null) {
                string3 = UrlUtil.getGlobalBaseUrl();
            }
            string2 = string3;
        }
        catch (Exception e) {
            Companion.getLogger().warn("Unable to compute home URL for YouTrack service, falling back to 127.0.0.1", (Throwable)e);
            string2 = null;
        }
        if ((string = (homeUrl = string2)) == null) {
            string = "http://127.0.0.1";
        }
        return this.normalizeUrl(string);
    }

    private final String normalizeUrl(String url) {
        return StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null) ? url : "http://" + url;
    }

    static {
        Companion = new Companion(null);
        Partial partial = Partial.service((Partial.Service[])new Partial.Service[]{Partial.Service.ID, Partial.Service.SECRET});
        Intrinsics.checkExpressionValueIsNotNull((Object)partial, (String)"Partial.service(Partial.\u2026, Partial.Service.SECRET)");
        REGISTER_PARTIAL = partial;
    }

    @Override
    @NotNull
    public ServiceClient getClient() {
        return RingService.DefaultImpls.getClient(this);
    }

    @Override
    @Nullable
    public String getYouTrackIconDataUri() {
        return RingService.DefaultImpls.getYouTrackIconDataUri(this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/ring/sync/service/YouTrackService$Companion;", "Lmu/KLogging;", "()V", "REGISTER_PARTIAL", "Ljetbrains/jetpass/client/accounts/Partial;", "Ljetbrains/jetpass/client/accounts/Partial$Service;", "getREGISTER_PARTIAL", "()Ljetbrains/jetpass/client/accounts/Partial;", "youtrack-ring-integration"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final Partial<Partial.Service> getREGISTER_PARTIAL() {
            return REGISTER_PARTIAL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

