/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.extensions;

import jetbrains.charisma.persistent.issueFolders.BeansKt;
import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.annotations.ApiDocReturns;
import jetbrains.youtrack.core.annotations.ApiMethod;
import jetbrains.youtrack.core.annotations.ApiScope;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.persistent.XdIssueTag;
import jetbrains.youtrack.persistent.XdIssueTagKt;
import jetbrains.youtrack.persistent.XdSavedQuery;
import jetbrains.youtrack.persistent.XdSavedQueryKt;
import jetbrains.youtrack.persistent.security.BasicSecurityCacheKt;
import jetbrains.youtrack.persistent.security.SecurityCache;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001*\u00020\u00072\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\u0002*\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u0002*\u00020\u000b2\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\f\u001a\u00020\rH\u0007\u001a&\u0010\n\u001a\u0004\u0018\u00010\u0002*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\rH\u0007\u00a8\u0006\u0010"}, d2={"findByName", "", "Ljetbrains/youtrack/persistent/XdIssueTag;", "Ljetbrains/youtrack/persistent/XdIssueTag$Companion;", "name", "", "Ljetbrains/youtrack/persistent/XdSavedQuery;", "Ljetbrains/youtrack/persistent/XdSavedQuery$Companion;", "findQueryByName", "findTagByName", "getTag", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "createIfNotExists", "", "owner", "create", "youtrack-scripts"})
public final class IssueFolderExtentionsKt {
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Finds the most relevant saved search with the specified name that is visible to the current user.")
    @ApiDocReturns(value="The most relevant saved search.")
    @Nullable
    public static final XdSavedQuery findQueryByName(@NotNull XdSavedQuery.Companion $this$findQueryByName, @ApiDoc(value="The name of the saved search to search for.") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$findQueryByName, (String)"$this$findQueryByName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (XdSavedQuery)CollectionsKt.firstOrNull(IssueFolderExtentionsKt.findByName($this$findQueryByName, name));
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="\nFinds a list of saved searches with the specified name. The list only includes saved searches that are visible to the current user.\nThe saved searches that were created by the current user are returned at the top of the list.\n")
    @ApiDocReturns(value="A list of saved searches that match the specified name.")
    @NotNull
    public static final Iterable<XdSavedQuery> findByName(@NotNull XdSavedQuery.Companion $this$findByName, @ApiDoc(value="The name of the saved search to search for.") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$findByName, (String)"$this$findByName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return SequencesKt.asIterable((Sequence)XdSavedQueryKt.findVisibleQueries((XdUser)jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser(), (String)name, (SecurityCache)((SecurityCache)BasicSecurityCacheKt.getBasicSecurityCache())));
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Returns a tag that is visible to the user.")
    @ApiDocReturns(value="The tag.")
    @Nullable
    public static final XdIssueTag getTag(@NotNull XdUser $this$getTag, @ApiDoc(value="The name of the tag.") @NotNull String name, @ApiDoc(value="If `true` and the specified tag does not exist or is not visible to the user and the user has permission to create tags, a new tag with the specified name is created.") boolean createIfNotExists) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getTag, (String)"$this$getTag");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return jetbrains.charisma.service.BeansKt.getWatchFolderService().getTag($this$getTag, name, createIfNotExists);
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="\nFinds the most relevant tag with the specified name that is visible to the current user.\n\"Star\" tag is excluded from the results.\n")
    @ApiDocReturns(value="The most relevant tag.")
    @Nullable
    public static final XdIssueTag findTagByName(@NotNull XdIssueTag.Companion $this$findTagByName, @ApiDoc(value="The name of the tag to search for.") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$findTagByName, (String)"$this$findTagByName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (XdIssueTag)CollectionsKt.firstOrNull(IssueFolderExtentionsKt.findByName($this$findTagByName, name));
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="\nFinds a list of tags with the specified name. The list only includes tags that are visible to the current user.\nThe tags that were created by the current user are returned at the top of the list.\n\"Star\" tag is excluded from the results.\n")
    @ApiDocReturns(value="A list of tags that match the specified name.")
    @NotNull
    public static final Iterable<XdIssueTag> findByName(@NotNull XdIssueTag.Companion $this$findByName, @ApiDoc(value="The name of the tag to search for.") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$findByName, (String)"$this$findByName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return Intrinsics.areEqual((Object)name, (Object)BeansKt.getStarService().getStarName()) ? (Iterable)CollectionsKt.emptyList() : SequencesKt.asIterable((Sequence)XdIssueTagKt.findVisibleTags((XdUser)jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser(), (String)name, (SecurityCache)((SecurityCache)BasicSecurityCacheKt.getBasicSecurityCache())));
    }

    @ApiMethod(scopes={ApiScope.PLUGIN})
    @Nullable
    public static final XdIssueTag getTag(@NotNull XdIssueTag.Companion $this$getTag, @NotNull XdUser owner, @NotNull String name, boolean create2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getTag, (String)"$this$getTag");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return jetbrains.charisma.service.BeansKt.getWatchFolderService().getTag(owner, name, create2);
    }
}

