/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.gaprest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.gap.resource.Entity;
import jetbrains.gap.resource.Secured;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.scripts.log.ScriptLoggingEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\t\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/scripts/gaprest/ScriptLogEntry;", "Ljetbrains/gap/resource/Entity;", "Ljetbrains/gap/resource/Secured;", "event", "Ljetbrains/youtrack/scripts/log/ScriptLoggingEvent;", "(Ljetbrains/youtrack/scripts/log/ScriptLoggingEvent;)V", "id", "", "getId", "()Ljava/lang/String;", "level", "getLevel", "loggingEvent", "Lorg/apache/logging/log4j/core/LogEvent;", "getLoggingEvent", "()Lorg/apache/logging/log4j/core/LogEvent;", "message", "getMessage", "presentation", "getPresentation", "stacktrace", "", "getStacktrace", "()Ljava/util/List;", "timestamp", "", "getTimestamp", "()J", "username", "getUsername", "canAccess", "", "youtrack-scripts"})
public class ScriptLogEntry
extends Entity
implements Secured {
    @NotNull
    private final String id;
    @JsonIgnore
    private final ScriptLoggingEvent event;

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public final String getLevel() {
        String string = this.getLoggingEvent().getLevel().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loggingEvent.level.toString()");
        return string;
    }

    public final long getTimestamp() {
        return this.getLoggingEvent().getTimeMillis();
    }

    @Nullable
    public final String getUsername() {
        return (String)this.getLoggingEvent().getContextData().getValue("username");
    }

    @NotNull
    public final String getMessage() {
        Message message = this.getLoggingEvent().getMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"loggingEvent.message");
        String string = message.getFormattedMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loggingEvent.message.formattedMessage");
        return string;
    }

    @NotNull
    public final String getPresentation() {
        Message message = this.getLoggingEvent().getMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"loggingEvent.message");
        String string = message.getFormattedMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loggingEvent.message.formattedMessage");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getStacktrace() {
        List list;
        StackTraceElement[] stackTraceElementArray = this.getLoggingEvent().getThrown();
        if (stackTraceElementArray != null && (stackTraceElementArray = stackTraceElementArray.getStackTrace()) != null) {
            void $this$mapTo$iv$iv;
            StackTraceElement[] $this$map$iv = stackTraceElementArray;
            boolean $i$f$map = false;
            StackTraceElement[] stackTraceElementArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var6_6 = $this$mapTo$iv$iv;
            int n = ((void)var6_6).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = var6_6[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.toString();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final LogEvent getLoggingEvent() {
        return this.event.getLoggingEvent();
    }

    public boolean canAccess() {
        return BeansKt.getXdLoggedInUser().hasPermission(Permission.UPDATE_PROJECT);
    }

    public ScriptLogEntry(@NotNull ScriptLoggingEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.event = event;
        String string = new UUID(this.event.getOrdinal(), this.getTimestamp()).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID(event.ordinal.toLong(), timestamp).toString()");
        this.id = string;
    }

    public void assertAccess() {
        Secured.DefaultImpls.assertAccess((Secured)this);
    }

    public void assertDeleteAccess() {
        Secured.DefaultImpls.assertDeleteAccess((Secured)this);
    }

    public void assertUpdateAccess() {
        Secured.DefaultImpls.assertUpdateAccess((Secured)this);
    }

    public void assertUpdateAccess(@NotNull KProperty1<?, ?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        Secured.DefaultImpls.assertUpdateAccess((Secured)this, property);
    }

    public boolean canDelete() {
        return Secured.DefaultImpls.canDelete((Secured)this);
    }

    public boolean canUpdate() {
        return Secured.DefaultImpls.canUpdate((Secured)this);
    }

    public boolean canUpdateProperty(@NotNull KProperty1<?, ?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        return Secured.DefaultImpls.canUpdateProperty((Secured)this, property);
    }
}

