/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.loader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.scripts.loader.PackageDistribution;
import jetbrains.youtrack.scripts.loader.PackageInfo;
import jetbrains.youtrack.scripts.loader.ScriptSource;
import jetbrains.youtrack.scripts.persistent.XdPackageLanguage;
import jetbrains.youtrack.scripts.persistent.XdScript;
import jetbrains.youtrack.scripts.persistent.XdScriptPackage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 32\u00020\u0001:\u00013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u001cH\u0014J$\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020*2\u0006\u0010$\u001a\u00020\u001c2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,H\u0014J\u0010\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020,2\u0006\u0010%\u001a\u00020&H\u0002J\b\u00102\u001a\u00020\u000fH\u0004R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0007\"\u0004\b\u0017\u0010\u0004R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0007\"\u0004\b\u001a\u0010\u0004\u00a8\u00064"}, d2={"Ljetbrains/youtrack/scripts/loader/ScriptsLoader;", "", "scriptGroup", "", "(Ljava/lang/String;)V", "language", "getLanguage", "()Ljava/lang/String;", "setLanguage", "packages", "", "Ljetbrains/youtrack/scripts/loader/PackageDistribution;", "getPackages", "()Ljava/lang/Iterable;", "priority", "", "getPriority", "()I", "setPriority", "(I)V", "getScriptGroup", "scriptType", "getScriptType", "setScriptType", "version", "getVersion", "setVersion", "findOrCreatePackage", "Ljetbrains/youtrack/scripts/persistent/XdScriptPackage;", "name", "readOnly", "", "autoAttached", "load", "", "packageModified", "pkg", "updated", "", "packageProcessed", "processScript", "scriptSource", "Ljetbrains/youtrack/scripts/loader/ScriptSource;", "existingScript", "Ljetbrains/youtrack/scripts/persistent/XdScript;", "readString", "inputStream", "Ljava/io/InputStream;", "scriptModified", "script", "versionNumber", "Companion", "youtrack-scripts"})
public abstract class ScriptsLoader {
    @Nullable
    private String scriptType;
    private int priority;
    @Nullable
    private String version;
    @Nullable
    private String language;
    @NotNull
    private final String scriptGroup;
    private static final Pattern ptn;
    public static final Companion Companion;

    @Nullable
    public final String getScriptType() {
        return this.scriptType;
    }

    public final void setScriptType(@Nullable String string) {
        this.scriptType = string;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setPriority(int n) {
        this.priority = n;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@Nullable String string) {
        this.version = string;
    }

    @Nullable
    public final String getLanguage() {
        return this.language;
    }

    public final void setLanguage(@Nullable String string) {
        this.language = string;
    }

    public void load() {
        int versionNumber = this.versionNumber();
        Iterable<PackageDistribution> $this$forEach$iv = this.getPackages();
        boolean $i$f$forEach = false;
        Iterator<PackageDistribution> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            PackageDistribution element$iv;
            PackageDistribution packageDistr = element$iv = iterator.next();
            boolean bl = false;
            PackageInfo packageInfo = packageDistr.getInfo();
            boolean bl2 = false;
            boolean bl3 = false;
            PackageInfo it = packageInfo;
            boolean bl4 = false;
            XdScriptPackage xdScriptPackage = this.findOrCreatePackage(it.getName(), versionNumber, it.getYouTrackAttributes().getReadOnly(), it.getYouTrackAttributes().getAutoAttached());
            boolean bl5 = false;
            boolean bl6 = false;
            XdScriptPackage $this$apply = xdScriptPackage;
            boolean bl7 = false;
            if (Intrinsics.areEqual((Object)it.getTitle(), (Object)$this$apply.getTitle()) ^ true) {
                $this$apply.setTitle(it.getTitle());
                this.packageModified($this$apply, $this$apply.getUpdated());
            }
            XdScriptPackage pkg = xdScriptPackage;
            Iterable<ScriptSource> $this$forEach$iv2 = packageDistr.getScriptSources();
            boolean $i$f$forEach2 = false;
            Iterator<ScriptSource> iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                ScriptSource element$iv2;
                ScriptSource it2 = element$iv2 = iterator2.next();
                boolean bl8 = false;
                ScriptsLoader.processScript$default(this, it2, pkg, null, 4, null);
            }
            this.packageProcessed(pkg);
            LegacySupportKt.flush();
            Companion.getLogger().info((Function0)new Function0<String>(pkg){
                final /* synthetic */ XdScriptPackage $pkg;

                @NotNull
                public final String invoke() {
                    return "Package processed: " + this.$pkg.getName();
                }
                {
                    this.$pkg = xdScriptPackage;
                    super(0);
                }
            });
        }
    }

    @NotNull
    public abstract Iterable<PackageDistribution> getPackages();

    private final XdScriptPackage findOrCreatePackage(String name, int version, boolean readOnly, boolean autoAttached) {
        XdPackageLanguage pl = StringsKt.equals((String)XdPackageLanguage.Companion.getKT().getName(), (String)this.language, (boolean)true) ? XdPackageLanguage.Companion.getKT() : XdPackageLanguage.Companion.getJS();
        XdScriptPackage xdScriptPackage = Companion.findOrCreatePackage(name, version, readOnly);
        boolean bl = false;
        boolean bl2 = false;
        XdScriptPackage $this$apply = xdScriptPackage;
        boolean bl3 = false;
        if ($this$apply.isNew()) {
            $this$apply.setAutoAttach(autoAttached);
            $this$apply.setLanguage(pl);
        } else if (Intrinsics.areEqual((Object)((Object)$this$apply.getLanguage()), (Object)((Object)pl)) ^ true) {
            throw (Throwable)new IllegalStateException("Existing package is in " + (Object)((Object)$this$apply.getLanguage()) + " whereas declared package is in " + this.language);
        }
        return xdScriptPackage;
    }

    protected void processScript(@NotNull ScriptSource scriptSource, @NotNull XdScriptPackage pkg, @Nullable XdScript existingScript) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)scriptSource, (String)"scriptSource");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pkg), (String)"pkg");
        String name = scriptSource.getName();
        long updated2 = scriptSource.getUpdated();
        try {
            string = this.readString(scriptSource.getBody());
        }
        catch (IOException e) {
            Companion.getLogger().error((Throwable)e, (Function0)new Function0<String>(scriptSource){
                final /* synthetic */ ScriptSource $scriptSource;

                @NotNull
                public final String invoke() {
                    return "Failed to read script content. Script name: " + this.$scriptSource.getName();
                }
                {
                    this.$scriptSource = scriptSource;
                    super(0);
                }
            });
            return;
        }
        String scriptBody2 = string;
        XdScript xdScript = existingScript;
        if (xdScript == null) {
            xdScript = (XdScript)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdScript.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdScript, XdSearchingNode>(name, pkg){
                final /* synthetic */ String $name;
                final /* synthetic */ XdScriptPackage $pkg;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdScript it) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$name)).and($this$filter.eq((Comparable)((Object)it.getWorkflow().getName()), (Comparable)((Object)this.$pkg.getName())));
                }
                {
                    this.$name = string;
                    this.$pkg = xdScriptPackage;
                    super(2);
                }
            })));
        }
        XdScript script2 = xdScript;
        String action = null;
        if (script2 == null) {
            action = "Created new";
            XdScript.Companion.new((Function1)new Function1<XdScript, Unit>(this, name, scriptBody2, pkg, updated2){
                final /* synthetic */ ScriptsLoader this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ String $scriptBody;
                final /* synthetic */ XdScriptPackage $pkg;
                final /* synthetic */ long $updated;

                public final void invoke(@NotNull XdScript $this$new) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                    $this$new.setName(this.$name);
                    $this$new.setScript(this.$scriptBody);
                    this.$pkg.getRules().add((XdEntity)$this$new);
                    ScriptsLoader.access$scriptModified(this.this$0, $this$new, this.$updated);
                }
                {
                    this.this$0 = scriptsLoader;
                    this.$name = string;
                    this.$scriptBody = string2;
                    this.$pkg = xdScriptPackage;
                    this.$updated = l;
                    super(1);
                }
            });
        } else if (Intrinsics.areEqual((Object)scriptBody2, (Object)script2.getScript()) ^ true || Intrinsics.areEqual((Object)script2.getName(), (Object)name) ^ true) {
            action = "Modified";
            XdScript xdScript2 = script2;
            boolean bl = false;
            boolean bl2 = false;
            XdScript $this$apply = xdScript2;
            boolean bl3 = false;
            $this$apply.setName(name);
            $this$apply.setScript(scriptBody2);
            this.scriptModified($this$apply, updated2);
        } else {
            action = "Skipped (as not modified)";
        }
        Companion.getLogger().info(action + " script of type " + this.scriptGroup + " named " + scriptSource.getName());
    }

    public static /* synthetic */ void processScript$default(ScriptsLoader scriptsLoader, ScriptSource scriptSource, XdScriptPackage xdScriptPackage, XdScript xdScript, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processScript");
        }
        if ((n & 4) != 0) {
            xdScript = null;
        }
        scriptsLoader.processScript(scriptSource, xdScriptPackage, xdScript);
    }

    private final void scriptModified(XdScript script2, long updated2) {
        XdScript xdScript = script2;
        boolean bl = false;
        boolean bl2 = false;
        XdScript $this$apply = xdScript;
        boolean bl3 = false;
        $this$apply.setUpdated(updated2);
        $this$apply.setUpdatedBy(null);
        this.packageModified(script2.getWorkflow(), updated2);
    }

    private final void packageModified(XdScriptPackage pkg, long updated2) {
        XdScriptPackage xdScriptPackage = pkg;
        boolean bl = false;
        boolean bl2 = false;
        XdScriptPackage $this$apply = xdScriptPackage;
        boolean bl3 = false;
        if ($this$apply.getUpdated() < updated2) {
            $this$apply.setUpdated(updated2);
            $this$apply.setUpdatedBy(null);
        }
    }

    protected void packageProcessed(@NotNull XdScriptPackage pkg) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)pkg), (String)"pkg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readString(InputStream inputStream) throws IOException {
        Closeable closeable = new InputStreamReader(inputStream, "UTF-8");
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStreamReader it = (InputStreamReader)closeable;
            boolean bl2 = false;
            new InputStreamReader(inputStream, "UTF-8");
            StringWriter sw = new StringWriter();
            IOUtils.copy((Reader)it, (Writer)sw);
            String string = ScriptsLoader.Companion.modifyLinebreaks(sw.toString());
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    protected final int versionNumber() {
        String string = this.version;
        if (string == null) {
            return 0;
        }
        String v = string;
        StringTokenizer tokenizer = new StringTokenizer(v, ".");
        if (tokenizer.countTokens() != 3) {
            throw (Throwable)new IllegalArgumentException("Version " + v + " has invalid format. Should have three parts: Major.Minor.Bugfix");
        }
        return Integer.parseInt(tokenizer.nextToken()) * 10000000 + Integer.parseInt(tokenizer.nextToken()) * 100000 + Integer.parseInt(tokenizer.nextToken());
    }

    @NotNull
    public final String getScriptGroup() {
        return this.scriptGroup;
    }

    public ScriptsLoader(@NotNull String scriptGroup) {
        Intrinsics.checkParameterIsNotNull((Object)scriptGroup, (String)"scriptGroup");
        this.scriptGroup = scriptGroup;
    }

    static {
        Companion = new Companion(null);
        ptn = Pattern.compile("\r\n", 16);
    }

    public static final /* synthetic */ void access$scriptModified(ScriptsLoader $this, XdScript script2, long updated2) {
        $this.scriptModified(script2, updated2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/scripts/loader/ScriptsLoader$Companion;", "Lmu/KLogging;", "()V", "ptn", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "findOrCreatePackage", "Ljetbrains/youtrack/scripts/persistent/XdScriptPackage;", "name", "", "version", "", "readOnly", "", "modifyLinebreaks", "source", "youtrack-scripts"})
    public static final class Companion
    extends KLogging {
        private final String modifyLinebreaks(String source) {
            Pattern pattern = ptn;
            String string = source;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = pattern.matcher(string).replaceAll("\n");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ptn.matcher(source!!).replaceAll(\"\\n\")");
            return string2;
        }

        @NotNull
        public final XdScriptPackage findOrCreatePackage(@NotNull String name, int version, boolean readOnly) {
            XdScriptPackage xdScriptPackage;
            block5: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    xdScriptPackage = XdScriptPackage.Companion.find(name);
                    if (xdScriptPackage == null) break block4;
                    XdScriptPackage xdScriptPackage2 = xdScriptPackage;
                    boolean bl = false;
                    boolean bl2 = false;
                    XdScriptPackage it = xdScriptPackage2;
                    boolean bl3 = false;
                    xdScriptPackage = it.getVersion() == version ? xdScriptPackage2 : null;
                    if (xdScriptPackage == null) break block4;
                    xdScriptPackage2 = xdScriptPackage;
                    bl = false;
                    bl2 = false;
                    XdScriptPackage $this$apply = xdScriptPackage2;
                    boolean bl4 = false;
                    if ($this$apply.getReadOnly() != readOnly) {
                        $this$apply.setReadOnly(readOnly);
                    }
                    if ((xdScriptPackage = xdScriptPackage2) != null) break block5;
                }
                xdScriptPackage = XdScriptPackage.Companion.new((Function1)new Function1<XdScriptPackage, Unit>(name, readOnly, version){
                    final /* synthetic */ String $name;
                    final /* synthetic */ boolean $readOnly;
                    final /* synthetic */ int $version;

                    public final void invoke(@NotNull XdScriptPackage $this$new) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                        $this$new.setName(this.$name);
                        $this$new.setReadOnly(this.$readOnly);
                        $this$new.setVersion(this.$version);
                    }
                    {
                        this.$name = string;
                        this.$readOnly = bl;
                        this.$version = n;
                        super(1);
                    }
                });
            }
            return xdScriptPackage;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

