/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.scripts.log.ScriptLoggingEvent;
import jetbrains.youtrack.scripts.persistent.ScriptFullName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.core.LogEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="scriptLogCache")
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ#\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/scripts/log/RollingQueueScriptLogCachingAppender;", "", "()V", "maxCacheSize", "", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljetbrains/youtrack/scripts/log/ScriptLoggingEvent;", "rollingOrdinal", "Ljava/util/concurrent/atomic/AtomicInteger;", "append", "", "event", "Lorg/apache/logging/log4j/core/LogEvent;", "getEvents", "", "scriptFullName", "Ljetbrains/youtrack/scripts/persistent/ScriptFullName;", "from", "", "(Ljetbrains/youtrack/scripts/persistent/ScriptFullName;Ljava/lang/Long;)Ljava/util/List;", "stop", "youtrack-scripts"})
public final class RollingQueueScriptLogCachingAppender {
    private int maxCacheSize = 1024;
    private final ConcurrentLinkedQueue<ScriptLoggingEvent> queue = new ConcurrentLinkedQueue();
    private final AtomicInteger rollingOrdinal = new AtomicInteger(0);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ScriptLoggingEvent> getEvents(@NotNull ScriptFullName scriptFullName, @Nullable Long from) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)scriptFullName, (String)"scriptFullName");
        Iterable $this$filter$iv = this.queue;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ScriptLoggingEvent it = (ScriptLoggingEvent)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getScriptId(), (Object)scriptFullName.toString()) && (from == null || it.getTimestamp() >= from))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void append(@NotNull LogEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String scriptName = (String)event.getContextData().getValue("script_name");
        if (scriptName != null) {
            for (int extra = this.queue.size() - this.maxCacheSize; extra > 0; --extra) {
                this.queue.remove();
            }
            this.queue.add(new ScriptLoggingEvent(scriptName, event, this.rollingOrdinal.incrementAndGet()));
        }
    }

    public final void stop() {
        this.queue.clear();
    }
}

